/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.NormalizedObject;
import com.tplus.transform.runtime.PersistenceManager;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.handler.ITrigger;
import com.tplus.transform.runtime.handler.TriggerContext;
import java.util.Properties;

public class PersistenceTrigger
implements ITrigger {
    private TriggerContext cxt;

    public void setContext(TriggerContext cxt) {
        this.cxt = cxt;
    }

    public void onNewMessage(NormalizedObject obj, TransformContext tcxt) throws TransformException {
        try {
            PersistenceManager pm = this.cxt.getBusinessTransaction().getPersistenceManager();
            if (pm == null) {
                throw TransformException.createFormatted("SRT113");
            }
            pm.persist(obj);
        }
        catch (TransformException e) {
            throw e;
        }
        catch (Exception e) {
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT450", e.getMessage());
            tre.setDetail(e);
            throw tre;
        }
    }

    public Object execute(Properties props) throws TransformException {
        throw TransformException.createFormatted("SRT114");
    }

    public void onBatchStart(TransformContext tcxt) throws TransformException {
    }

    public void onBatchEnd(TransformContext tcxt) throws TransformException {
    }
}

