/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractDataObjectBase;
import com.tplus.transform.runtime.AbstractServiceElement;
import com.tplus.transform.runtime.AbstractValidationRules;
import com.tplus.transform.runtime.CustomFieldProcessingSupport;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.ExceptionHandler;
import com.tplus.transform.runtime.NormalizedObject;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;

public abstract class ProcessingRules
extends AbstractValidationRules {
    protected CustomFieldProcessingSupport fieldProcessingSupport;

    protected ProcessingRules(AbstractServiceElement serviceElement) {
        super(serviceElement);
    }

    private void trace(String operation) {
        if (this.isTraceEnabled()) {
            this.getLogger().trace(operation + " " + this.messageName);
        }
    }

    private void trace(String operation, String variant) {
        if (this.isTraceEnabled()) {
            this.getLogger().trace(operation + variant + " " + this.messageName);
        }
    }

    private void trace(String operation, String variant, String suboperation) {
        if (this.isTraceEnabled()) {
            this.getLogger().trace(operation + variant + "(" + suboperation + ")" + " " + this.messageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process(NormalizedObject inputObj, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException {
        try {
            this.setup(cxt);
            this.setExceptionHandler(exceptionHandler);
            this.process0(inputObj, cxt);
        }
        finally {
            this.teardown(cxt);
        }
    }

    protected void process0(NormalizedObject inputObj, TransformContext cxt) throws TransformException {
        this.preprocess(inputObj, cxt);
        this.validate(inputObj, cxt);
        this.postprocess(inputObj, cxt);
        this.checkNotNull(inputObj, cxt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preprocess(NormalizedObject nObj, TransformContext cxt) throws TransformException {
        this.setup(cxt);
        try {
            this.preprocess(nObj);
        }
        finally {
            this.teardown(cxt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postprocess(NormalizedObject nObj, TransformContext cxt) throws TransformException {
        this.setup(cxt);
        try {
            this.postprocess(nObj);
        }
        finally {
            this.teardown(cxt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validate(NormalizedObject nObj, TransformContext cxt) throws TransformException {
        this.setup(cxt);
        try {
            this.validate(nObj);
        }
        catch (RuntimeException e) {
            this.handleUnexpectedException(e);
        }
        finally {
            this.teardown(cxt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkNotNull(NormalizedObject nObj, TransformContext cxt) throws TransformException {
        this.setup(cxt);
        try {
            this.checkNotNull(nObj);
        }
        catch (RuntimeException e) {
            this.handleUnexpectedException(e);
        }
        finally {
            this.teardown(cxt);
        }
    }

    protected void preprocess(NormalizedObject nObj) throws TransformException {
    }

    protected void postprocess(NormalizedObject nObj) throws TransformException {
    }

    protected void validate(NormalizedObject nObj) throws TransformException {
    }

    protected void checkNotNull(NormalizedObject nObj) throws TransformException {
    }

    protected void assertNotNull(AbstractDataObjectBase obj, int index) throws TransformException {
        try {
            obj.assertNotNull(index);
        }
        catch (TransformException e) {
            this.getExceptionHandler().onException(e);
        }
    }

    protected void assertConstraints(DataObjectSection sec) throws TransformException {
        try {
            sec.assertConstraints();
        }
        catch (TransformException e) {
            this.getExceptionHandler().onException(e);
        }
    }

    protected Object customFieldProcessing(String customClass, String fldName, DataObject obj) throws TransformException {
        if (this.fieldProcessingSupport == null) {
            this.fieldProcessingSupport = new CustomFieldProcessingSupport(this.getClass().getClassLoader());
        }
        return this.fieldProcessingSupport.customProcessing(customClass, fldName, obj);
    }
}

