/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.lang.Wrapper;
import com.tplus.transform.runtime.PropertyMap;
import com.tplus.transform.runtime.PropertyMap2;
import com.tplus.transform.runtime.PropertyMapSubset;
import com.tplus.transform.runtime.collection.StringList;
import com.tplus.transform.util.MapUtils;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PropertyMapImpl
implements PropertyMap2 {
    List propertyList = new ArrayList();

    public Object getProperty(String name) {
        EntryImpl entry = this.getEntry(name);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public void setProperty(String name, Object value) {
        if (value == null) {
            this.removeProperty(name);
        } else {
            EntryImpl entry = new EntryImpl(name, value);
            int index = this.getEntryIndex(name);
            if (index != -1) {
                this.propertyList.set(index, entry);
            } else {
                this.addEntry(entry);
            }
        }
    }

    public void removeProperty(String name) {
        int index = this.getEntryIndex(name);
        if (index != -1) {
            EntryImpl entryImpl = (EntryImpl)this.propertyList.remove(index);
        }
    }

    public boolean hasProperty(String name) {
        EntryImpl entry = this.getEntry(name);
        return entry != null;
    }

    public Object getProperty(String name, Object defaultValue) {
        Object o = this.getProperty(name);
        if (o != null) {
            return o;
        }
        return defaultValue;
    }

    public long getLongProperty(String name, long defaultValue) {
        Number number = MapUtils.toNumber(this.getProperty(name));
        if (number != null) {
            return number.longValue();
        }
        return defaultValue;
    }

    public void setLongProperty(String name, long value) {
        this.setProperty(name, Wrapper.box(value));
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        Boolean b = MapUtils.toBoolean(this.getProperty(name));
        if (b != null) {
            return b;
        }
        return defaultValue;
    }

    public void setBooleanProperty(String name, boolean value) {
        this.setProperty(name, Wrapper.box(value));
    }

    public int getIntProperty(String name, int defaultValue) {
        Number number = MapUtils.toNumber(this.getProperty(name));
        if (number != null) {
            return number.intValue();
        }
        return defaultValue;
    }

    public void setIntProperty(String name, int value) {
        this.setProperty(name, Wrapper.box(value));
    }

    public double getDoubleProperty(String name, double defaultValue) {
        Number number = MapUtils.toNumber(this.getProperty(name));
        if (number != null) {
            return number.doubleValue();
        }
        return defaultValue;
    }

    public void setDoubleProperty(String name, double value) {
        this.setProperty(name, Wrapper.box(value));
    }

    public String getStringProperty(String name, String defaultValue) {
        Object o = this.getProperty(name);
        if (o != null) {
            return o.toString();
        }
        return defaultValue;
    }

    public void setStringProperty(String name, String value) {
        this.setProperty(name, value);
    }

    public Date getDateProperty(String name, Date defaultValue) {
        Object o = this.getProperty(name);
        if (o instanceof Date) {
            return (Date)o;
        }
        return defaultValue;
    }

    public void setDateProperty(String name, Date value) {
        this.setProperty(name, value);
    }

    public PropertyMap getProperties(String prefix) {
        return new PropertyMapSubset(this, prefix + ".");
    }

    public void putProperties(PropertyMap props) {
        StringList names = props.getPropertyNames();
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            this.setProperty(name, props.getProperty(name));
        }
    }

    private void addEntry(EntryImpl entry) {
        if (this.propertyList == null) {
            this.propertyList = new ArrayList();
        }
        this.propertyList.add(entry);
    }

    private EntryImpl getEntry(String name) {
        if (this.propertyList != null) {
            int searchCode = name.hashCode();
            int size = this.propertyList.size();
            for (int i = 0; i < size; ++i) {
                EntryImpl entry = (EntryImpl)this.propertyList.get(i);
                if (entry.getKeyHashCode() != searchCode || !entry.getName().equals(name)) continue;
                return entry;
            }
        }
        return null;
    }

    private int getEntryIndex(String name) {
        if (this.propertyList != null) {
            int searchCode = name.hashCode();
            int size = this.propertyList.size();
            for (int i = 0; i < size; ++i) {
                EntryImpl entry = (EntryImpl)this.propertyList.get(i);
                if (entry.getKeyHashCode() != searchCode || !entry.getName().equals(name)) continue;
                return i;
            }
        }
        return -1;
    }

    public int getPropertyCount() {
        return this.propertyList == null ? 0 : this.propertyList.size();
    }

    public void clearProperties() {
        this.propertyList.clear();
    }

    public void clear(String prefix) {
        Iterator iterator = this.propertyList.iterator();
        while (iterator.hasNext()) {
            EntryImpl entry = (EntryImpl)iterator.next();
            if (!entry.getName().startsWith(prefix)) continue;
            iterator.remove();
        }
    }

    public int size() {
        return this.getPropertyCount();
    }

    public List getEntries(String prefix) {
        ArrayList<EntryImpl> toRet = new ArrayList<EntryImpl>();
        for (int i = 0; i < this.propertyList.size(); ++i) {
            EntryImpl entry = (EntryImpl)this.propertyList.get(i);
            if (!entry.getName().startsWith(prefix)) continue;
            toRet.add(entry);
        }
        return toRet;
    }

    public StringList getPropertyNames() {
        return new StringList(){

            public void add(int index, String element) {
                throw new UnsupportedOperationException();
            }

            public String set(int index, String element) {
                throw new UnsupportedOperationException();
            }

            public String removeElementAt(int index) {
                throw new UnsupportedOperationException();
            }

            public Object get(int index) {
                EntryImpl entry = (EntryImpl)PropertyMapImpl.this.propertyList.get(index);
                return entry.getName();
            }

            public String getValue(int index) {
                return (String)this.get(index);
            }

            public int size() {
                return PropertyMapImpl.this.getPropertyCount();
            }
        };
    }

    public StringList getNames(String prefix) {
        StringList toRet = new StringList();
        for (int i = 0; i < this.propertyList.size(); ++i) {
            EntryImpl entry = (EntryImpl)this.propertyList.get(i);
            if (!entry.getName().startsWith(prefix)) continue;
            toRet.add(entry.getName());
        }
        return toRet;
    }

    public List getValues() {
        return new AbstractList(){

            public Object get(int index) {
                EntryImpl entry = (EntryImpl)PropertyMapImpl.this.propertyList.get(index);
                return entry.getValue();
            }

            public int size() {
                return PropertyMapImpl.this.getPropertyCount();
            }
        };
    }

    public StringList getPropertyNames(PropertyMap.PropertyNameFilter filter) {
        StringList keys = new StringList();
        for (String name : this.getPropertyNames()) {
            if (!filter.match(name)) continue;
            keys.add(name);
        }
        return keys;
    }

    public void setProperties(Map properties) {
        for (Map.Entry entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            this.setProperty(key, value);
        }
    }

    public String toString() {
        StringBuffer toRet = new StringBuffer();
        for (int i = 0; i < this.propertyList.size(); ++i) {
            EntryImpl entry = (EntryImpl)this.propertyList.get(i);
            if (i > 0) {
                toRet.append(",");
            }
            toRet.append(entry.toString());
        }
        return toRet.toString();
    }

    public Object clone() {
        try {
            PropertyMapImpl cloned = (PropertyMapImpl)super.clone();
            cloned.propertyList = new ArrayList();
            for (int i = 0; i < this.propertyList.size(); ++i) {
                EntryImpl entry = (EntryImpl)this.propertyList.get(i);
                cloned.propertyList.add(entry.clone());
            }
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public static class EntryImpl
    implements PropertyMap.Entry,
    Serializable,
    Cloneable {
        int hashCode;
        String name;
        Object value;

        public EntryImpl(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getKey() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (!(o instanceof PropertyMap.Entry)) {
                return false;
            }
            PropertyMap.Entry e = (PropertyMap.Entry)o;
            return EntryImpl.valEquals(this.name, e.getName()) && EntryImpl.valEquals(this.value, e.getValue());
        }

        private static boolean valEquals(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        public int hashCode() {
            int keyHash = this.name == null ? 0 : this.name.hashCode();
            int valueHash = this.value == null ? 0 : this.value.hashCode();
            return keyHash ^ valueHash;
        }

        public String toString() {
            return this.name + "=" + this.value;
        }

        public int getKeyHashCode() {
            if (this.hashCode == 0) {
                this.hashCode = this.name.hashCode();
            }
            return this.hashCode;
        }

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }
    }
}

