/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.PropertyMap;
import com.tplus.transform.runtime.PropertyMap2;
import com.tplus.transform.runtime.collection.StringList;
import java.util.Date;
import java.util.List;

class PropertyMapSubset
implements PropertyMap2 {
    private PropertyMap2 parent;
    private String prefix;

    PropertyMapSubset(PropertyMap2 parent, String prefix) {
        this.parent = parent;
        this.prefix = prefix;
    }

    public PropertyMap getProperties(String prefix) {
        return new PropertyMapSubset(this, prefix + ".");
    }

    public void putProperties(PropertyMap props) {
        if (props == this) {
            return;
        }
        StringList names = props.getPropertyNames();
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            this.setProperty(name, props.getProperty(name));
        }
    }

    public Object getProperty(String name) {
        return this.parent.getProperty(this.getQName(name));
    }

    public void setProperty(String name, Object value) {
        this.parent.setProperty(this.getQName(name), value);
    }

    public void removeProperty(String name) {
        this.parent.removeProperty(this.getQName(name));
    }

    public boolean hasProperty(String name) {
        return this.parent.hasProperty(this.getQName(name));
    }

    public Object getProperty(String name, Object defaultValue) {
        return this.parent.getProperty(this.getQName(name), defaultValue);
    }

    public long getLongProperty(String name, long defaultValue) {
        return this.parent.getLongProperty(this.getQName(name), defaultValue);
    }

    public void setLongProperty(String name, long value) {
        this.parent.setLongProperty(this.getQName(name), value);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        return this.parent.getBooleanProperty(this.getQName(name), defaultValue);
    }

    public void setBooleanProperty(String name, boolean value) {
        this.parent.setBooleanProperty(this.getQName(name), value);
    }

    public int getIntProperty(String name, int defaultValue) {
        return this.parent.getIntProperty(this.getQName(name), defaultValue);
    }

    public void setIntProperty(String name, int value) {
        this.parent.setIntProperty(this.getQName(name), value);
    }

    public double getDoubleProperty(String name, double defaultValue) {
        return this.parent.getDoubleProperty(this.getQName(name), defaultValue);
    }

    public void setDoubleProperty(String name, double value) {
        this.parent.setDoubleProperty(this.getQName(name), value);
    }

    public String getStringProperty(String name, String defaultValue) {
        return this.parent.getStringProperty(this.getQName(name), defaultValue);
    }

    public void setStringProperty(String name, String value) {
        this.parent.setStringProperty(this.getQName(name), value);
    }

    public Date getDateProperty(String name, Date defaultValue) {
        return this.parent.getDateProperty(this.getQName(name), defaultValue);
    }

    public void setDateProperty(String name, Date value) {
        this.parent.setDateProperty(this.getQName(name), value);
    }

    public StringList getPropertyNames() {
        StringList toRet = this.parent.getNames(this.prefix);
        for (int i = 0; i < toRet.size(); ++i) {
            String name = (String)toRet.get(i);
            toRet.set(i, name.substring(this.prefix.length()));
        }
        return toRet;
    }

    public StringList getPropertyNames(PropertyMap.PropertyNameFilter filter) {
        StringList toRet = this.parent.getNames(this.prefix);
        for (int i = 0; i < toRet.size(); ++i) {
            String name = (String)toRet.get(i);
            if (!filter.match(name)) continue;
            toRet.set(i, name.substring(this.prefix.length()));
        }
        return toRet;
    }

    public StringList getNames(String prefix) {
        StringList toRet = this.parent.getNames(this.prefix + prefix);
        for (int i = 0; i < toRet.size(); ++i) {
            String name = (String)toRet.get(i);
            toRet.set(i, name.substring(this.prefix.length()));
        }
        return toRet;
    }

    public int getPropertyCount() {
        return this.parent.getEntries(this.prefix).size();
    }

    public void clearProperties() {
        this.parent.clear(this.prefix);
    }

    public void clear(String prefix) {
        this.parent.clear(this.prefix + prefix);
    }

    public List getEntries(String prefix) {
        return this.parent.getEntries(this.prefix + prefix);
    }

    private String getQName(String name) {
        return this.prefix + name;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

