/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.lang.FastStringBuffer;
import com.tplus.transform.runtime.AbstractQueryDef;
import com.tplus.transform.runtime.DBDialect;
import com.tplus.transform.runtime.DatabaseMetaInfo;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.QueryDef;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.util.StringUtils;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class QueryDefImpl
extends AbstractQueryDef
implements QueryDef {
    private String preFieldsText = "";
    private String postFieldsText = "";
    private final String whereCondition;
    final String[] parameterNames;
    final String[] parameterTypes;
    final int paramCount;
    final int[] paramTransformIndexes;
    String selectClause = null;
    static final long serialVersionUID = 5053794282501561015L;

    public QueryDefImpl(String name, String tableName, DatabaseMetaInfo databaseMetaInfo, String whereCondition, String[] parameterNames, String[] parameterTypes, int[] paramTransformIndexes) {
        this(name, tableName, databaseMetaInfo, null, null, whereCondition, parameterNames, parameterTypes, paramTransformIndexes);
    }

    public QueryDefImpl(String name, String tableName, DatabaseMetaInfo databaseMetaInfo, String preFields, String postFields, String whereCondition, String[] parameterNames, String[] parameterTypes, int[] paramTransformIndexes) {
        super(name, tableName, databaseMetaInfo);
        this.preFieldsText = preFields;
        this.postFieldsText = postFields;
        this.whereCondition = whereCondition;
        this.parameterNames = parameterNames == null ? new String[]{} : parameterNames;
        this.parameterTypes = parameterTypes == null ? new String[]{} : parameterTypes;
        this.paramCount = this.parameterNames.length;
        this.paramTransformIndexes = paramTransformIndexes == null ? new int[]{} : paramTransformIndexes;
    }

    public String getPreFieldsText() {
        return this.preFieldsText;
    }

    public void setPreFieldsText(String preFieldsText) {
        this.preFieldsText = preFieldsText;
    }

    public String getPostFieldsText() {
        return this.postFieldsText;
    }

    public void setPostFieldsText(String postFieldsText) {
        this.postFieldsText = postFieldsText;
    }

    public int getParameterCount() {
        return this.paramCount;
    }

    public String[] getParameters() {
        return this.parameterNames;
    }

    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    String getSelectClause() {
        if (this.selectClause == null) {
            String selectClause;
            String tableAliasName = this.getTableAliasName();
            String post = this.getSelectTableName();
            if (StringUtils.isNotEmpty(this.postFieldsText)) {
                post = this.postFieldsText;
            }
            String pre = StringUtils.fixNull(this.preFieldsText);
            this.selectClause = selectClause = "SELECT " + pre + " " + this.databaseMetaInfo.toAllFieldsStr(tableAliasName) + " FROM " + post;
        }
        return this.selectClause;
    }

    public static String getSelectRangeClause(int start, int count, String selectClause, DBDialect dialect, DatabaseMetaData databaseMetaData) throws TransformException {
        if (start < 0) {
            throw new TransformException("Start cannnot be negative value '" + start + "'");
        }
        if (count < 0) {
            throw new TransformException("Count cannnot be negative value '" + count + "'.");
        }
        if (dialect == DBDialect.HSQL) {
            selectClause = selectClause.substring(0, 6) + " LIMIT " + start + ", " + count + " " + selectClause.substring(7);
        } else if (dialect == DBDialect.ORACLE) {
            selectClause = "select * from (select a.*, ROWNUM rnum from(" + selectClause + ") a  where rownum <" + (++start + count) + ") where rnum >=" + start;
        } else if (dialect == DBDialect.DB2) {
            if (start != 0) {
                count += start;
                ++start;
            }
            selectClause = selectClause.trim();
            selectClause = selectClause.substring(0, 6) + " row_number() " + "OVER ()   AS rid, " + selectClause.substring(7);
            selectClause = "SELECT * FROM (" + selectClause + ") AS t WHERE t.rid BETWEEN " + start + " AND " + count;
        } else if (dialect == DBDialect.MYSQL) {
            selectClause = selectClause + " LIMIT " + start + ", " + count;
        } else if (dialect == DBDialect.MSSQL) {
            selectClause = QueryDefImpl.getMSSQLServerSpecificQuery(selectClause, databaseMetaData, start, count);
        } else if (dialect == DBDialect.POSTGRES) {
            selectClause = selectClause + " OFFSET " + start + " LIMIT " + count;
        }
        return selectClause;
    }

    String getSelectRangeClause(int start, int count, DBDialect dialect, DatabaseMetaData databaseMetaData) throws TransformException {
        String tableAliasName = this.getTableAliasName();
        String post = this.getSelectTableName();
        if (StringUtils.isNotEmpty(this.postFieldsText)) {
            post = this.postFieldsText;
        }
        String pre = StringUtils.fixNull(this.preFieldsText);
        String selectClause = "SELECT " + pre + " " + this.databaseMetaInfo.toAllFieldsStr(tableAliasName) + " FROM " + post + " " + tableAliasName + " " + this.whereCondition;
        if (dialect == DBDialect.HSQL) {
            selectClause = selectClause.substring(0, 6) + " LIMIT " + start + ", " + count + selectClause.substring(7);
        } else if (dialect == DBDialect.ORACLE) {
            selectClause = "select * from(select a.*, ROWNUM rnum from(" + selectClause + ") a where rownum <" + (++start + count) + ") where rnum >=" + start;
        } else if (dialect == DBDialect.DB2) {
            if (start != 0) {
                count += start;
                ++start;
            }
            selectClause = "SELECT * FROM (SELECT " + pre + " row_number() " + "OVER () AS rid, " + this.databaseMetaInfo.toAllFieldsStr(tableAliasName) + " FROM " + post + " " + tableAliasName + " " + this.whereCondition + ") AS t WHERE t.rid BETWEEN " + start + " AND " + count;
        } else if (dialect == DBDialect.MYSQL) {
            selectClause = selectClause + " LIMIT " + start + ", " + count;
        } else if (dialect == DBDialect.MSSQL) {
            selectClause = QueryDefImpl.getMSSQLServerSpecificQuery(selectClause, databaseMetaData, start, count);
        } else if (dialect == DBDialect.POSTGRES) {
            selectClause = selectClause + " OFFSET " + start + " LIMIT " + count;
        }
        return selectClause;
    }

    String getSelectCountClause() {
        String post = this.getSelectTableName();
        if (StringUtils.isNotEmpty(this.postFieldsText)) {
            post = this.postFieldsText;
        }
        String pre = StringUtils.fixNull(this.preFieldsText);
        String selectCountClause = "SELECT " + pre + " " + "count(*)" + " FROM " + post;
        return selectCountClause;
    }

    public static String getMSSQLServerSpecificQuery(String selectClause, DatabaseMetaData databaseMetaData, int start, int count) throws TransformException {
        if (selectClause.trim().toLowerCase().contains("select top")) {
            throw new TransformException("'Top' cannot be used with limit query function[s]");
        }
        boolean mssql2012 = true;
        try {
            if (databaseMetaData != null && databaseMetaData.getDatabaseMajorVersion() < 11) {
                mssql2012 = false;
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        if (mssql2012) {
            String orderClause = selectClause.toLowerCase().contains("order by") ? "" : " ORDER BY (SELECT NULL)";
            selectClause = selectClause + orderClause + " OFFSET " + start + " ROWS FETCH NEXT " + count + " ROWS ONLY";
        } else {
            if (start != 0) {
                count += start;
                ++start;
            }
            selectClause = "SELECT * FROM ( SELECT ROW_NUMBER() OVER(ORDER BY (SELECT NULL)) AS row, t1.* FROM ( " + selectClause + ") t1) t2 " + "WHERE t2.row BETWEEN " + start + " AND " + count;
        }
        return selectClause;
    }

    private String getTableAliasName() {
        return StringUtils.rightStr(this.tableName, ".");
    }

    private String getSelectTableName() {
        String post = this.postFieldsText;
        if (StringUtils.isEmpty(post)) {
            post = this.tableName;
        }
        return post;
    }

    public String getSQL() {
        String tableAliasName = this.getTableAliasName();
        String sql = this.getSelectClause() + " " + tableAliasName + " " + this.whereCondition;
        return sql;
    }

    public String getSQLRange(int start, int count, DBDialect dialect, DatabaseMetaData databaseMetaData) throws TransformException {
        String sql = this.getSelectRangeClause(start, count, dialect, databaseMetaData);
        return sql;
    }

    public String getCountSQL() {
        String tableAliasName = this.getTableAliasName();
        String sql = this.getSelectCountClause() + " " + tableAliasName + " " + this.whereCondition;
        return sql;
    }

    public Object[] translateParams(Map params) throws TransformException {
        if (params == null) {
            params = new HashMap();
        }
        if (params.size() != this.paramCount) {
            throw TransformException.createFormatted("SRT112", new Object[]{this.name, String.valueOf(this.paramCount), String.valueOf(params.size())});
        }
        Object[] transformedParams = new Object[this.paramTransformIndexes.length];
        for (int i = 0; i < this.paramTransformIndexes.length; ++i) {
            int paramTransformIndex = this.paramTransformIndexes[i];
            String paramName = this.parameterNames[paramTransformIndex];
            String type = this.parameterTypes[paramTransformIndex];
            Object paramValue = params.get(paramName);
            paramValue = this.toSQLParam(paramValue, type);
            transformedParams[i] = paramValue;
        }
        return transformedParams;
    }

    public Object[] translateParams(Object[] params) throws TransformException {
        if (params == null) {
            params = new Object[]{};
        }
        if (params.length != this.paramCount) {
            throw TransformException.createFormatted("SRT112", new Object[]{this.name, String.valueOf(this.paramCount), String.valueOf(params.length)});
        }
        Object[] transformedParams = new Object[this.paramTransformIndexes.length];
        for (int i = 0; i < this.paramTransformIndexes.length; ++i) {
            int paramTransformIndex = this.paramTransformIndexes[i];
            String paramName = this.parameterNames[paramTransformIndex];
            String type = this.parameterTypes[paramTransformIndex];
            Object paramValue = params[paramTransformIndex];
            transformedParams[i] = paramValue = this.toSQLParam(paramValue, type);
        }
        return transformedParams;
    }

    Object toSQLParam(Object paramValue, String type) throws TransformException {
        DesignerType designerType = DesignerType.valueOf(type);
        if (!(designerType.isValueAssignable(paramValue) || designerType.isNumeric() && paramValue instanceof Number)) {
            throw TransformException.createFormatted("SRT115", new Object[]{this.name, type, paramValue});
        }
        if (DesignerType.DESIGNER_CHAR_TYPE.equals(designerType)) {
            paramValue = paramValue.toString();
        } else if (DesignerType.DESIGNER_DATE_TIME_TYPE.equals(designerType)) {
            paramValue = new Timestamp(((Date)paramValue).getTime());
        } else if (DesignerType.DESIGNER_TIME_ONLY_TYPE.equals(designerType)) {
            paramValue = new Time(((Date)paramValue).getTime());
        } else if (DesignerType.DESIGNER_DATE_ONLY_TYPE.equals(designerType)) {
            paramValue = new java.sql.Date(((Date)paramValue).getTime());
        } else if (DesignerType.DESIGNER_ISO_DATE_TIME_TYPE.equals(designerType)) {
            paramValue = new Timestamp(((Calendar)paramValue).getTime().getTime());
        } else if (DesignerType.DESIGNER_ISO_TIME_TYPE.equals(designerType)) {
            paramValue = new Time(((Calendar)paramValue).getTime().getTime());
        } else if (DesignerType.DESIGNER_ISO_DATE_TYPE.equals(designerType)) {
            paramValue = new java.sql.Date(((Calendar)paramValue).getTime().getTime());
        }
        return paramValue;
    }

    public String toString() {
        FastStringBuffer str = new FastStringBuffer(this.name);
        str.append("(");
        for (int i = 0; i < this.parameterNames.length; ++i) {
            if (i > 0) {
                str.append(", ");
            }
            str.append(this.parameterTypes[i]).append(" ").append(this.parameterNames[i]);
        }
        str.append(")");
        return str.toString();
    }
}

