/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.BusinessTransaction;
import com.tplus.transform.runtime.NormalizedObject;
import com.tplus.transform.runtime.NormalizedObjectCollection;
import com.tplus.transform.runtime.OutputFormat;
import com.tplus.transform.runtime.PersistenceManager;
import com.tplus.transform.runtime.Query;
import com.tplus.transform.runtime.QueryDef;
import com.tplus.transform.runtime.TransformContextImpl;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.handler.TriggerAdapter;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.naming.NamingException;

public class QueryReportTrigger
extends TriggerAdapter {
    public static final String QUERY_PROPERTY_NAME = "query";

    public Object execute(Properties props) throws TransformException {
        try {
            String outputFormatName = props.getProperty("output.format");
            String outputProtocolName = props.getProperty("output.protocol");
            String outputDeviceName = props.getProperty("output.device");
            String queryName = props.getProperty(QUERY_PROPERTY_NAME);
            BusinessTransaction bt = this.cxt.getBusinessTransaction();
            PersistenceManager pm = bt.getPersistenceManager();
            QueryDef queryDef = pm.getQuery(queryName);
            String[] params = queryDef.getParameters();
            Query query = new Query(queryDef.getName());
            for (int i = 0; i < params.length; ++i) {
                String value = props.getProperty(params[i]);
                query.addParameter(params[i], value);
            }
            NormalizedObjectCollection nobjs = pm.find(query);
            this.prepareReport(nobjs, outputFormatName, outputProtocolName, outputDeviceName);
        }
        catch (RemoteException e) {
            TransformRuntimeException te = TransformRuntimeException.createFormatted("SRT110", e.getMessage());
            te.setDetail(e);
            throw te;
        }
        catch (NamingException e) {
            TransformRuntimeException te = TransformRuntimeException.createFormatted("SRT111", e.getMessage());
            te.setDetail(e);
            throw te;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareReport(NormalizedObjectCollection nobjs, String outputFormatName, String outputProtocolName, String outputDeviceName) throws TransformException, NamingException, RemoteException {
        OutputFormat outputFormat = this.getOutputFormat(outputFormatName);
        TransformContextImpl tcxt = new TransformContextImpl();
        tcxt.createBatchContext();
        tcxt.setProperty("input.source", "Report" + Math.random());
        tcxt.setProperty("output.format", outputFormatName);
        tcxt.setProperty("output.protocol", outputProtocolName);
        tcxt.setProperty("output.device", outputDeviceName);
        outputFormat.writeBatchStart(tcxt);
        try {
            for (int i = 0; i < nobjs.getElementCount(); ++i) {
                NormalizedObject nobj = (NormalizedObject)nobjs.getElement(i);
                outputFormat.write(nobj, tcxt);
            }
        }
        finally {
            outputFormat.writeBatchEnd(tcxt);
        }
    }
}

