/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectMetaInfoImpl;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.ExceptionHandler;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.InternalMessage;
import com.tplus.transform.runtime.LookupContext;
import com.tplus.transform.runtime.LookupContextFactory;
import com.tplus.transform.runtime.NormalizedObject;
import com.tplus.transform.runtime.SectionMetaInfoImpl;
import com.tplus.transform.runtime.SimpleGenericDataObject;
import com.tplus.transform.runtime.StringInputSource;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformContextImpl;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.xml.DataObjectXMLParserImpl;
import com.tplus.transform.util.IOUtil;
import java.rmi.RemoteException;
import java.util.List;
import javax.naming.NamingException;

public class Resource {
    public static DataObject parseMessage(String data, String messageName) throws TransformException {
        try {
            InternalMessage internalMessage = Resource.lookupInternalMessage(messageName);
            DataObject dataObject = internalMessage.parse(new StringInputSource(data), (TransformContext)new TransformContextImpl());
            return dataObject;
        }
        catch (RemoteException e) {
            throw new TransformRuntimeException("Error parsing resource of type " + messageName, e);
        }
        catch (NamingException e) {
            throw new TransformRuntimeException("Error parsing resource of type " + messageName, e);
        }
    }

    public static DataObjectSection parseMessages(String data, String messageName) throws TransformException {
        try {
            DataObject object = Resource.createInternalMessageWrapperObject(messageName);
            DataObjectXMLParserImpl dataObjectXMLParser = new DataObjectXMLParserImpl();
            ExceptionHandler.CascadingExceptionHandler cascadingExceptionHandler = new ExceptionHandler.CascadingExceptionHandler();
            dataObjectXMLParser.parse(object, cascadingExceptionHandler, new StringInputSource(data), null);
            List exceptions = cascadingExceptionHandler.getExceptions();
            if (exceptions.size() > 0) {
                TransformException transformException = new TransformException(exceptions);
                throw transformException;
            }
            DataObjectSection dataObjectSection = object.getSection(0);
            return dataObjectSection;
        }
        catch (RemoteException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        catch (NamingException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
    }

    public static String getResourceAsString(Class cls, String resourceName) throws TransformException {
        try {
            return IOUtil.readStreamAsString(cls, resourceName);
        }
        catch (Exception e) {
            throw new TransformException(e.getMessage(), e);
        }
    }

    private static InternalMessage lookupInternalMessage(String messageName) throws NamingException {
        LookupContext lookupContext = LookupContextFactory.getLookupContext();
        return lookupContext.lookupInternalMessage(messageName);
    }

    private static DataObject createInternalMessageWrapperObject(String messageName) throws RemoteException, NamingException, TransformException {
        final InternalMessage internalMessage = Resource.lookupInternalMessage(messageName);
        NormalizedObject normalizedObject = internalMessage.createNormalizedObject();
        DataObjectMetaInfoImpl info = new DataObjectMetaInfoImpl(messageName + "List", new FieldMetaInfo[]{new SectionMetaInfoImpl(normalizedObject.getMetaInfo(), messageName)});
        SimpleGenericDataObject object = new SimpleGenericDataObject(info){

            public DataObject createSectionElement(int secIndex, DataObjectSection dataObjectSection) throws FieldNotFoundException {
                try {
                    return internalMessage.createNormalizedObject();
                }
                catch (RemoteException e1) {
                    e1.printStackTrace();
                    return null;
                }
            }
        };
        return object;
    }
}

