/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractTrigger;
import com.tplus.transform.runtime.NormalizedObject;
import com.tplus.transform.runtime.OutputFormat;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import java.rmi.RemoteException;

public class RouterTrigger
extends AbstractTrigger {
    public void onBatchStart(TransformContext tcxt) throws TransformException {
        try {
            tcxt = this.getTransformContext(tcxt);
            String outputFormatName = (String)tcxt.getProperty("output.format");
            OutputFormat outputFormat = this.getOutputFormat(outputFormatName);
            outputFormat.writeBatchStart(tcxt);
        }
        catch (RemoteException e) {
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT450", e.getMessage());
            tre.setDetail(e);
            throw tre;
        }
    }

    public void onNewMessage(NormalizedObject obj, TransformContext tcxt) throws TransformException {
        try {
            tcxt = this.getTransformContext(tcxt);
            String outputFormatName = (String)tcxt.getProperty("output.format");
            OutputFormat outputFormat = this.getOutputFormat(outputFormatName);
            outputFormat.write(obj, tcxt);
        }
        catch (RemoteException e) {
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT450", e.getMessage());
            tre.setDetail(e);
            throw tre;
        }
    }

    public void onBatchEnd(TransformContext tcxt) throws TransformException {
        try {
            tcxt = this.getTransformContext(tcxt);
            OutputFormat outputFormat = this.getOutputFormat((String)tcxt.getProperty("output.format"));
            outputFormat.writeBatchEnd(tcxt);
        }
        catch (RemoteException e) {
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT450", e.getMessage());
            tre.setDetail(e);
            throw tre;
        }
    }
}

