/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DataObjectSectionImpl;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.SectionIndex;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class SectionIndexImpl
implements SectionIndex {
    private String indexedField;
    private DataObjectSection section;
    transient Map map;
    transient ElementComparatorSingle elementComparatorSingle;
    private SectionIndex nextIndex = SectionIndex.NO_OP;

    public SectionIndexImpl(DataObjectSection section, String name) {
        this.section = section;
        this.setIndexedField(name);
    }

    public void setIndexedField(String name) {
        this.indexedField = name;
        this.reindex();
    }

    private void reindex() {
        this.elementComparatorSingle = new ElementComparatorSingle(this.indexedField);
        this.map = new TreeMap(this.elementComparatorSingle);
        int size = this.section.size();
        for (int i = 0; i < size; ++i) {
            DataObject object = (DataObject)this.section.get(i);
            this.add(object);
        }
    }

    public void add(DataObject elm) {
        Object key = this.elementComparatorSingle.getFieldValue(elm);
        DataObject oldValue = this.map.put(key, elm);
        if (oldValue != null) {
            ArrayList<DataObject> entries;
            if (oldValue instanceof List) {
                entries = (ArrayList<DataObject>)((Object)oldValue);
            } else {
                entries = new ArrayList<DataObject>();
                entries.add(oldValue);
            }
            entries.add(elm);
            this.map.put(key, entries);
        }
        this.nextIndex.add(elm);
    }

    public void remove(DataObject toRemove) throws FieldNotFoundException {
        Object key = this.elementComparatorSingle.getFieldValue(toRemove);
        Object removedValue = this.map.remove(key);
        if (removedValue != toRemove && removedValue instanceof List) {
            List entries = (List)removedValue;
            entries.remove(toRemove);
            this.map.put(key, entries);
        }
        this.nextIndex.remove(toRemove);
    }

    public void addAll(DataObjectSection collection) {
        for (int i = 0; i < collection.getElementCount(); ++i) {
            DataObject obj = collection.getElement(i);
            this.add(obj);
        }
        this.nextIndex.addAll(collection);
    }

    public void clear() {
        this.map.clear();
        this.nextIndex.clear();
    }

    public void setNextIndex(SectionIndex newIndex) {
        if (this.nextIndex instanceof SectionIndex.NoOpIndex) {
            this.nextIndex = newIndex;
        } else {
            this.nextIndex.setNextIndex(newIndex);
        }
    }

    public SectionIndex getIndexFor(String fieldName) {
        if (fieldName.equals(this.elementComparatorSingle.fieldName)) {
            return this;
        }
        return this.nextIndex.getIndexFor(fieldName);
    }

    public DataObjectSection findElementsWithValue(String fieldName, Object value) {
        DataObject parent = this.section.getParent();
        String name = this.section.getName();
        DataObjectSectionImpl toRet = new DataObjectSectionImpl(parent, name, 0, -1);
        Object values = this.map.get(value);
        if (values != null) {
            if (values instanceof List) {
                toRet.addAll((List)values);
            } else {
                toRet.addElement((DataObject)values);
            }
        }
        return toRet;
    }

    public DataObject findElementWithValue(String fieldName, Object value) {
        DataObject toRet = null;
        Object values = this.map.get(value);
        if (values != null) {
            if (values instanceof List) {
                List list = (List)values;
                if (list.size() > 0) {
                    toRet = (DataObject)list.get(0);
                }
            } else {
                toRet = (DataObject)values;
            }
        }
        return toRet;
    }

    public List getUniqueValues(String fieldName) {
        DesignerType type = this.elementComparatorSingle.getFieldType();
        List list = type.createValueList();
        list.addAll(this.map.keySet());
        return list;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.reindex();
    }

    class ElementComparatorSingle
    implements Comparator,
    Serializable {
        int fieldIndex;
        String fieldName;
        DesignerType fieldType;

        public ElementComparatorSingle(String fieldName) {
            this.fieldName = fieldName;
            this.fieldIndex = -1;
        }

        public DesignerType getFieldType() {
            return this.fieldType;
        }

        Object getFieldValue(DataObject obj) {
            return obj.getField(this.getFieldIndex(obj));
        }

        public int getFieldIndex(DataObject obj) {
            if (this.fieldIndex == -1) {
                DataObjectMetaInfo info = obj.getMetaInfo();
                FieldMetaInfo fieldMetaInfo = info.getFieldMetaInfo(this.fieldName);
                this.fieldIndex = fieldMetaInfo.getIndex();
                this.fieldType = fieldMetaInfo.getDesignerType();
            }
            return this.fieldIndex;
        }

        public int compare(Object o1, Object o2) {
            Comparable fld1 = (Comparable)o1;
            Comparable fld2 = (Comparable)o2;
            if (fld1 == null && fld2 == null) {
                return 0;
            }
            if (fld1 == null) {
                return -1;
            }
            if (fld2 == null) {
                return 1;
            }
            return fld1.compareTo(fld2);
        }

        public boolean equals(Object o1, Object o2) {
            Comparable fld1 = (Comparable)o1;
            Comparable fld2 = (Comparable)o2;
            if (fld1 == null && fld2 == null) {
                return true;
            }
            if (fld1 == null) {
                return false;
            }
            if (fld2 == null) {
                return false;
            }
            return fld1.equals(fld2);
        }

        public int hashcode(Object fld1) {
            if (fld1 == null) {
                return 0;
            }
            return fld1.hashCode();
        }
    }
}

