/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.SectionListener;
import com.tplus.transform.runtime.SectionMatcher;
import com.tplus.transform.runtime.TransformException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SectionWatcher {
    SectionListener sectionListener;
    List sectionMatchers = new ArrayList();
    MatchInfo lastMatchInfo = null;
    private DataObject messageObject;

    public void clear() {
        for (int i = 0; i < this.sectionMatchers.size(); ++i) {
            MatchInfo matchInfo = (MatchInfo)this.sectionMatchers.get(i);
            matchInfo.clear();
        }
    }

    public SectionListener getSectionListener() {
        return this.sectionListener;
    }

    public void setSectionListener(SectionListener sectionListener) {
        this.sectionListener = sectionListener;
    }

    public void addSectionMatcher(SectionMatcher sectionMatcher) {
        this.sectionMatchers.add(new MatchInfo(sectionMatcher));
    }

    public void onSectionStart(String sectionName, Object otherId, DataObject currentObject, List allErrors) {
        for (int i = 0; i < this.sectionMatchers.size(); ++i) {
            MatchInfo matchInfo = (MatchInfo)this.sectionMatchers.get(i);
            if (!matchInfo.sectionMatcher.matches(sectionName, currentObject, otherId)) continue;
            matchInfo.lastExceptionCount = this.lastMatchInfo != null ? this.lastMatchInfo.lastExceptionCount : 0;
            this.lastMatchInfo = matchInfo;
            matchInfo.object = currentObject;
        }
    }

    public boolean onSectionEnd(String sectionName, Object otherId, DataObject currentObject, List allErrors) throws TransformException {
        for (int i = 0; i < this.sectionMatchers.size(); ++i) {
            int endExceptionCount;
            MatchInfo matchInfo = (MatchInfo)this.sectionMatchers.get(i);
            if (matchInfo.object != currentObject) continue;
            int lastExceptionCount = matchInfo.lastExceptionCount;
            matchInfo.lastExceptionCount = endExceptionCount = allErrors != null ? allErrors.size() : 0;
            List objectErrors = Collections.EMPTY_LIST;
            if (endExceptionCount > lastExceptionCount) {
                objectErrors = allErrors.subList(lastExceptionCount, endExceptionCount);
                objectErrors = new ArrayList(objectErrors);
            }
            return this.sectionListener.sectionCompleted(sectionName, currentObject, objectErrors);
        }
        return true;
    }

    public DataObject getMessageObject() {
        return this.messageObject;
    }

    public void setMessageObject(DataObject messageObject) {
        this.messageObject = messageObject;
    }

    static class MatchInfo {
        SectionMatcher sectionMatcher;
        int lastExceptionCount = 0;
        public DataObject object;

        MatchInfo(SectionMatcher sectionMatcher) {
            this.sectionMatcher = sectionMatcher;
        }

        public void clear() {
            this.lastExceptionCount = 0;
            this.object = null;
        }
    }
}

