/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.FieldParsingException;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformNestableException;
import com.tplus.transform.runtime.log.LogFactory;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.naming.NamingException;

public class StandardRuntimeResource {
    static Map resourceBundles = new HashMap();

    static ResourceBundle getResourceBundle(Class cls) {
        String packageName = StandardRuntimeResource.getPackageName(cls);
        return StandardRuntimeResource.getResourceBundle(packageName, cls.getClassLoader());
    }

    static ResourceBundle getResourceBundle(String packageName, ClassLoader loader) {
        ResourceBundle rsrc = (ResourceBundle)resourceBundles.get(packageName);
        if (rsrc == null) {
            rsrc = ResourceBundle.getBundle(packageName + ".message", Locale.getDefault(), loader);
            resourceBundles.put(packageName, rsrc);
        }
        return rsrc;
    }

    public static String getMessage(Class cls, String messageId) {
        ResourceBundle rsrc = StandardRuntimeResource.getResourceBundle(cls);
        String message = rsrc.getString(messageId + ".message");
        return message;
    }

    public static String getErrorCode(Class cls, String messageId) {
        ResourceBundle rsrc = StandardRuntimeResource.getResourceBundle(cls);
        String code = rsrc.getString(messageId + ".code");
        return code;
    }

    public static String getErrorClassification(Class cls, String messageId) {
        try {
            ResourceBundle rsrc = StandardRuntimeResource.getResourceBundle(cls);
            String type = rsrc.getString(messageId + ".type");
            return type;
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public static String getFormattedMessage(Class cls, String messageId, Object[] args) {
        String messageTemplate = StandardRuntimeResource.getMessage(cls, messageId);
        String message = "Unknown Error";
        if (messageTemplate != null) {
            message = MessageFormat.format(messageTemplate, args);
        }
        return message;
    }

    public static TransformNestableException createFormatted(Class exceptionClass, String messageId) {
        return StandardRuntimeResource.createFormatted(exceptionClass, messageId, new Object[0]);
    }

    public static TransformNestableException createFormatted(Class exceptionClass, String messageId, String arg) {
        return StandardRuntimeResource.createFormatted(exceptionClass, messageId, new Object[]{arg});
    }

    public static TransformNestableException createFormatted(Class exceptionClass, String messageId, Object[] args) {
        return StandardRuntimeResource.createFormatted(exceptionClass, exceptionClass, messageId, args);
    }

    public static TransformNestableException createFormatted(Class locationClass, Class exceptionClass, String messageId, Object[] args) {
        String message = StandardRuntimeResource.getFormattedMessage(locationClass, messageId, args);
        String errorCode = StandardRuntimeResource.getErrorCode(locationClass, messageId);
        TransformNestableException e = StandardRuntimeResource.create(exceptionClass, message, errorCode);
        e.setContextProperty("Internal-Code", messageId);
        return e;
    }

    public static TransformNestableException create(Class exceptionClass, String message, String errorCode) {
        Constructor cons = null;
        try {
            cons = exceptionClass.getConstructor(String.class);
        }
        catch (NoSuchMethodException nsme) {
            LogFactory.log.unexpectedError(nsme);
            return new TransformException();
        }
        TransformNestableException e = null;
        try {
            e = (TransformNestableException)cons.newInstance(message);
            e.setErrorCode(errorCode);
        }
        catch (InstantiationException ex) {
            LogFactory.log.unexpectedError(ex);
            return StandardRuntimeResource.createTransformException0(message, errorCode, ex);
        }
        catch (IllegalAccessException ex) {
            LogFactory.log.unexpectedError(ex);
            return StandardRuntimeResource.createTransformException0(message, errorCode, ex);
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            LogFactory.log.unexpectedError(targetException);
            return StandardRuntimeResource.createTransformException0(message, errorCode, (Exception)targetException);
        }
        return e;
    }

    private static TransformNestableException createTransformException0(String message, String errorCode, Exception e) {
        LogFactory.log.unexpectedError(e);
        TransformException ex = new TransformException(message, errorCode);
        ex.setDetail(e);
        return ex;
    }

    public static UnsupportedOperationException createUnsupportedOperationException(String messageId) {
        String message = StandardRuntimeResource.getFormattedMessage(StandardRuntimeResource.class, messageId, new Object[0]);
        return new UnsupportedOperationException(message);
    }

    public static SQLException createSQLExceptionFormatted(String messageId) {
        String message = StandardRuntimeResource.getFormattedMessage(StandardRuntimeResource.class, messageId, new Object[0]);
        return new SQLException(message);
    }

    public static IllegalArgumentException createIllegalArgumentExceptionFormatted(String messageId, Object[] args) {
        String message = StandardRuntimeResource.getFormattedMessage(StandardRuntimeResource.class, messageId, args);
        return new IllegalArgumentException(message);
    }

    public static IllegalArgumentException createIllegalArgumentExceptionFormatted(String messageId) {
        String message = StandardRuntimeResource.getFormattedMessage(StandardRuntimeResource.class, messageId, new Object[0]);
        return new IllegalArgumentException(message);
    }

    public static NamingException createNamingExceptionFormatted(String messageId, Object[] args) {
        String message = StandardRuntimeResource.getFormattedMessage(StandardRuntimeResource.class, messageId, args);
        return new NamingException(message);
    }

    public static IOException createIOExceptionFormatted(String messageId, Object[] args) {
        String message = StandardRuntimeResource.getFormattedMessage(StandardRuntimeResource.class, messageId, args);
        return new IOException(message);
    }

    public static IOException createEOFExceptionFormatted(String messageId, Object[] args) {
        String message = StandardRuntimeResource.getFormattedMessage(StandardRuntimeResource.class, messageId, args);
        return new EOFException(message);
    }

    private static String getPackageName(Class cls) {
        String className = cls.getName();
        String packageName = StandardRuntimeResource.getPackageName(className);
        return packageName;
    }

    private static String getPackageName(String className) {
        String packageName = className.substring(0, className.lastIndexOf(46));
        return packageName;
    }

    public static void cmtmain(String[] args) {
        System.out.println(StandardRuntimeResource.createFormatted(TransformException.class, "SRT101"));
        System.out.println(StandardRuntimeResource.createFormatted(TransformException.class, "SRT100", "WrongClass"));
        System.out.println(StandardRuntimeResource.createFormatted(FieldParsingException.class, "SRT115", "12a"));
    }
}

