/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractInputSource;
import com.tplus.transform.runtime.AbstractRawMessage;
import com.tplus.transform.runtime.Binary;
import com.tplus.transform.runtime.ByteArrayInputSource;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.TransformException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class StreamBaseInputSource
extends AbstractRawMessage
implements Serializable {
    private String name;
    Binary cachedBytes = null;
    private static final long serialVersionUID = 1L;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public InputStream getAsStream() throws TransformException {
        if (this.cachedBytes != null) {
            return this.cachedBytes.getAsStream();
        }
        try {
            return this.getAsStream0();
        }
        catch (IOException e) {
            TransformException te = TransformException.createFormatted("SRT667", new Object[]{this.name, e});
            te.setDetail(e);
            throw te;
        }
    }

    public RawMessage subMessage(long start_index, int num_chars) throws TransformException {
        if (this.cachedBytes != null) {
            if (num_chars == -1) {
                num_chars = (int)((long)this.cachedBytes.length - start_index);
            }
            Binary subBytes = this.cachedBytes.sub((int)start_index, (int)start_index + num_chars);
            return new ByteArrayInputSource(subBytes);
        }
        return super.subMessage(start_index, num_chars);
    }

    protected boolean isBytesCached() {
        return this.cachedBytes != null;
    }

    public Object getAsObject() throws TransformException {
        if (this.cachedBytes != null) {
            return this.cachedBytes;
        }
        try {
            this.cachedBytes = new Binary(this.getAsBytes0());
            return this.cachedBytes;
        }
        catch (IOException e) {
            throw TransformException.createFormatted("SRT667", new Object[]{this.name, e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getAsBytes0() throws IOException {
        InputStream asStream = this.getAsStream0();
        try {
            byte[] byArray = AbstractInputSource.readStream(asStream);
            return byArray;
        }
        finally {
            asStream.close();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.cachedBytes == null) {
            this.getAsBytes0();
        }
        out.defaultWriteObject();
    }

    public int getByte(long at) throws TransformException {
        if (this.cachedBytes != null) {
            return this.cachedBytes.getByte(at);
        }
        return this.getByte0(at);
    }

    public int getBytes(long start_index, byte[] toRet, int destLocation, int num_chars) throws TransformException {
        if (this.cachedBytes != null) {
            return this.cachedBytes.getBytes(start_index, toRet, destLocation, num_chars);
        }
        return this.getBytes0(start_index, toRet, destLocation, num_chars);
    }

    public void dispose() throws TransformException {
        this.cachedBytes = null;
    }

    protected abstract InputStream getAsStream0() throws IOException;

    protected abstract int getBytes0(long var1, byte[] var3, int var4, int var5) throws TransformException;

    protected abstract int getByte0(long var1) throws TransformException;
}

