/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractRawMessage;
import com.tplus.transform.runtime.TransformException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class StringInputSource
extends AbstractRawMessage {
    private String inputSourceName;
    private String value;
    byte[] bytes;

    public StringInputSource(String value) {
        this(value, null);
    }

    public StringInputSource(String value, String sourceName) {
        this.setName(sourceName);
        this.value = value;
    }

    public int getByte(long at) throws TransformException {
        byte[] asBytes = this.getAsBytes();
        if (at < (long)asBytes.length) {
            return asBytes[(int)at] & 0xFF;
        }
        return -1;
    }

    public final byte[] getAsBytes() throws TransformException {
        if (this.bytes == null) {
            this.bytes = super.getAsBytes();
        }
        return this.bytes;
    }

    public InputStream getAsStream() throws TransformException {
        return new ByteArrayInputStream(this.getAsBytes());
    }

    public Object getAsObject() throws TransformException {
        return this.value;
    }

    public String getName() {
        return this.inputSourceName;
    }

    public void setName(String inputSourceName) {
        this.inputSourceName = inputSourceName;
    }

    public int getLength() {
        return this.value.length();
    }

    public boolean isBinary() {
        return false;
    }

    public void dispose() throws TransformException {
        super.dispose();
        this.value = "";
        this.bytes = null;
    }
}

