/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractRawMessage;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.TransformException;
import java.io.IOException;
import java.io.InputStream;

public class SubRawMessage
extends AbstractRawMessage {
    RawMessage delegate;
    long start;
    int length;

    public SubRawMessage(RawMessage delegate, long start, int length) {
        this.delegate = delegate;
        int delegateLength = 0;
        try {
            delegateLength = delegate.getLength();
        }
        catch (TransformException e) {
            // empty catch block
        }
        this.start = Math.min((long)delegateLength, start);
        this.length = Math.min((int)Math.max(0L, (long)delegateLength - start), length);
    }

    public int getLength() throws TransformException {
        if (this.length == -1) {
            return (int)((long)this.delegate.getLength() - this.start);
        }
        return this.length;
    }

    public long getLongLength() throws TransformException {
        if (this.length == -1) {
            return (long)this.delegate.getLength() - this.start;
        }
        return this.length;
    }

    public boolean isBinary() {
        return this.delegate.isBinary();
    }

    public int getByte(long at) throws TransformException {
        if (this.length >= 0 && at > (long)this.length) {
            return -1;
        }
        return this.delegate.getByte(this.start + at);
    }

    public int getBytes(long start_index, byte[] toRet, int destLocation, int num_chars) throws TransformException {
        long bufLength = num_chars;
        if (this.length > 0) {
            bufLength = Math.min((long)num_chars, (long)this.length - start_index);
        }
        return this.delegate.getBytes(this.start + start_index, toRet, destLocation, (int)bufLength);
    }

    public InputStream getAsStream() throws TransformException {
        return new InputStream(){
            int position;

            public void close() throws IOException {
            }

            public int read() throws IOException {
                try {
                    if (SubRawMessage.this.length >= 0 && this.position > SubRawMessage.this.length) {
                        return -1;
                    }
                    int nRead = SubRawMessage.this.getByte(this.position);
                    if (nRead >= 0) {
                        ++this.position;
                        return nRead;
                    }
                    return -1;
                }
                catch (TransformException e) {
                    IOException ioException = new IOException(e.getMessage());
                    ioException.initCause(e);
                    throw ioException;
                }
            }

            public int read(byte[] buf, int off, int len) throws IOException {
                try {
                    int bytes = SubRawMessage.this.getBytes(this.position, buf, off, len);
                    this.position += bytes;
                    if (bytes == 0) {
                        return -1;
                    }
                    return bytes;
                }
                catch (TransformException e) {
                    IOException ioException = new IOException(e.getMessage());
                    ioException.initCause(e);
                    throw ioException;
                }
            }

            public int read(byte[] buf) throws IOException {
                return this.read(buf, 0, buf.length);
            }
        };
    }

    public Object getAsObject() throws TransformException {
        return this.delegate.getAsBinary().sub((int)this.start, (int)(this.start + (long)this.length));
    }
}

