/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.BatchMessage;
import com.tplus.transform.runtime.BatchWriter;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.ExternalObject;
import com.tplus.transform.runtime.InputSource;
import com.tplus.transform.runtime.LookupContext;
import com.tplus.transform.runtime.LookupContextFactory;
import com.tplus.transform.runtime.MemoryRawOutputMessage;
import com.tplus.transform.runtime.MessageHandler;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.io.OutputMessageDevice;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.naming.NamingException;

class TestBatch {
    TestBatch() {
    }

    public static BatchMessage lookupBatchMessage(String messageName) throws NamingException {
        LookupContext lcxt = LookupContextFactory.getLookupContext();
        BatchMessage batchMessage = lcxt.lookupBatchMessage(messageName);
        return batchMessage;
    }

    public static DataObject[] parse(BatchMessage batchMessage, InputSource source, TransformContext cxt) throws TransformException, RemoteException {
        final ArrayList allObjects = new ArrayList();
        batchMessage.getBatchParser().parseBatch(source, new MessageHandler(){

            public boolean handleMessage(DataObject obj, TransformContext cxt) {
                allObjects.add(obj);
                return true;
            }
        }, cxt);
        return allObjects.toArray(new DataObject[allObjects.size()]);
    }

    public static RawMessage serializeBatch(BatchMessage batchMessage, DataObject[] messageObjects, TransformContext cxt) throws TransformException, RemoteException {
        OutputMessageDevice device = new OutputMessageDevice();
        BatchWriter writer = batchMessage.getBatchWriter();
        writer.startBatch(device, cxt);
        for (int i = 0; i < messageObjects.length; ++i) {
            DataObject dataObject = messageObjects[i];
            writer.writeMessage((ExternalObject)dataObject, device, cxt);
        }
        writer.endBatch(device, cxt);
        device.close();
        MemoryRawOutputMessage rawMessage = device.getMessage();
        return rawMessage;
    }
}

