/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.lang.GenericObjectFactory;
import com.tplus.transform.lang.GenericObjectPool;
import com.tplus.transform.lang.ObjectPool;
import com.tplus.transform.runtime.CustomClassSupport;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.handler.IInvokable;
import java.util.Hashtable;

public class ThreadSafeCustomExternalClassSupport
extends CustomClassSupport {
    private Hashtable objectPools = new Hashtable();

    public ThreadSafeCustomExternalClassSupport(ClassLoader loader) {
        super(loader);
    }

    public ThreadSafeCustomExternalClassSupport(Class cls) {
        super(cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(String clsName, Object[] value, TransformContext cxt) throws TransformException {
        ObjectPool objectPool = this.getObjectPool(clsName);
        IInvokable invokable = this.createObject(objectPool, clsName);
        try {
            Object object = invokable.run(value, cxt);
            return object;
        }
        finally {
            objectPool.releaseObjectToPool(invokable);
        }
    }

    private IInvokable createObject(ObjectPool objectPool, String clsName) throws TransformException {
        IInvokable invokable = null;
        try {
            invokable = (IInvokable)objectPool.getObjectFromPool();
        }
        catch (Exception e) {
            ThreadSafeCustomExternalClassSupport.handleException(e, clsName);
        }
        return invokable;
    }

    private ObjectPool getObjectPool(String clsName) throws TransformException {
        ObjectPool objectPool = (ObjectPool)this.objectPools.get(clsName);
        if (objectPool == null) {
            objectPool = new GenericObjectPool(new GenericObjectFactory(ThreadSafeCustomExternalClassSupport.loadClass(clsName, this.classLoader, IInvokable.class)));
            this.objectPools.put(clsName, objectPool);
        }
        return objectPool;
    }
}

