/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.BatchContext;
import com.tplus.transform.runtime.LookupContext;
import com.tplus.transform.runtime.LookupContextFactory;
import com.tplus.transform.runtime.OutputContext;
import com.tplus.transform.runtime.PropertyMap;
import com.tplus.transform.runtime.PropertyMapImpl;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.collection.StringList;
import com.tplus.transform.runtime.log.LogFactory;
import java.io.Serializable;
import java.util.Date;
import javax.naming.NamingException;

public class TransformContextImpl
implements TransformContext,
Cloneable,
Serializable {
    private PropertyMap props = new PropertyMapImpl();
    private OutputContext outputContext;
    private boolean ownContext;
    private static LookupContext lcxt;
    private static final long serialVersionUID = 1421076759512212392L;
    public static TransformContext EMPTY;

    public Object getProperty(String prop) {
        if (this.props != null && this.props.getPropertyCount() > 0) {
            return this.props.getProperty(prop);
        }
        return null;
    }

    public Object getProperty(String prop, Object defaultValue) {
        Object value = null;
        if (this.props != null && this.props.getPropertyCount() > 0) {
            value = this.props.getProperty(prop);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        return this.props.getBooleanProperty(name, defaultValue);
    }

    public int getIntProperty(String name, int defaultValue) {
        return this.props.getIntProperty(name, defaultValue);
    }

    public long getLongProperty(String name, long defaultValue) {
        return this.props.getLongProperty(name, defaultValue);
    }

    public double getDoubleProperty(String name, double defaultValue) {
        return this.props.getDoubleProperty(name, defaultValue);
    }

    public Date getDateProperty(String name, Date defaultValue) {
        return this.props.getDateProperty(name, defaultValue);
    }

    public String getStringProperty(String name, String defaultValue) {
        return this.props.getStringProperty(name, defaultValue);
    }

    public StringList getKeySet() {
        return this.props.getPropertyNames();
    }

    public StringList getKeySet(String prefix) {
        return this.props.getProperties(prefix).getPropertyNames();
    }

    public void setProperty(String prop, Object value) {
        if (value == null) {
            this.getOrCreateProperties().removeProperty(prop);
        } else {
            this.getOrCreateProperties().setProperty(prop, value);
        }
    }

    private PropertyMap getOrCreateProperties() {
        if (this.props == null) {
            this.props = new PropertyMapImpl();
        }
        return this.props;
    }

    public BatchContext createBatchContext() throws TransformException {
        this.clearBatch();
        BatchContext bc = (BatchContext)this.getProperty("input.batch.context");
        if (bc == null) {
            bc = this.createBatch();
            this.setProperty("input.batch.context", bc);
        }
        return bc;
    }

    public BatchContext getBatchContext() throws TransformException {
        BatchContext bc = (BatchContext)this.getProperty("input.batch.context");
        return bc;
    }

    public OutputContext createOutputContext() throws TransformException {
        this.clearOutput();
        if (this.outputContext == null) {
            this.createOutput();
        }
        return this.outputContext;
    }

    public OutputContext getOutputContext() throws TransformException {
        if (this.outputContext == null) {
            throw TransformException.createFormatted("SRT107");
        }
        return this.outputContext;
    }

    public TransformContext createCopy() {
        try {
            TransformContextImpl clonedObj = (TransformContextImpl)super.clone();
            clonedObj.props = (PropertyMap)clonedObj.props.clone();
            clonedObj.ownContext = false;
            clonedObj.setProperty("input.batch.context", null);
            return clonedObj;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Object clone() {
        return this.createCopy();
    }

    public void clear() throws TransformException {
        this.clearOutput();
        this.clearBatch();
    }

    public void destroy() throws TransformException {
        this.destroyOutput();
        this.destoryBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BatchContext createBatch() throws TransformException {
        BatchContext bc;
        try {
            LookupContext lookupContext;
            LookupContext lookupContext2 = lookupContext = TransformContextImpl.getLookupContext();
            synchronized (lookupContext2) {
                bc = lookupContext.createBatchContext();
            }
        }
        catch (Exception e) {
            TransformException te = TransformException.createFormatted("SRT104");
            te.setDetail(e);
            throw te;
        }
        return bc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOutput() throws TransformException {
        try {
            LookupContext lookupContext;
            LookupContext lookupContext2 = lookupContext = TransformContextImpl.getLookupContext();
            synchronized (lookupContext2) {
                this.outputContext = lookupContext.createOutputContext();
            }
        }
        catch (Exception e) {
            TransformException te = TransformException.createFormatted("SRT106");
            te.setDetail(e);
            throw te;
        }
        this.ownContext = true;
    }

    private void clearOutput() {
        if (this.outputContext != null) {
            try {
                this.outputContext.clear();
            }
            catch (Exception e) {
                LogFactory.log.unexpectedError(e);
                this.outputContext = null;
            }
        }
    }

    private void clearBatch() {
        BatchContext bc = (BatchContext)this.getProperty("input.batch.context");
        if (bc != null) {
            try {
                bc.clear();
            }
            catch (Exception e) {
                LogFactory.log.unexpectedError(e);
                this.setProperty("input.batch.context", null);
            }
        }
    }

    private void destoryBatch() {
        BatchContext bc = (BatchContext)this.getProperty("input.batch.context");
        if (bc != null) {
            try {
                LookupContext lookupContext = TransformContextImpl.getLookupContext();
                lookupContext.destroyBatchContext(bc);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setProperty("input.batch.context", null);
        }
    }

    private void destroyOutput() {
        if (this.outputContext != null && this.ownContext) {
            try {
                LookupContext lookupContext = TransformContextImpl.getLookupContext();
                lookupContext.destroyOutputContext(this.outputContext);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.outputContext = null;
        }
    }

    private static LookupContext getLookupContext() throws NamingException {
        if (lcxt == null) {
            lcxt = LookupContextFactory.getLookupContext();
        }
        return lcxt;
    }

    public String toString() {
        return "TransformContext{" + this.props.toString() + "}";
    }

    static {
        EMPTY = new TransformContextImpl();
    }
}

