/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.BatchContext;
import com.tplus.transform.runtime.OutputContext;
import com.tplus.transform.runtime.PropertyMap;
import com.tplus.transform.runtime.PropertyMapImpl;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformContextImpl;
import com.tplus.transform.runtime.TransformException;
import java.util.Map;

public class TransformContextWrapper
implements TransformContext,
Cloneable {
    private static final String ROOT_PROPERTY_PREFIX = "__";
    TransformContext cxt;
    PropertyMap props;

    public TransformContextWrapper() {
        this(TransformContextImpl.EMPTY);
    }

    public TransformContextWrapper(TransformContext cxt) {
        this.cxt = cxt;
    }

    public void setTransformContext(TransformContext cxt) {
        this.cxt = cxt;
    }

    public TransformContext getTransformContext() {
        return this.cxt;
    }

    public String toString() {
        return this.cxt.toString() + "-" + this.props.toString();
    }

    public void putAll(Map properties) {
        for (Map.Entry entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            this.setProperty(key, value);
        }
    }

    private void initProps() {
        if (this.props == null) {
            this.props = new PropertyMapImpl();
        }
    }

    public Object getProperty(String prop) {
        if (this.props != null && this.props.getPropertyCount() > 0 && this.props.hasProperty(prop)) {
            return this.props.getProperty(prop);
        }
        return this.cxt.getProperty(prop);
    }

    public Object getProperty(String prop, Object defaultValue) {
        if (this.props != null && this.props.getPropertyCount() > 0 && this.props.hasProperty(prop)) {
            return this.props.getProperty(prop);
        }
        return this.cxt.getProperty(prop, defaultValue);
    }

    public void setProperty(String prop, Object value) {
        if (prop.startsWith(ROOT_PROPERTY_PREFIX)) {
            this.cxt.setProperty(prop, value);
        } else {
            this.initProps();
            this.props.setProperty(prop, value);
        }
    }

    public OutputContext createOutputContext() throws TransformException {
        return this.cxt.createOutputContext();
    }

    public OutputContext getOutputContext() throws TransformException {
        return this.cxt.getOutputContext();
    }

    public BatchContext createBatchContext() throws TransformException {
        return this.cxt.createBatchContext();
    }

    public BatchContext getBatchContext() throws TransformException {
        return this.cxt.getBatchContext();
    }

    public TransformContext createCopy() {
        try {
            TransformContextWrapper copy = (TransformContextWrapper)super.clone();
            copy.cxt = copy.cxt.createCopy();
            if (copy.props != null) {
                copy.props = (PropertyMap)copy.props.clone();
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Object clone() {
        return this.createCopy();
    }

    public void clear() throws TransformException {
        this.cxt.clear();
    }

    public void destroy() throws TransformException {
        this.cxt.destroy();
    }
}

