/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.ExceptionDataObject;
import com.tplus.transform.runtime.ExceptionObject;
import com.tplus.transform.runtime.ExternalMessage;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.LookupContext;
import com.tplus.transform.runtime.MessageFlow;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.SectionMetaInfo;
import com.tplus.transform.runtime.SectionMetaInfoImpl;
import com.tplus.transform.runtime.StandardRuntimeResource;
import com.tplus.transform.runtime.TransformExceptionBase;
import com.tplus.transform.runtime.TransformExceptionHelper;
import com.tplus.transform.runtime.TransformNestableException;
import com.tplus.transform.runtime.log.LogFactory;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;

public class TransformException
extends TransformExceptionBase
implements TransformNestableException,
ExceptionObject {
    private boolean simpleString;
    static Constructor sectionImplConstructor = null;
    private TransformException nextException;
    DataObjectSection exceptions = this.createSectionImpl();
    private static final long serialVersionUID = -9117809532704668704L;

    public TransformException() {
        this(null, (Throwable)null);
    }

    public TransformException(String message) {
        this(message, (Throwable)null);
    }

    public TransformException(String message, String errorCode) {
        this(message, (Throwable)null);
        this.setErrorCode(errorCode);
    }

    public TransformException(String message, Throwable ex) {
        this.setMessage(message);
        this.setType("TransformException");
        this.setSeverity("fatal");
        this.setCascadable(true);
        this.setDetail(ex);
    }

    public TransformException(String message, DataObject obj, int index, Object value) {
        this.setMessage(message);
        this.setField(obj, index, value);
    }

    public void setField(DataObject obj, int index, Object value) {
        this.setErrorField(obj, index, value);
    }

    public void setErrorField(DataObject obj, int index, Object value) {
        this.getOrCreatePrimaryException().setErrorField(obj, index, value);
    }

    public void setField(DataObjectSection sectionField, Object value) {
        this.setErrorSection(sectionField, value);
    }

    public void setErrorSection(DataObjectSection sectionField, Object value) {
        this.getOrCreatePrimaryException().setErrorSection(sectionField, value);
    }

    public void setErrorObject(DataObject obj, Object value) {
        this.getOrCreatePrimaryException().setErrorObject(obj, value);
    }

    public TransformException(ExceptionObject exObj) {
        this.addExceptionObject(exObj);
    }

    public TransformException(DataObjectSection exceptions) {
        this.exceptions = exceptions;
    }

    public TransformException(List exceptionObjects) {
        for (int i = 0; i < exceptionObjects.size(); ++i) {
            ExceptionObject exceptionDataObject = (ExceptionObject)exceptionObjects.get(i);
            this.addExceptionObject(exceptionDataObject);
        }
    }

    public String getType() {
        return this.getOrCreatePrimaryException().getType();
    }

    public void setType(String value) {
        this.getOrCreatePrimaryException().setType(value);
    }

    public String getMessage() {
        return this.getOrCreatePrimaryException().getMessage();
    }

    public void setMessage(String value) {
        this.getOrCreatePrimaryException().setMessage(value);
    }

    public String getErrorCode() {
        return this.getOrCreatePrimaryException().getErrorCode();
    }

    public void setErrorCode(String value) {
        this.getOrCreatePrimaryException().setErrorCode(value);
    }

    public String getSeverity() {
        return this.getOrCreatePrimaryException().getSeverity();
    }

    public void setSeverity(String value) {
        this.getOrCreatePrimaryException().setSeverity(value);
    }

    public boolean getCascadable() {
        return this.getOrCreatePrimaryException().getCascadable();
    }

    public void setCascadable(boolean value) {
        this.getOrCreatePrimaryException().setCascadable(value);
    }

    public DataObject getSource() {
        return this.getOrCreatePrimaryException().getSource();
    }

    public void setFieldName(String fieldName) {
        this.getOrCreatePrimaryException().setFieldName(fieldName);
    }

    public String getFieldName() {
        return this.getOrCreatePrimaryException().getFieldName();
    }

    public void setFFieldName(String fieldName) {
        this.getOrCreatePrimaryException().setFieldName(fieldName);
    }

    public String getFFieldName() {
        return this.getOrCreatePrimaryException().getFieldName();
    }

    public void setFieldID(String fieldID) {
        this.getOrCreatePrimaryException().setFieldID(fieldID);
    }

    public String getFieldID() {
        return this.getOrCreatePrimaryException().getFieldID();
    }

    public void setErrorPhase(String phase) {
        this.getOrCreatePrimaryException().setErrorPhase(phase);
    }

    public String getErrorPhase() {
        return this.getOrCreatePrimaryException().getErrorPhase();
    }

    public void setErrorType(String errorType) {
        this.getOrCreatePrimaryException().setErrorType(errorType);
    }

    public String getErrorType() {
        return this.getOrCreatePrimaryException().getErrorType();
    }

    public boolean instanceOf(String exceptionType) {
        return this.getOrCreatePrimaryException().instanceOf(exceptionType);
    }

    public void setFieldValue(String value) {
        this.getOrCreatePrimaryException().setFieldValue(value);
    }

    public String getFieldValue() {
        return this.getOrCreatePrimaryException().getFieldValue();
    }

    public String toXMLString() {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeDataRecord, boolean includeStackTrace) {
        return TransformExceptionHelper.toXMLString(this, includeDataRecord, includeStackTrace);
    }

    public Map getExceptionContext() {
        return this.getOrCreatePrimaryException().getExceptionContext();
    }

    public void setContextProperty(String name, Object value) {
        this.getOrCreatePrimaryException().setContextProperty(name, value);
    }

    public Object getContextProperty(String name) {
        return this.getOrCreatePrimaryException().getContextProperty(name);
    }

    public String getContextMessage() {
        return this.getOrCreatePrimaryException().getContextMessage();
    }

    public String getFullMessage() {
        if (this.getCause() == null) {
            return this.getMessage() + this.getContextMessage();
        }
        return this.getMessage() + this.getContextMessage() + "; nested exception is: \n\t" + this.getCause().toString();
    }

    public String toString() {
        if (this.simpleString) {
            return super.toString();
        }
        return this.toXMLString();
    }

    public void printStackTrace(PrintStream ps) {
        this.simpleString = true;
        super.printStackTrace(ps);
        this.simpleString = false;
    }

    public void printStackTrace(PrintWriter ps) {
        this.simpleString = true;
        super.printStackTrace(ps);
        this.simpleString = false;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public TransformNestableException getNextException() {
        return this.nextException;
    }

    public void setNextException(TransformException nextException) {
        this.nextException = nextException;
    }

    public void setDetail(Throwable ex) {
        if (ex != null) {
            this.initCause(ex);
        }
    }

    public Throwable getDetail() {
        return this.getCause();
    }

    public static TransformException createFormatted(String messageId) {
        return TransformException.createFormatted(TransformException.class, messageId);
    }

    public static TransformException createFormatted(String messageId, String arg) {
        return TransformException.createFormatted(TransformException.class, messageId, arg);
    }

    public static TransformException createFormatted(String messageId, Object[] args) {
        return TransformException.createFormatted(TransformException.class, messageId, args);
    }

    public static TransformException createFormattedWithValue(String messageId, Object[] args, Object value) {
        TransformException transformException = TransformException.createFormatted(TransformException.class, messageId, args);
        if (value != null) {
            transformException.setFieldValue(value.toString());
        }
        return transformException;
    }

    public static TransformException createFormatted(Class exceptionClass, String messageId) {
        return (TransformException)StandardRuntimeResource.createFormatted(exceptionClass, messageId);
    }

    public static TransformException createFormatted(Class exceptionClass, String messageId, String arg) {
        return (TransformException)StandardRuntimeResource.createFormatted(exceptionClass, messageId, arg);
    }

    public static TransformException createFormatted(Class exceptionClass, String messageId, Object[] args) {
        return (TransformException)StandardRuntimeResource.createFormatted(exceptionClass, messageId, args);
    }

    public DataObjectSection getExceptions() {
        return this.exceptions;
    }

    public List getExceptionsAsList() {
        ArrayList<DataObject> exceptions = new ArrayList<DataObject>();
        for (int i = 0; i < this.exceptions.getElementCount(); ++i) {
            exceptions.add(this.exceptions.getElement(i));
        }
        return exceptions;
    }

    public void addExceptionObject(ExceptionObject e) {
        e.setParentSection(this.exceptions);
        this.exceptions.addElement(e);
    }

    public void removeExceptionObject(ExceptionObject e) {
        this.exceptions.remove(e);
    }

    public ExceptionObject getOrCreatePrimaryException() {
        if (this.exceptions.getElementCount() == 0) {
            ExceptionDataObject obj = new ExceptionDataObject();
            obj.setParentSection(this.exceptions);
            this.exceptions.addElement(obj);
        }
        try {
            return (ExceptionObject)this.exceptions.getElement(0);
        }
        catch (FieldNotFoundException e) {
            LogFactory.log.unexpectedError(e);
            return null;
        }
    }

    public void addAll(TransformException e) {
        if (e == this) {
            return;
        }
        DataObjectSection exceptionObjects = e.exceptions;
        int count = exceptionObjects.getElementCount();
        for (int i = 0; i < count; ++i) {
            try {
                this.addExceptionObject((ExceptionObject)exceptionObjects.getElement(i));
                continue;
            }
            catch (FieldNotFoundException e1) {
                // empty catch block
            }
        }
    }

    public void removeAll(TransformException e) {
        if (e == this) {
            return;
        }
        DataObjectSection exceptionObjects = e.exceptions;
        int count = exceptionObjects.getElementCount();
        for (int i = 0; i < count; ++i) {
            try {
                this.removeExceptionObject((ExceptionObject)exceptionObjects.getElement(i));
                continue;
            }
            catch (FieldNotFoundException e1) {
                // empty catch block
            }
        }
    }

    public void setInternalCode(String internalCode) {
        this.setContextProperty("Internal-Code", internalCode);
    }

    protected DataObjectSection createSectionImpl() {
        try {
            if (sectionImplConstructor == null) {
                Class<?> cls = Class.forName("com.tplus.transform.runtime.DataObjectSectionImpl");
                sectionImplConstructor = cls.getConstructor(DataObject.class, SectionMetaInfo.class);
            }
            DataObjectSection sec = (DataObjectSection)sectionImplConstructor.newInstance(this, new SectionMetaInfoImpl(ExceptionDataObject.getMetaInfoForClass(), "TransformException"));
            return sec;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void addTrace(String entityType, String entity, String subEntity) {
        this.getOrCreatePrimaryException().addTrace(entityType, entity, subEntity);
    }

    public Object clone() {
        TransformException e = (TransformException)super.clone();
        e.exceptions = (DataObjectSection)this.exceptions.clone();
        return e;
    }

    public static List updateExceptionTrace(List exceptions, String entityType, String entity, String subEntity) {
        for (int i = 0; i < exceptions.size(); ++i) {
            ExceptionObject exceptionObject = (ExceptionObject)exceptions.get(i);
            exceptionObject.addTrace(entityType, entity, subEntity);
        }
        return exceptions;
    }

    public static void cmtmain(String[] args) {
        TransformException transformException = new TransformException("ABCD", new IOException("CC"));
        transformException.printStackTrace();
    }

    public static void main(String[] args) throws NamingException {
        Class[] cls = new Class[]{DataObject.class, LookupContext.class, MessageFlow.class, ExternalMessage.class, RawMessage.class};
        System.out.println("Running");
    }
}

