/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.ExceptionDataObject;
import com.tplus.transform.runtime.ExceptionObject;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.FieldNullException;
import com.tplus.transform.runtime.FieldTypeMismatchException;
import com.tplus.transform.runtime.LocationInfo;
import com.tplus.transform.runtime.NormalizedObject;
import com.tplus.transform.runtime.PropertyMap;
import com.tplus.transform.runtime.PropertyMapImpl;
import com.tplus.transform.runtime.SectionMetaInfo;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.collection.StringList;
import com.tplus.transform.runtime.xml.XMLFieldType;
import com.tplus.transform.util.xml.QName;
import java.util.Date;
import java.util.Map;

public abstract class TransformExceptionBase
extends Exception
implements NormalizedObject {
    private PropertyMapImpl _properties;
    private static final long serialVersionUID = 6758230715731136178L;

    public Object clone() {
        try {
            TransformExceptionBase cloned = (TransformExceptionBase)super.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String getMessageName() {
        return this.getMetaInfo().getName();
    }

    public DataObject createSectionElement(int index, DataObjectSection sec) throws FieldNotFoundException {
        return this.getOrCreatePrimaryException().createSectionElement(index, sec);
    }

    public DataObject createSectionElement(String sectionName, DataObjectSection sec) throws FieldNotFoundException {
        if (sectionName.equals("CascadedException")) {
            ExceptionDataObject exObj = new ExceptionDataObject();
            exObj.setParentSection(sec);
            return exObj;
        }
        return this.getOrCreatePrimaryException().createSectionElement(sectionName, sec);
    }

    public void fromMap(Map map) throws TransformException {
        this.getOrCreatePrimaryException().fromMap(map);
    }

    public Object getField(String fieldName) throws FieldNotFoundException {
        return this.getOrCreatePrimaryException().getField(fieldName);
    }

    public Object getField(int index) throws FieldNotFoundException {
        return this.getOrCreatePrimaryException().getField(index);
    }

    public Object getFieldCheckNull(int index) throws FieldNullException, FieldNotFoundException {
        return this.getOrCreatePrimaryException().getFieldCheckNull(index);
    }

    public Object getFieldCheckNull(String fieldName) throws FieldNullException, FieldNotFoundException {
        return this.getOrCreatePrimaryException().getFieldCheckNull(fieldName);
    }

    public int getFieldCount() {
        return this.getOrCreatePrimaryException().getFieldCount();
    }

    public String getFieldID(int index) throws FieldNotFoundException {
        return this.getOrCreatePrimaryException().getFieldID(index);
    }

    public LocationInfo getLocationInfo() {
        return this.getOrCreatePrimaryException().getLocationInfo();
    }

    public int getFieldIndex(String fieldName) throws FieldNotFoundException {
        return this.getOrCreatePrimaryException().getFieldIndex(fieldName);
    }

    public String getFieldName(int index) throws FieldNotFoundException {
        return this.getOrCreatePrimaryException().getFieldName(index);
    }

    public String getFieldType(int index) throws FieldNotFoundException {
        return this.getOrCreatePrimaryException().getFieldType(index);
    }

    public String getFieldType(String name) throws FieldNotFoundException {
        return this.getOrCreatePrimaryException().getFieldType(name);
    }

    public DesignerType getFieldDesignerType(int index) throws FieldNotFoundException {
        return this.getOrCreatePrimaryException().getFieldDesignerType(index);
    }

    public DesignerType getFieldDesignerType(String name) throws FieldNotFoundException {
        return this.getOrCreatePrimaryException().getFieldDesignerType(name);
    }

    public String getID() {
        return "";
    }

    public String getQualifiedName() {
        return "";
    }

    public DataObjectMetaInfo getMetaInfo() {
        return this.getOrCreatePrimaryException().getMetaInfo();
    }

    public DataObjectSection getParentSection() {
        return null;
    }

    public String getQualifiedName(String fieldName) throws FieldNotFoundException {
        return this.getOrCreatePrimaryException().getQualifiedName(fieldName);
    }

    public String getQualifiedName(int index) throws FieldNotFoundException {
        return this.getOrCreatePrimaryException().getQualifiedName(index);
    }

    public DataObject getRootDataObject() {
        return this.getOrCreatePrimaryException().getRootDataObject();
    }

    public String getRootXMLTag() {
        return this.getOrCreatePrimaryException().getRootXMLTag();
    }

    public QName getXMLQName() {
        DataObjectMetaInfo dataObjectMetaInfo = this.getMetaInfo();
        SectionMetaInfo parentSection = dataObjectMetaInfo.getParentSection();
        if (parentSection != null) {
            return parentSection.getXMLQName();
        }
        return new QName(null, this.getRootXMLTag());
    }

    public XMLFieldType getFieldXMLType() {
        DataObjectMetaInfo dataObjectMetaInfo = this.getMetaInfo();
        return dataObjectMetaInfo.getFieldXMLType();
    }

    public DataObjectSection getSection(int index) throws FieldNotFoundException {
        return this.getOrCreatePrimaryException().getSection(index);
    }

    public DataObjectSection getSection(String secName) throws FieldNotFoundException {
        return this.getOrCreatePrimaryException().getSection(secName);
    }

    public boolean isEmpty() {
        return this.getOrCreatePrimaryException().isEmpty();
    }

    public boolean isNull(String fieldName) throws FieldNotFoundException {
        return this.getOrCreatePrimaryException().isNull(fieldName);
    }

    public boolean isNull(int index) throws FieldNotFoundException {
        return this.getOrCreatePrimaryException().isNull(index);
    }

    public final boolean isNotNull(int index) throws FieldNotFoundException {
        return !this.isNull(index);
    }

    public boolean isSynthesized(String fieldName) throws FieldNotFoundException {
        return this.getOrCreatePrimaryException().isSynthesized(fieldName);
    }

    public boolean isSynthesized(int index) throws FieldNotFoundException {
        return this.getOrCreatePrimaryException().isSynthesized(index);
    }

    public int getElementIndex() {
        DataObjectSection parentSection = this.getParentSection();
        if (parentSection != null) {
            return parentSection.getElementIndex(this);
        }
        return -1;
    }

    public void reset() {
        this.getOrCreatePrimaryException().reset();
    }

    public void setField(String fieldName, Object value) throws FieldNotFoundException, FieldTypeMismatchException {
        this.getOrCreatePrimaryException().setField(fieldName, value);
    }

    public void setField(int index, Object value) throws FieldNotFoundException, FieldTypeMismatchException {
        this.getOrCreatePrimaryException().setField(index, value);
    }

    public void setNull(String fieldName) throws FieldNotFoundException {
        this.getOrCreatePrimaryException().setNull(fieldName);
    }

    public void setNull(int index) throws FieldNotFoundException {
        this.getOrCreatePrimaryException().setNull(index);
    }

    public void setParentSection(DataObjectSection parentSection) {
        this.getOrCreatePrimaryException().setParentSection(parentSection);
    }

    public String toXMLString() {
        return this.getOrCreatePrimaryException().toXMLString();
    }

    public String toXMLString(int indent) {
        return this.getOrCreatePrimaryException().toXMLString(indent);
    }

    public abstract ExceptionObject getOrCreatePrimaryException();

    public void setProperty(String key, Object value) {
        this.getProperties().setProperty(key, value);
    }

    public void setProperties(Map properties) {
        this.getProperties().setProperties(properties);
    }

    public PropertyMap getProperties(String name) {
        return this.getProperties().getProperties(name);
    }

    public void putProperties(PropertyMap properties) {
        this.getProperties().putProperties(properties);
    }

    public Object getProperty(String name, Object defaultValue) {
        return this.getProperties().getProperty(name, defaultValue);
    }

    public int getIntProperty(String name, int defaultValue) {
        return this.getProperties().getIntProperty(name, defaultValue);
    }

    public long getLongProperty(String name, long defaultValue) {
        return this.getProperties().getLongProperty(name, defaultValue);
    }

    public double getDoubleProperty(String name, double defaultValue) {
        return this.getProperties().getDoubleProperty(name, defaultValue);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        return this.getProperties().getBooleanProperty(name, defaultValue);
    }

    public String getStringProperty(String name, String defaultValue) {
        return this.getProperties().getStringProperty(name, defaultValue);
    }

    public Date getDateProperty(String name, Date defaultValue) {
        return this.getProperties().getDateProperty(name, defaultValue);
    }

    public void setBooleanProperty(String name, boolean value) {
        this.getProperties().setBooleanProperty(name, value);
    }

    public void setIntProperty(String name, int value) {
        this.getProperties().setIntProperty(name, value);
    }

    public void setLongProperty(String name, long value) {
        this.getProperties().setLongProperty(name, value);
    }

    public void setDoubleProperty(String name, double value) {
        this.getProperties().setDoubleProperty(name, value);
    }

    public void setStringProperty(String name, String value) {
        this.getProperties().setStringProperty(name, value);
    }

    public void setDateProperty(String name, Date value) {
        this.getProperties().setDateProperty(name, value);
    }

    public void clearProperties() {
        this.getProperties().clearProperties();
    }

    public void removeProperty(String key) {
        this.getProperties().removeProperty(key);
    }

    public boolean hasProperty(String key) {
        return this.getProperties().hasProperty(key);
    }

    public Object getProperty(String key) {
        return this.getProperties().getProperty(key);
    }

    public StringList getPropertyNames() {
        return this.getProperties().getPropertyNames();
    }

    public StringList getPropertyNames(PropertyMap.PropertyNameFilter filter) {
        return this.getProperties().getPropertyNames(filter);
    }

    public int getPropertyCount() {
        return this.getProperties().getPropertyCount();
    }

    private PropertyMapImpl getProperties() {
        if (this._properties == null) {
            this._properties = new PropertyMapImpl();
        }
        return this._properties;
    }
}

