/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.lang.FastStringBuffer;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.ExceptionObject;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformNestableException;
import com.tplus.transform.runtime.log.LogFactory;
import com.tplus.transform.runtime.xml.CharacterEscapeHandler;
import com.tplus.transform.runtime.xml.DumbEscapeHandler;
import com.tplus.transform.util.xml.QName;
import com.tplus.transform.util.xml.XMLUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;

public class TransformExceptionHelper {
    protected static final String lineSeparator = "\n";
    protected static final String fullindent = "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t";

    public static String indentStr(int val) {
        return fullindent.substring(0, val);
    }

    public static String tagStart(String tag) {
        return "<" + tag + ">";
    }

    public static String tagEnd(String tag) {
        return "</" + tag + ">";
    }

    public static String toXMLString(TransformNestableException e, boolean includeDataRecord, boolean includeStackTrace) {
        TransformNestableException next;
        String message = e.getMessage();
        FastStringBuffer toRet = new FastStringBuffer();
        if (e instanceof ExceptionObject) {
            toRet.append(TransformExceptionHelper.toXMLString((ExceptionObject)((Object)e), includeDataRecord));
            if (includeStackTrace) {
                toRet.append(TransformExceptionHelper.getStackTrace((Exception)((Object)e)));
            }
        } else {
            toRet.append(TransformExceptionHelper.tagStart("TransformRuntimeException")).append(lineSeparator);
            toRet.append(TransformExceptionHelper.indentStr(1)).append(TransformExceptionHelper.tagStart("Message")).append(message).append(TransformExceptionHelper.tagEnd("Message")).append(lineSeparator);
            TransformExceptionHelper.writeExceptionContext(e.getExceptionContext(), toRet);
            if (includeStackTrace) {
                toRet.append(TransformExceptionHelper.getStackTrace((Exception)((Object)e)));
            }
            toRet.append(TransformExceptionHelper.tagStart("TransformRuntimeException")).append(lineSeparator);
        }
        if ((next = e.getNextException()) != null) {
            toRet.append(TransformExceptionHelper.toXMLString(next, includeDataRecord, includeStackTrace));
        }
        return toRet.toString();
    }

    public static String toXMLString(TransformException tex, boolean includeDataRecord, boolean includeStackTrace) {
        DataObjectSection exceptionObjects = tex.getExceptions();
        FastStringBuffer toRet = new FastStringBuffer();
        for (int i = 0; i < exceptionObjects.getElementCount(); ++i) {
            try {
                ExceptionObject exceptionDataObject = (ExceptionObject)exceptionObjects.getElement(i);
                toRet.append(TransformExceptionHelper.toXMLString(exceptionDataObject, includeDataRecord));
                continue;
            }
            catch (FieldNotFoundException e) {
                LogFactory.log.unexpectedError(e);
            }
        }
        if (includeStackTrace) {
            toRet.append(TransformExceptionHelper.getStackTrace(tex));
        }
        return toRet.toString();
    }

    public static String toXMLString(ExceptionObject e, boolean includeDataRecord) {
        return TransformExceptionHelper.toXMLString(e, includeDataRecord, DumbEscapeHandler.getInstance());
    }

    public static String toXMLString(ExceptionObject e, boolean includeDataRecord, CharacterEscapeHandler characterEscapeHandler) {
        FastStringBuffer toRet = new FastStringBuffer();
        toRet.append(TransformExceptionHelper.tagStart("TransformException")).append(lineSeparator);
        boolean indent = true;
        DataObjectMetaInfo metaInfo = e.getMetaInfo();
        int count = metaInfo.getFieldCount();
        for (int i = 0; i < count; ++i) {
            try {
                FieldMetaInfo fieldMetaInfo = metaInfo.getFieldMetaInfo(i);
                Object obj = e.getField(i);
                if (obj instanceof DataObjectSection || obj == null) continue;
                QName qName = fieldMetaInfo.getXMLQName();
                DesignerType type = fieldMetaInfo.getDesignerType();
                toRet.append(TransformExceptionHelper.indentStr(1)).append("<").append(qName.getLocalPart()).append(">");
                characterEscapeHandler.escape(type.format(obj), toRet, false);
                toRet.append("</").append(qName.getLocalPart()).append(">");
                toRet.append(lineSeparator);
                continue;
            }
            catch (FieldNotFoundException ex) {
                // empty catch block
            }
        }
        Map exceptionContext = TransformExceptionHelper.writeExceptionContext(e, toRet);
        if (includeDataRecord) {
            for (String key : exceptionContext.keySet()) {
                Object value = exceptionContext.get(key);
                if (!(value instanceof DataObject)) continue;
                toRet.append(TransformExceptionHelper.getRecordString((DataObject)value, key));
            }
        }
        toRet.append(TransformExceptionHelper.tagEnd("TransformException")).append(lineSeparator);
        return toRet.toString();
    }

    public static Map writeExceptionContext(ExceptionObject e, FastStringBuffer toRet) {
        Map exceptionContext = e.getExceptionContext();
        return TransformExceptionHelper.writeExceptionContext(exceptionContext, toRet);
    }

    private static Map writeExceptionContext(Map exceptionContext, FastStringBuffer toRet) {
        for (String key : exceptionContext.keySet()) {
            Object value = exceptionContext.get(key);
            if (value instanceof DataObject || value == null) continue;
            toRet.append(TransformExceptionHelper.indentStr(1)).append(TransformExceptionHelper.tagStart(key));
            toRet.append(XMLUtils.fixXMLCharData(value.toString()));
            toRet.append(TransformExceptionHelper.tagEnd(key)).append(lineSeparator);
        }
        return exceptionContext;
    }

    public static String getStackTrace(Throwable e) {
        StringBuffer toRet = new StringBuffer();
        toRet.append(TransformExceptionHelper.indentStr(1)).append(TransformExceptionHelper.tagStart("StackTrace")).append(lineSeparator);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.flush();
        toRet.append(TransformExceptionHelper.indentStr(1));
        toRet.append(sw.toString());
        toRet.append(TransformExceptionHelper.indentStr(1)).append(TransformExceptionHelper.tagEnd("StackTrace")).append(lineSeparator);
        return toRet.toString();
    }

    public static String getRecordString(DataObject dobj, String key) {
        StringBuffer toRet = new StringBuffer();
        toRet.append(TransformExceptionHelper.indentStr(1)).append(TransformExceptionHelper.tagStart(key));
        toRet.append(lineSeparator);
        toRet.append(dobj.toXMLString(3));
        toRet.append(TransformExceptionHelper.indentStr(1));
        toRet.append(TransformExceptionHelper.tagEnd(key)).append(lineSeparator);
        return toRet.toString();
    }
}

