/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.ExceptionConstants;
import com.tplus.transform.runtime.StandardRuntimeResource;
import com.tplus.transform.runtime.TransformExceptionHelper;
import com.tplus.transform.runtime.TransformNestableException;
import java.util.Hashtable;
import java.util.Map;

public class TransformRuntimeException
extends RuntimeException
implements TransformNestableException,
ExceptionConstants {
    private Hashtable exceptionContext;
    private static final long serialVersionUID = -9117809532704668114L;

    public TransformRuntimeException() {
    }

    public TransformRuntimeException(String message) {
        super(message);
    }

    public TransformRuntimeException(String s, Throwable ex) {
        super(s);
        this.setDetail(ex);
    }

    public String toXMLString() {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean includeDataRecord, boolean includeStackTrace) {
        return TransformExceptionHelper.toXMLString(this, includeDataRecord, includeStackTrace);
    }

    public Map getExceptionContext() {
        if (this.exceptionContext == null) {
            this.exceptionContext = new Hashtable();
        }
        return this.exceptionContext;
    }

    public void setContextProperty(String name, Object value) {
        if (value == null) {
            this.getExceptionContext().remove(name);
        } else {
            this.getExceptionContext().put(name, value);
        }
    }

    public Object getContextProperty(String name) {
        return this.getExceptionContext().get(name);
    }

    public String getContextMessage() {
        if (this.exceptionContext == null) {
            return "";
        }
        return this.exceptionContext.toString();
    }

    public String getMessage() {
        if (this.getCause() == null) {
            return super.getMessage();
        }
        return super.getMessage() + "; nested exception is: \n\t" + this.getCause().toString();
    }

    public String getFullMessage() {
        if (this.getCause() == null) {
            return super.getMessage() + this.getContextMessage();
        }
        return super.getMessage() + this.getContextMessage() + "; nested exception is: \n\t" + this.getCause().toString();
    }

    public String getErrorCode() {
        return (String)this.getContextProperty("Error-Code");
    }

    public void setErrorCode(String errorCode) {
        this.setContextProperty("Error-Code", errorCode);
    }

    public TransformNestableException getNextException() {
        return null;
    }

    public void setDetail(Throwable ex) {
        if (ex != null) {
            this.initCause(ex);
        }
    }

    public static TransformRuntimeException createFormatted(String messageId) {
        return TransformRuntimeException.createFormatted(TransformRuntimeException.class, messageId);
    }

    public static TransformRuntimeException createFormatted(String messageId, String arg) {
        return TransformRuntimeException.createFormatted(TransformRuntimeException.class, messageId, arg);
    }

    public static TransformRuntimeException createFormatted(String messageId, Object[] args) {
        return TransformRuntimeException.createFormatted(TransformRuntimeException.class, messageId, args);
    }

    public static TransformRuntimeException createFormatted(Class exceptionClass, String messageId) {
        return (TransformRuntimeException)StandardRuntimeResource.createFormatted(exceptionClass, messageId);
    }

    public static TransformRuntimeException createFormatted(Class exceptionClass, String messageId, String arg) {
        return (TransformRuntimeException)StandardRuntimeResource.createFormatted(exceptionClass, messageId, arg);
    }

    public static TransformRuntimeException createFormatted(Class exceptionClass, String messageId, Object[] args) {
        return (TransformRuntimeException)StandardRuntimeResource.createFormatted(exceptionClass, messageId, args);
    }

    public void addTrace(String entityType, String entity, String subEntity) {
        String trace = (String)this.getContextProperty("Trace");
        String toAdd = "at " + entity;
        if (subEntity != null) {
            toAdd = toAdd + "." + subEntity;
        }
        trace = trace == null ? toAdd : trace + "\n    " + toAdd;
        this.setContextProperty("Trace", trace);
    }
}

