/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractRules;
import com.tplus.transform.runtime.AbstractTriggerContext;
import com.tplus.transform.runtime.NormalizedObject;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TriggerContextFactory;
import com.tplus.transform.runtime.TriggerInfo;
import com.tplus.transform.runtime.handler.ITrigger;
import com.tplus.transform.runtime.handler.TriggerContext;
import java.rmi.RemoteException;
import java.util.Properties;

public abstract class Triggers
extends AbstractRules {
    private TriggerContextFactory contextFactory;

    public Triggers() {
        super(null);
    }

    public void setTriggerContextFactory(TriggerContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    protected TriggerContextFactory getTriggerContextFactory() {
        return this.contextFactory;
    }

    public Object invokeTrigger(Properties props) throws TransformException {
        throw TransformException.createFormatted("SRT650");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onNewMessage(NormalizedObject inputObj, TransformContext cxt) throws TransformException {
        try {
            this.setup(cxt);
            this.onNewMessage0(inputObj, cxt);
        }
        finally {
            this.teardown(cxt);
        }
    }

    protected abstract void onNewMessage0(NormalizedObject var1, TransformContext var2) throws TransformException;

    public abstract void onBatchStart(TransformContext var1) throws TransformException, RemoteException;

    public abstract void onBatchEnd(TransformContext var1) throws TransformException, RemoteException;

    protected ITrigger getTriggerObject(TriggerInfo triggerInfo) throws TransformException {
        ITrigger trigger = triggerInfo.getTriggerObject();
        if (trigger == null) {
            trigger = this.createTriggerInstance(triggerInfo.getTriggerClassName());
            TriggerContext cxt = this.contextFactory.createTriggerContext();
            AbstractTriggerContext absCxt = (AbstractTriggerContext)cxt;
            absCxt.setIdentity(triggerInfo.getIdentity());
            absCxt.setProperties(triggerInfo.getProperties());
            trigger.setContext(cxt);
            triggerInfo.setTriggerObject(trigger);
        }
        return trigger;
    }

    private ITrigger createTriggerInstance(String triggerClass) throws TransformException {
        try {
            Class<?> cls = Class.forName(triggerClass, true, this.getClass().getClassLoader());
            if (ITrigger.class.isAssignableFrom(cls)) {
                ITrigger trigger = (ITrigger)cls.newInstance();
                return trigger;
            }
            throw TransformException.createFormatted("SRT100", triggerClass);
        }
        catch (ClassNotFoundException e) {
            TransformException te = TransformException.createFormatted("SRT101");
            te.setDetail(e);
            throw te;
        }
        catch (InstantiationException e) {
            TransformException te = TransformException.createFormatted("SRT102");
            te.setDetail(e);
            throw te;
        }
        catch (IllegalAccessException e) {
            TransformException te = TransformException.createFormatted("SRT102");
            te.setDetail(e);
            throw te;
        }
    }
}

