/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.lang.ScaledDecimal;
import com.tplus.transform.runtime.AbstractVariant;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.DesignerTypes;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.Variant;
import com.tplus.transform.runtime.collection.ValueList;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;

public abstract class VariantBase
extends AbstractVariant {
    protected VariantBase(DesignerType type) {
        super(type);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public int compareTo(Object obj) {
        Variant other = (Variant)obj;
        Object value = this.getValue();
        Object otherValue = other.getValue();
        if (value != null && otherValue != null) {
            if (value instanceof Comparable) {
                return ((Comparable)value).compareTo(otherValue);
            }
        } else {
            if (value == otherValue) {
                return 0;
            }
            if (value == null) {
                return -1;
            }
            return -1;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Variant) {
            Variant other = (Variant)obj;
            if (this.isNull() || other.isNull()) {
                return this.isNull() == other.isNull();
            }
            if (this.type != other.getType() && this.type.isNumeric()) {
                return this.wideningEquals(other);
            }
            Object value = this.getValue();
            return value.equals(other.getValue());
        }
        return false;
    }

    private boolean wideningEquals(Variant other) {
        DesignerType thisType = this.getType();
        DesignerType otherType = other.getType();
        if (thisType == DesignerTypes.DOUBLE_TYPE || otherType == DesignerTypes.DOUBLE_TYPE) {
            return this.toDouble() == other.toDouble();
        }
        if (thisType == DesignerTypes.FLOAT_TYPE || otherType == DesignerTypes.FLOAT_TYPE) {
            return this.toFloat() == other.toFloat();
        }
        if (thisType == DesignerTypes.LONG_TYPE || otherType == DesignerTypes.LONG_TYPE) {
            return this.toLong() == other.toLong();
        }
        if (thisType == DesignerTypes.INT_TYPE || otherType == DesignerTypes.INT_TYPE) {
            return this.toInt() == other.toInt();
        }
        return false;
    }

    public boolean notEquals(Object obj) {
        return !this.equals(obj);
    }

    public int hashCode() {
        Object value = this.getValue();
        return value == null ? 0 : value.hashCode();
    }

    public String toString() {
        return this.toText();
    }

    public boolean isNull() {
        Object value = this.getValue();
        return value == null;
    }

    public boolean isNotNull() {
        return !this.isNull();
    }

    public String toText() {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        if (this.type == DesignerType.DESIGNER_STRING_TYPE) {
            return value.toString();
        }
        return this.type.format(value);
    }

    public int toInt() {
        this.ensureNotNull();
        if (this.type.isNumeric()) {
            return ((Number)this.getValue()).intValue();
        }
        return this.throwTypeMismatch(DesignerType.DESIGNER_INT_TYPE);
    }

    public long toLong() {
        this.ensureNotNull();
        if (this.type.isNumeric()) {
            return ((Number)this.getValue()).longValue();
        }
        return this.throwTypeMismatch(DesignerType.DESIGNER_LONG_TYPE);
    }

    public double toDouble() {
        this.ensureNotNull();
        if (this.type.isNumeric()) {
            return ((Number)this.getValue()).doubleValue();
        }
        return this.throwTypeMismatch(DesignerType.DESIGNER_DOUBLE_TYPE);
    }

    public float toFloat() {
        this.ensureNotNull();
        if (this.type.isNumeric()) {
            return ((Number)this.getValue()).floatValue();
        }
        return this.throwTypeMismatch(DesignerType.DESIGNER_FLOAT_TYPE);
    }

    public boolean toBoolean() {
        this.ensureNotNull();
        if (this.type == DesignerType.DESIGNER_BOOLEAN_TYPE) {
            return (Boolean)this.getValue();
        }
        this.throwTypeMismatch(DesignerType.DESIGNER_BOOLEAN_TYPE);
        return false;
    }

    public char toChar() {
        this.ensureNotNull();
        if (this.type == DesignerType.DESIGNER_CHAR_TYPE) {
            return ((Character)this.getValue()).charValue();
        }
        this.throwTypeMismatch(DesignerType.DESIGNER_CHAR_TYPE);
        return '\u0000';
    }

    public Date toDate() {
        if (this.type == DesignerType.DESIGNER_DATE_ONLY_TYPE || this.type == DesignerType.DESIGNER_DATE_TIME_TYPE || this.type == DesignerType.DESIGNER_TIME_ONLY_TYPE) {
            return (Date)this.getValue();
        }
        this.throwTypeMismatch(DesignerType.DESIGNER_DATE_ONLY_TYPE);
        return null;
    }

    public Calendar toISODate() {
        if (this.type == DesignerType.DESIGNER_ISO_DATE_TYPE || this.type == DesignerType.DESIGNER_ISO_TIME_TYPE || this.type == DesignerType.DESIGNER_ISO_DATE_TIME_TYPE) {
            return (Calendar)this.getValue();
        }
        this.throwTypeMismatch(DesignerType.DESIGNER_ISO_DATE_TYPE);
        return null;
    }

    public BigInteger toBigInteger() {
        this.ensureNotNull();
        if (this.type == DesignerType.DESIGNER_BIG_INT_TYPE) {
            return (BigInteger)this.getValue();
        }
        this.throwTypeMismatch(DesignerType.DESIGNER_BIG_INT_TYPE);
        return null;
    }

    public BigDecimal toBigDecimal() {
        this.ensureNotNull();
        if (this.type == DesignerType.DESIGNER_BIG_DECIMAL_TYPE) {
            return (BigDecimal)this.getValue();
        }
        this.throwTypeMismatch(DesignerType.DESIGNER_BIG_DECIMAL_TYPE);
        return null;
    }

    public ScaledDecimal toScaledDecimal() {
        this.ensureNotNull();
        if (this.type == DesignerType.DESIGNER_SCALED_DECIMAL_TYPE) {
            return (ScaledDecimal)this.getValue();
        }
        this.throwTypeMismatch(DesignerType.DESIGNER_SCALED_DECIMAL_TYPE);
        return null;
    }

    public RawMessage toRawMessage() {
        this.ensureNotNull();
        if (this.type == DesignerType.DESIGNER_RAW_MESSAGE_TYPE) {
            return (RawMessage)this.getValue();
        }
        this.throwTypeMismatch(DesignerType.DESIGNER_RAW_MESSAGE_TYPE);
        return null;
    }

    public byte[] toBinary() {
        this.ensureNotNull();
        if (this.type == DesignerType.DESIGNER_BINARY_TYPE) {
            return (byte[])this.getValue();
        }
        this.throwTypeMismatch(DesignerType.DESIGNER_BINARY_TYPE);
        return null;
    }

    public DataObjectSection getSection() {
        this.ensureNotNull();
        if (this.type == DesignerType.DESIGNER_SECTION_TYPE) {
            return (DataObjectSection)this.getValue();
        }
        this.throwTypeMismatch(DesignerType.DESIGNER_SECTION_TYPE);
        return null;
    }

    public DataObject getDataObject() {
        this.ensureNotNull();
        if (this.type == DesignerType.DESIGNER_DATAOBJECT_TYPE) {
            return (DataObject)this.getValue();
        }
        this.throwTypeMismatch(DesignerType.DESIGNER_DATAOBJECT_TYPE);
        return null;
    }

    public ValueList toList() {
        this.ensureNotNull();
        if (this.type.isListType()) {
            return (ValueList)this.getValue();
        }
        this.throwTypeMismatch(DesignerType.DESIGNER_STRING_LIST_TYPE);
        return null;
    }
}

