/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.lang.Wrapper;
import com.tplus.transform.runtime.Base64Binary;
import com.tplus.transform.runtime.ByteArrayInputSource;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.LookupContext;
import com.tplus.transform.runtime.LookupContextFactory;
import com.tplus.transform.runtime.MessageFlow;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.StringInputSource;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformContextImpl;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.xml.XMLUtils;
import com.tplus.transform.util.xml.XMLWriterUtil;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class VolanteFlowWrapper {
    private static final String PARAM_TAG = "Param";
    private static final String NAME_ATTR = "name";
    private static final String INDEX_ATTR = "index";
    private static final String FORMAT_ATTR = "format";
    private static final String OUTPUT_TAG = "Output";
    private static final String FAULT_TAG = "Fault";
    private static final String VOLANTE_PARAMS_TAG = "VolanteParams";
    private static final String INPUT_TAG = "Input";
    public static final String BASE64 = "base64";
    private static LookupContext lcxt = null;
    static Map flows = new HashMap();

    private VolanteFlowWrapper() {
    }

    public static String invoke(String flowName, Object[] inputParams) throws TransformException {
        try {
            MessageFlow messageFlow = VolanteFlowWrapper.lookupFlow(flowName);
            DataObject inputDataObject = messageFlow.createInputDataObject();
            VolanteFlowWrapper.mapToInputDataObjFromParams(inputDataObject, inputParams);
            DataObject outputDataObject = messageFlow.run(inputDataObject, (TransformContext)new TransformContextImpl());
            if (outputDataObject.getFieldCount() > 0) {
                Object field = outputDataObject.getField(0);
                return outputDataObject.getFieldDesignerType(0).format(field);
            }
            return null;
        }
        catch (NamingException e) {
            throw new TransformException(e.getMessage());
        }
        catch (RemoteException e) {
            throw new TransformException(e.getMessage());
        }
    }

    public static String invokeFlowXML(String flowName, Object[] inputParams) throws TransformException {
        try {
            MessageFlow messageFlow = VolanteFlowWrapper.lookupFlow(flowName);
            DataObject inputDataObject = messageFlow.createInputDataObject();
            VolanteFlowWrapper.mapToInputDataObjFromParams(inputDataObject, inputParams);
            TransformException transEx = null;
            DataObject outputDataObject = null;
            try {
                outputDataObject = messageFlow.run(inputDataObject, (TransformContext)new TransformContextImpl());
            }
            catch (TransformRuntimeException e) {
                transEx = new TransformException(e.getMessage(), e);
            }
            catch (TransformException e) {
                transEx = e;
            }
            String outputXML = VolanteFlowWrapper.mapOutputDataObjectToXML(outputDataObject, transEx);
            return outputXML;
        }
        catch (NamingException e) {
            throw new TransformException(e.getMessage());
        }
        catch (RemoteException e) {
            throw new TransformException(e.getMessage());
        }
    }

    private static void mapToInputDataObjFromParams(DataObject inputDataObject, Object[] inputParams) throws TransformException {
        if (inputDataObject.getFieldCount() != inputParams.length) {
            throw new TransformException("Mismatch in number of arguments, expected " + inputDataObject.getFieldCount() + " found " + inputParams.length);
        }
        for (int index = 0; index < inputParams.length; ++index) {
            DesignerType dType = inputDataObject.getFieldDesignerType(index);
            if (String.class == inputParams[index].getClass() && dType != DesignerType.DESIGNER_STRING_TYPE && inputParams[index] != null) {
                inputDataObject.setField(index, dType.parse((String)inputParams[index]));
                continue;
            }
            inputDataObject.setField(index, inputParams[index]);
        }
    }

    public static void parseInputObjectFromXML(DataObject inputDataObject, RawMessage message) throws TransformException {
        try {
            Document document = XMLUtils.createDocument(message.getAsStream());
            Element documentElement = document.getDocumentElement();
            if (!documentElement.getTagName().equals(VOLANTE_PARAMS_TAG)) {
                throw new TransformException("Invalid message flow input XML. Expected root tag VolanteParams");
            }
            Element inputElm = XMLUtils.getSingleChildElement(documentElement, INPUT_TAG);
            NodeList paramElms = XMLUtils.getChildElementsByTagName(inputElm, PARAM_TAG);
            DataObjectMetaInfo metaInfo = inputDataObject.getMetaInfo();
            for (int i = 0; i < paramElms.getLength(); ++i) {
                Object fieldValue;
                int index;
                Element elm = (Element)paramElms.item(i);
                String elementText = XMLUtils.getElementText(elm);
                String name = elm.getAttribute(NAME_ATTR);
                String indexStr = elm.getAttribute(INDEX_ATTR);
                String formatStr = elm.getAttribute(FORMAT_ATTR);
                if (StringUtils.isNotEmpty(name)) {
                    index = metaInfo.getFieldIndexIfExists(name);
                    if (index == -1) {
                        throw new TransformException("Invalid parameter to flow. Flow does not take parameter by name " + name);
                    }
                    fieldValue = VolanteFlowWrapper.toFieldValue(metaInfo.getFieldDesignerType(index), elementText, formatStr);
                    inputDataObject.setField(index, fieldValue);
                    continue;
                }
                index = Wrapper.parseInt(indexStr) - 1;
                fieldValue = VolanteFlowWrapper.toFieldValue(metaInfo.getFieldDesignerType(index), elementText, formatStr);
                inputDataObject.setField(index, fieldValue);
            }
        }
        catch (SAXException e) {
            throw new TransformException("Error parsing flow input XML", e);
        }
        catch (ParserConfigurationException e) {
            throw new TransformException("Error parsing flow input XML", e);
        }
        catch (IOException e) {
            throw new TransformException("Error parsing flow input XML", e);
        }
    }

    private static Object toFieldValue(DesignerType fieldDesignerType, String elementText, String formatStr) throws TransformException {
        if (BASE64.equals(formatStr)) {
            byte[] bytes = Base64Binary.toBinary(elementText);
            if (fieldDesignerType == DesignerType.DESIGNER_BINARY_TYPE) {
                return bytes;
            }
            if (fieldDesignerType == DesignerType.DESIGNER_RAW_MESSAGE_TYPE) {
                return new ByteArrayInputSource(bytes);
            }
            throw new TransformException("Unexpected format " + formatStr + " for field of type " + fieldDesignerType);
        }
        if (fieldDesignerType == DesignerType.DESIGNER_RAW_MESSAGE_TYPE) {
            return new StringInputSource(elementText);
        }
        Object fieldValue = fieldDesignerType.parse(elementText);
        return fieldValue;
    }

    public static String mapOutputDataObjectToXML(DataObject outputDataObject, TransformException exceptionList) throws TransformException {
        StringBuffer buffer = new StringBuffer(500);
        XMLWriterUtil xmlWriterUtil = new XMLWriterUtil();
        buffer.append(xmlWriterUtil.getXMLDecl());
        buffer.append(xmlWriterUtil.startTag(VOLANTE_PARAMS_TAG));
        if (outputDataObject != null) {
            buffer.append(xmlWriterUtil.startTag(OUTPUT_TAG));
            int fieldCount = outputDataObject.getFieldCount();
            for (int i = 0; i < fieldCount; ++i) {
                DesignerType designerType = outputDataObject.getFieldDesignerType(i);
                if (!designerType.isPrimitiveType()) {
                    throw new TransformException("Only primitives can be handled. Encountered type - " + designerType.getName());
                }
                String fieldName = outputDataObject.getFieldName(i);
                Object fieldValue = outputDataObject.getField(i);
                if (fieldValue == null) continue;
                String format = null;
                String tagValue = null;
                if (designerType == DesignerType.DESIGNER_ISO_DATE_TIME_TYPE || designerType == DesignerType.DESIGNER_DATE_TIME_TYPE || designerType == DesignerType.DESIGNER_ISO_DATE_TYPE || designerType == DesignerType.DESIGNER_DATE_ONLY_TYPE || designerType == DesignerType.DESIGNER_ISO_TIME_TYPE || designerType == DesignerType.DESIGNER_TIME_ONLY_TYPE) {
                    tagValue = designerType.format(fieldValue);
                } else if (designerType == DesignerType.DESIGNER_BINARY_TYPE) {
                    format = BASE64;
                    tagValue = Base64Binary.fromBinary((byte[])fieldValue);
                } else if (designerType == DesignerType.DESIGNER_RAW_MESSAGE_TYPE) {
                    RawMessage raw = (RawMessage)fieldValue;
                    if (raw.isBinary()) {
                        format = BASE64;
                        tagValue = Base64Binary.fromBinary(raw.getAsBytes());
                    } else {
                        tagValue = raw.getAsString("utf-8");
                    }
                } else {
                    tagValue = designerType == DesignerType.DESIGNER_STRING_TYPE ? fieldValue.toString() : designerType.format(fieldValue);
                }
                if (format != null) {
                    buffer.append(xmlWriterUtil.tagValueWithAttribCData(PARAM_TAG, tagValue, new String[]{NAME_ATTR, fieldName, INDEX_ATTR, String.valueOf(i + 1), FORMAT_ATTR, format}));
                    continue;
                }
                buffer.append(xmlWriterUtil.tagValueWithAttribCData(PARAM_TAG, tagValue, new String[]{NAME_ATTR, fieldName, INDEX_ATTR, String.valueOf(i + 1)}));
            }
            buffer.append(xmlWriterUtil.endTag(OUTPUT_TAG));
        }
        if (exceptionList != null) {
            buffer.append(xmlWriterUtil.startTag(FAULT_TAG));
            buffer.append(exceptionList.toXMLString());
            buffer.append(xmlWriterUtil.endTag(FAULT_TAG));
        }
        buffer.append(xmlWriterUtil.endTag(VOLANTE_PARAMS_TAG));
        return buffer.toString();
    }

    private static synchronized MessageFlow lookupFlow(String flowName) throws NamingException {
        MessageFlow flow;
        if (lcxt == null) {
            lcxt = LookupContextFactory.getLookupContext();
        }
        if ((flow = (MessageFlow)flows.get(flowName)) == null) {
            flow = lcxt.lookupMessageFlow(flowName);
            flows.put(flowName, flow);
        }
        return flow;
    }
}

