/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.util.IOUtil;
import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;

class VolanteIOUtil {
    private static File defaultTempDir;

    VolanteIOUtil() {
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return VolanteIOUtil.createTempFile(prefix, suffix, null);
    }

    public static File createTempFile(String prefix, String suffix, File parentDir) throws IOException {
        File parent;
        File file = parent = parentDir == null ? VolanteIOUtil.getDefaultTempDir() : parentDir;
        if (suffix == null) {
            suffix = ".tmp";
        }
        if (prefix == null) {
            prefix = "volante";
        } else if (prefix.length() < 3) {
            prefix = prefix + "volante";
        }
        parent.mkdirs();
        return File.createTempFile(prefix, suffix, parent);
    }

    private static synchronized File getDefaultTempDir() {
        if (defaultTempDir != null && defaultTempDir.exists()) {
            return defaultTempDir;
        }
        String s = System.getProperty("java.io.tmpdir");
        File checkExists = new File(s);
        if (!checkExists.exists()) {
            throw new RuntimeException("The directory " + checkExists.getAbsolutePath() + " does not exist, please set java.io.tempdir" + " to an existing directory");
        }
        SecureRandom ran = new SecureRandom();
        int x = ran.nextInt(1000000);
        File f = new File(s, "volante-tmp-" + x);
        while (!f.mkdir()) {
            x = ran.nextInt(1000000);
            f = new File(s, "volante-tmp-" + x);
        }
        defaultTempDir = f;
        Thread hook = new Thread(){

            public void run() {
                IOUtil.delDir(defaultTempDir);
            }
        };
        Runtime.getRuntime().addShutdownHook(hook);
        return defaultTempDir;
    }
}

