/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.ascii;

import com.tplus.transform.runtime.AbstractInputParser;
import com.tplus.transform.runtime.AbstractServiceElement;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.ExternalObject;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.FieldParsingException;
import com.tplus.transform.runtime.InputSource;
import com.tplus.transform.runtime.MessageHandler;
import com.tplus.transform.runtime.Parsing;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.ascii.ASCIIDelimitedParseException;
import com.tplus.transform.runtime.ascii.ASCIIDelimitedResource;
import com.tplus.transform.runtime.ascii.CSVRecord;
import com.tplus.transform.runtime.ascii.CSVTokenizer;
import com.tplus.transform.runtime.ascii.LineIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public abstract class ASCIIDelimitedInputParser
extends AbstractInputParser {
    String encoding;
    String delimiter;
    char delimiterChar;
    boolean batchMode;
    boolean singleRecordMode;
    boolean containsHeader;
    boolean containsTrailer;
    static CSVRecord DUMMY_RECORD = new CSVRecord();

    protected ASCIIDelimitedInputParser(AbstractServiceElement serviceElement) {
        super(serviceElement);
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        this.delimiterChar = delimiter.charAt(0);
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public void setBatchMode(boolean batchMode) {
        this.batchMode = batchMode;
    }

    public boolean isSingleRecordMode() {
        return this.singleRecordMode;
    }

    public void setSingleRecordMode(boolean singleRecordMode) {
        this.singleRecordMode = singleRecordMode;
    }

    public boolean isContainsHeader() {
        return this.containsHeader;
    }

    public void setContainsHeader(boolean containsHeader) {
        this.containsHeader = containsHeader;
    }

    public boolean isContainsTrailer() {
        return this.containsTrailer;
    }

    public void setContainsTrailer(boolean containsTrailer) {
        this.containsTrailer = containsTrailer;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected ExternalObject doParse(InputSource is, TransformContext cxt) throws TransformException {
        return this.doParseBatch(is, cxt)[0];
    }

    protected ExternalObject[] doParseBatch(InputSource is, TransformContext cxt) throws TransformException {
        final ArrayList messages = new ArrayList();
        this.parseBatch0(is, new MessageHandler(){

            public boolean handleMessage(DataObject obj, TransformContext cxt) {
                messages.add(obj);
                return true;
            }
        }, cxt);
        return messages.toArray(new ExternalObject[messages.size()]);
    }

    public void parseBatch0(InputSource is, MessageHandler messageHandler, TransformContext tcxt) throws TransformException {
        CSVTokenizer tokenizer = new CSVTokenizer(this.delimiterChar);
        LineIterator it = null;
        try {
            String specifiedEncoding = ASCIIDelimitedInputParser.getPreferredEncoding(is, tcxt);
            RawMessage rawMessage = (RawMessage)is;
            it = new LineIterator(rawMessage, specifiedEncoding);
            DataObject header = this.parseHeader(it, tokenizer);
            DataObject trailer = this.preParseTrailerForBatch(rawMessage, specifiedEncoding);
            DataObject data = null;
            DataObjectSection dataRecordsSection = null;
            if (!this.batchMode && !this.singleRecordMode) {
                data = this.createRecordData();
                dataRecordsSection = data.getSection(0);
            }
            CSVRecord record = new CSVRecord();
            String trailerLine = null;
            int i = 0;
            while (it.hasNext()) {
                String recLine = it.next();
                try {
                    ExternalObject externalObject;
                    if (this.containsTrailer && !it.hasNext()) {
                        trailerLine = recLine;
                        break;
                    }
                    tokenizer.parseRecord(recLine, record);
                    if (this.batchMode) {
                        data = this.parseRecordData(record, null);
                    } else if (this.singleRecordMode) {
                        if (data != null) {
                            throw ASCIIDelimitedResource.createASCIIDelimitedParseExceptionFormatted("ASC125");
                        }
                        data = this.parseRecordData(record, null);
                    } else {
                        DataObject dataElement = this.parseRecordData(record, dataRecordsSection);
                    }
                    if (this.batchMode && !messageHandler.handleMessage(externalObject = this.createExternalObject(header, data, trailer), tcxt)) {
                        break;
                    }
                }
                catch (TransformException e) {
                    e.setContextProperty("Error-Record-Index", Integer.toString(i));
                    e.setContextProperty("line", Integer.toString(this.containsHeader ? i + 2 : i + 1));
                    e.setContextProperty("Error-Line", recLine);
                    this.updateError(e, "Record");
                    if (this.batchMode) {
                        this.getExceptionHandler().onException(e);
                    }
                    throw e;
                }
                ++i;
            }
            if (this.singleRecordMode && data == null) {
                throw ASCIIDelimitedResource.createASCIIDelimitedParseExceptionFormatted("ASC126");
            }
            if (!this.batchMode) {
                trailer = this.parseTrailer(trailerLine);
                ExternalObject externalObject = this.createExternalObject(header, data, trailer);
                messageHandler.handleMessage(externalObject, tcxt);
            }
        }
        catch (IOException e) {
            ASCIIDelimitedParseException ex = ASCIIDelimitedResource.createASCIIDelimitedParseExceptionFormatted("ASC124");
            ex.setDetail(e);
            throw ex;
        }
        finally {
            if (it != null) {
                try {
                    it.close();
                }
                catch (IOException e) {
                    this.getLogger().error("IOError", e);
                }
            }
        }
    }

    private DataObject preParseTrailerForBatch(RawMessage is, String encoding) throws IOException, TransformException {
        DataObject trailer = null;
        if (this.batchMode) {
            String trailerLine = "";
            if (this.containsTrailer) {
                trailerLine = LineIterator.getTrailerLine(is, encoding);
            }
            trailer = this.parseTrailer(trailerLine);
        }
        return trailer;
    }

    private void updateError(TransformException e, String location) {
        e.setContextProperty("Location", location);
        e.setErrorType("Parsing");
        e.setErrorPhase("Input");
    }

    private DataObject parseTrailer(String trailerLine) throws TransformException {
        if (this.containsTrailer) {
            DataObject trailer;
            CSVTokenizer tokenizer = new CSVTokenizer(this.delimiter.charAt(0));
            if (trailerLine == null) {
                throw ASCIIDelimitedResource.createASCIIDelimitedParseExceptionFormatted("ASC127");
            }
            CSVRecord rec = tokenizer.parseRecord(trailerLine);
            try {
                trailer = this.parseTrailer(rec);
            }
            catch (TransformException e) {
                this.updateError(e, "Trailer");
                throw e;
            }
            return trailer;
        }
        DataObject trailer = this.parseTrailer(DUMMY_RECORD);
        return trailer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DataObject parseHeader(LineIterator it, CSVTokenizer tokenizer) throws TransformException {
        if (!this.containsHeader) return this.parseHeader(DUMMY_RECORD);
        if (!it.hasNext()) throw ASCIIDelimitedResource.createASCIIDelimitedParseExceptionFormatted("ASC123");
        String headerLine = it.next();
        CSVRecord csvheader = tokenizer.parseRecord(headerLine);
        try {
            return this.parseHeader(csvheader);
        }
        catch (TransformException e) {
            this.updateError(e, "Header");
            throw e;
        }
    }

    protected abstract DataObject parseRecordData(CSVRecord var1, DataObjectSection var2) throws TransformException;

    protected abstract DataObject parseHeader(CSVRecord var1) throws TransformException;

    protected abstract DataObject parseTrailer(CSVRecord var1) throws TransformException;

    protected DataObject createRecordData() throws TransformException {
        throw ASCIIDelimitedResource.createASCIIDelimitedParseExceptionFormatted("ASC102");
    }

    public void fieldCountError(String recordTypeName, int expectedFieldCount, int fieldCount) throws TransformException {
        this.onError(ASCIIDelimitedResource.createASCIIDelimitedParseExceptionFormatted("ASC122", new Object[]{recordTypeName, String.valueOf(expectedFieldCount), String.valueOf(fieldCount)}));
    }

    public void ensureFieldCount(String recordTypeName, int expectedFieldCount, CSVRecord record) throws TransformException {
        if (record.getFieldCount() != expectedFieldCount) {
            if (record.getFieldCount() == 0 && expectedFieldCount == 1) {
                record.addField(null);
            } else {
                this.fieldCountError(recordTypeName, expectedFieldCount, record.getFieldCount());
            }
        }
    }

    protected boolean ensureValueNotNull(String value, DataObject object, int index) throws TransformException {
        if (value == null) {
            try {
                String fldName = object.getFieldName(index);
                FieldParsingException e = FieldParsingException.createFieldParsingExceptionFormatted("SRT129", fldName);
                e.setField(object, index, null);
                e.setErrorType("Required");
                this.onError(e);
                return false;
            }
            catch (FieldNotFoundException e) {
                throw FieldParsingException.createFieldParsingExceptionFormatted("SRT128");
            }
        }
        return true;
    }

    protected boolean isNull(String value) throws FieldParsingException {
        return value == null;
    }

    protected void onFieldValueError(TransformException e, DataObject object, int index, String value) throws TransformException {
        e.setField(object, index, value);
        this.onError(e);
    }

    protected void onError(TransformException e) throws TransformException {
        this.getExceptionHandler().onException(e);
    }

    public Date parseDate(String str, String format) throws TransformException {
        if (format.indexOf("yy") == -1 && (format.indexOf("dd") != -1 || format.indexOf("MM") != -1)) {
            format = "yyyy" + format;
            str = Calendar.getInstance().get(1) + str;
        }
        return Parsing.parseDate(str, format);
    }

    public Calendar parseISODate(String str, String format) throws TransformException {
        if (format.indexOf("Y") == -1 && (format.indexOf("D") != -1 || format.indexOf("M") != -1)) {
            format = "%Y-" + format;
            str = Calendar.getInstance().get(1) + "-" + str;
        }
        return Parsing.parseISODate(str, format);
    }
}

