/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.ascii;

import com.tplus.transform.lang.ScaledDecimal;
import com.tplus.transform.runtime.AbstractBatchOutputWriter;
import com.tplus.transform.runtime.AbstractServiceElement;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.Parsing;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.ascii.ASCIIDelimitedResource;
import com.tplus.transform.runtime.ascii.ASCIIDelimitedWriteException;
import com.tplus.transform.runtime.formula.FormatFunctions;
import com.tplus.transform.runtime.formula.TextFunctions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;

public abstract class ASCIIDelimitedOutputWriter
extends AbstractBatchOutputWriter {
    public static final char DOUBLE_QUOTE = '\"';
    protected static final String lineSeparator = System.getProperty("line.separator");
    char delimiterChar = (char)44;
    boolean containsHeader;
    boolean containsTrailer;
    private transient StringBuffer nonEmptyBuffer;

    public ASCIIDelimitedOutputWriter(AbstractServiceElement serviceElement) {
        super(serviceElement);
    }

    public void setDelimiter(String delimiter) {
        this.delimiterChar = delimiter.charAt(0);
    }

    public void setDelimiter(char delimiter) {
        this.delimiterChar = delimiter;
    }

    public boolean isContainsHeader() {
        return this.containsHeader;
    }

    public void setContainsHeader(boolean containsHeader) {
        this.containsHeader = containsHeader;
    }

    public boolean isContainsTrailer() {
        return this.containsTrailer;
    }

    public void setContainsTrailer(boolean containsTrailer) {
        this.containsTrailer = containsTrailer;
    }

    private void appendDelimiter(StringBuffer buffer) {
        if (!this.isFirstField(buffer)) {
            buffer.append(this.delimiterChar);
        }
    }

    private boolean isFirstField(StringBuffer buffer) {
        return buffer.length() == 0 && buffer != this.nonEmptyBuffer;
    }

    protected void appendField(int value, StringBuffer buffer) {
        this.appendDelimiter(buffer);
        buffer.append(Parsing.toString(value));
    }

    protected void appendField(float value, StringBuffer buffer) {
        this.appendDelimiter(buffer);
        buffer.append(Parsing.toString(value));
    }

    protected void appendField(long value, StringBuffer buffer) {
        this.appendDelimiter(buffer);
        buffer.append(Parsing.toString(value));
    }

    protected void appendField(double value, StringBuffer buffer) {
        this.appendDelimiter(buffer);
        buffer.append(Parsing.toString(value));
    }

    protected void appendField(ScaledDecimal value, StringBuffer buffer) {
        this.appendDelimiter(buffer);
        buffer.append(Parsing.toString(value));
    }

    protected void appendField(boolean value, StringBuffer buffer) {
        this.appendDelimiter(buffer);
        buffer.append(value ? "true" : "false");
    }

    private static boolean requiresEnclosingQuotes(String value, char delimiter) {
        if (value.length() == 0) {
            return true;
        }
        char firstChar = value.charAt(0);
        if (Character.isWhitespace(firstChar) || firstChar == '\"') {
            return true;
        }
        if (Character.isWhitespace(value.charAt(value.length() - 1))) {
            return true;
        }
        return value.indexOf(delimiter) != -1;
    }

    protected void appendField(String value, StringBuffer buffer) {
        this.appendDelimiter(buffer);
        if (value != null) {
            if (ASCIIDelimitedOutputWriter.requiresEnclosingQuotes(value, this.delimiterChar)) {
                if (value.indexOf(34) != -1) {
                    value = TextFunctions.replace(value, '\"', "\"\"");
                }
                buffer.append('\"').append(value).append('\"');
            } else {
                buffer.append(value);
            }
        } else if (buffer.length() == 0) {
            this.nonEmptyBuffer = buffer;
        }
    }

    protected void appendField(char value, StringBuffer buffer) {
        this.appendDelimiter(buffer);
        if (value == '\"') {
            buffer.append("\"\"\"\"");
        } else if (Character.isWhitespace(value) || value == this.delimiterChar) {
            buffer.append('\"').append(value).append('\"');
        } else {
            buffer.append(value);
        }
    }

    protected void appendField(Date value, StringBuffer buffer, String format) {
        this.appendDelimiter(buffer);
        String formattedDate = Parsing.formatDate(value, format);
        buffer.append(formattedDate);
    }

    protected void appendField(Calendar value, StringBuffer buffer, String format) {
        this.appendDelimiter(buffer);
        String formattedDate = FormatFunctions.formatDate(value, format);
        buffer.append(formattedDate);
    }

    protected void appendField(BigDecimal value, StringBuffer buffer) {
        this.appendDelimiter(buffer);
        buffer.append(Parsing.toString(value));
    }

    protected void appendField(BigInteger value, StringBuffer buffer) {
        this.appendDelimiter(buffer);
        buffer.append(Parsing.toString(value));
    }

    protected void appendField(byte[] value, StringBuffer buffer) {
        this.appendDelimiter(buffer);
        buffer.append(Parsing.toString(value));
    }

    public abstract Object writeData(DataObject var1, TransformContext var2) throws TransformException;

    public abstract Object writeHeader(DataObject var1, TransformContext var2) throws TransformException;

    public abstract Object writeTrailer(DataObject var1, TransformContext var2) throws TransformException;

    protected void requiredFieldMissing(DataObject obj, int index) throws TransformException {
        ASCIIDelimitedWriteException asc121 = ASCIIDelimitedResource.createASCIIDelimitedWriteExceptionFormatted("ASC121", obj.getQualifiedName(index));
        asc121.setField(obj, index, null);
        this.onError(asc121);
    }

    private void onError(TransformException e) throws TransformException {
        this.getExceptionHandler().onException(e);
    }
}

