/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.ascii;

import com.tplus.transform.lang.FastStringBuffer;
import com.tplus.transform.runtime.ascii.ASCIIDelimitedParseException;
import com.tplus.transform.runtime.ascii.ASCIIDelimitedResource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CSVRecord {
    List fields = new ArrayList();

    public void addField(String field) {
        this.fields.add(field);
    }

    public void addField(int index, String field) throws ASCIIDelimitedParseException {
        try {
            this.fields.add(index, field);
        }
        catch (ArrayIndexOutOfBoundsException aex) {
            ASCIIDelimitedParseException cpe = ASCIIDelimitedResource.createASCIIDelimitedParseExceptionFormatted("ASC105", field, index);
            cpe.setDetail(aex);
            throw cpe;
        }
    }

    public boolean contains(String field) {
        return this.fields.contains(field);
    }

    public String getField(int index) throws ASCIIDelimitedParseException {
        if (index < this.fields.size()) {
            return (String)this.fields.get(index);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CSVRecord) {
            List objRecord = ((CSVRecord)obj).fields;
            return this.fields.equals(objRecord);
        }
        return false;
    }

    public int indexOf(String field) {
        return this.fields.indexOf(field);
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public int lastIndexOf(String field) {
        return this.fields.lastIndexOf(field);
    }

    public String removeField(int index) throws ASCIIDelimitedParseException {
        try {
            return (String)this.fields.remove(index);
        }
        catch (ArrayIndexOutOfBoundsException aex) {
            ASCIIDelimitedParseException cpe = ASCIIDelimitedResource.createASCIIDelimitedParseExceptionFormatted("ASC107", index);
            cpe.setDetail(aex);
            throw cpe;
        }
    }

    public boolean removeField(String field) {
        return this.fields.remove(field);
    }

    public String setField(int index, String field) throws ASCIIDelimitedParseException {
        try {
            return this.fields.set(index, field);
        }
        catch (ArrayIndexOutOfBoundsException aex) {
            ASCIIDelimitedParseException cpe = ASCIIDelimitedResource.createASCIIDelimitedParseExceptionFormatted("ASC108", field, index);
            cpe.setDetail(aex);
            throw cpe;
        }
    }

    public String toString() {
        FastStringBuffer retStr = new FastStringBuffer("[");
        Iterator it = this.iterator();
        while (it.hasNext()) {
            retStr.append(it.next());
            retStr.append('|');
        }
        if (retStr.length() != 1) {
            retStr.setCharAt(retStr.length() - 1, ']');
        } else {
            retStr.append(']');
        }
        return retStr.toString();
    }

    public Iterator iterator() {
        return this.fields.iterator();
    }

    public int size() {
        return this.fields.size();
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public void clear() {
        this.fields.clear();
    }
}

