/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.ascii;

import com.tplus.transform.runtime.ascii.ASCIIDelimitedResource;
import com.tplus.transform.runtime.ascii.ASCIIDelimitedTokenizeException;
import com.tplus.transform.runtime.ascii.CSVRecord;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CSVTokenizer {
    static final char quoteStartChar = '\"';
    static final char quoteEndChar = '\"';
    private List tokens;
    private Iterator tokenIterator;
    private char fieldDelimiter = (char)44;

    public CSVTokenizer() {
    }

    public CSVTokenizer(char fieldDelimiter) throws IllegalArgumentException {
        this.fieldDelimiter = fieldDelimiter;
    }

    void parseString(String string) throws IllegalArgumentException, ASCIIDelimitedTokenizeException {
        this.parseString(string, this.fieldDelimiter);
    }

    void parseString(String string, char fieldDelimiter) throws IllegalArgumentException, ASCIIDelimitedTokenizeException {
        this.tokens = new ArrayList();
        if (string == null) {
            throw new IllegalArgumentException("The string argument is null");
        }
        new TokenBuilder().tokenize(string, fieldDelimiter, this.tokens);
        this.tokenIterator = null;
    }

    void parseString(String string, List tokens) throws IllegalArgumentException, ASCIIDelimitedTokenizeException {
        if (string == null) {
            throw new IllegalArgumentException("The string argument is null");
        }
        new TokenBuilder().tokenize(string, this.fieldDelimiter, tokens);
        this.tokenIterator = null;
    }

    private Iterator getTokenIterator() {
        if (this.tokenIterator == null) {
            this.tokenIterator = this.tokens.iterator();
        }
        return this.tokenIterator;
    }

    public CSVRecord parseRecord(String line) throws ASCIIDelimitedTokenizeException {
        CSVRecord record = new CSVRecord();
        this.parseRecord(line, record);
        return record;
    }

    public void parseRecord(String line, CSVRecord record) throws ASCIIDelimitedTokenizeException {
        record.clear();
        this.parseString(line, record.fields);
    }

    public boolean hasMoreTokens() {
        return this.getTokenIterator().hasNext();
    }

    public String nextToken() {
        return (String)this.getTokenIterator().next();
    }

    public static void cmtmain(String[] args) {
        CSVTokenizer tokenizer = new CSVTokenizer();
        try {
            String str = "Accrued income - base\tAsset description - long\tAsset description - short\tAsset sub category\tAsset super category\tBook cost value - base\tCUSIP\tShares/Par value\tSymbol\tUnrealized G/L - market\n33896\t5TH 3RD BANCORP COM\u00ef\u00bf\u00bd\t\"FIFTH THIRD BANCORP., COMMON STOCK,\u00ef\u00bf\u00bd\"\tCommon Stock\u00ef\u00bf\u00bd\tEquities\u00ef\u00bf\u00bd\t3982757.73\t316773100\u00ef\u00bf\u00bd\t89200\tFITB\u00ef\u00bf\u00bd\t-618133.73";
            String str2 = "\"\" \tAccrued_income_base \"Asset description - long\" A";
            tokenizer.parseString(str, '\t');
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                System.out.println("token = " + token);
            }
        }
        catch (ASCIIDelimitedTokenizeException e) {
            System.out.println(e.toXMLString(false, true));
        }
    }

    static class TokenBuilder {
        int curIndex = 0;
        String str;
        char fieldDelimiter;

        TokenBuilder() {
        }

        void tokenize(String str, char fieldDelimiter, List tokens) throws ASCIIDelimitedTokenizeException {
            this.str = str;
            this.fieldDelimiter = fieldDelimiter;
            this.curIndex = 0;
            int length = str.length();
            while (this.curIndex < length) {
                String token = this.extractField();
                tokens.add(token);
                if (!this.skipDelimiter()) break;
                if (this.curIndex != length) continue;
                tokens.add(null);
            }
        }

        private boolean skipDelimiter() throws ASCIIDelimitedTokenizeException {
            if (this.curIndex < this.str.length()) {
                if (this.str.charAt(this.curIndex) != this.fieldDelimiter) {
                    ASCIIDelimitedTokenizeException e = ASCIIDelimitedResource.createASCIIDelimitedTokenizeExceptionFormatted("ASC119");
                    e.setColumn(this.curIndex);
                    throw e;
                }
                ++this.curIndex;
                return true;
            }
            return false;
        }

        private String extractField() throws ASCIIDelimitedTokenizeException {
            if (this.curIndex < this.str.length() && this.str.charAt(this.curIndex) == '\"') {
                return this.extractQuotedToken();
            }
            return this.extractSimpleToken();
        }

        private String extractSimpleToken() {
            int delimiterIdx = this.str.indexOf(this.fieldDelimiter, this.curIndex);
            if (delimiterIdx == -1) {
                delimiterIdx = this.str.length();
            }
            String token = this.str.substring(this.curIndex, delimiterIdx);
            this.curIndex = delimiterIdx;
            if ((token = token.trim()).length() == 0) {
                return null;
            }
            return token;
        }

        private String extractQuotedToken() throws ASCIIDelimitedTokenizeException {
            int quoteIdx;
            ++this.curIndex;
            String token = "";
            while (true) {
                if ((quoteIdx = this.str.indexOf(34, this.curIndex)) == -1) {
                    ASCIIDelimitedTokenizeException e = ASCIIDelimitedResource.createASCIIDelimitedTokenizeExceptionFormatted("ASC117");
                    e.setColumn(this.curIndex);
                    throw e;
                }
                if (quoteIdx + 1 >= this.str.length() || this.str.charAt(quoteIdx + 1) != '\"') break;
                token = token + this.str.substring(this.curIndex, quoteIdx) + '\"';
                this.curIndex = quoteIdx + 2;
            }
            token = token + this.str.substring(this.curIndex, quoteIdx);
            this.curIndex = quoteIdx + 1;
            return token;
        }
    }
}

