/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.ascii;

import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.StringInputSource;
import com.tplus.transform.runtime.TransformException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.NoSuchElementException;

public class LineIterator {
    BufferedReader br;
    private String nextLine;

    public LineIterator(RawMessage is) throws TransformException, IOException {
        this(is, null);
    }

    public LineIterator(RawMessage is, String encoding) throws TransformException, IOException {
        if (encoding == null) {
            encoding = is.getEncoding();
        }
        Reader reader = is instanceof StringInputSource ? new StringReader(is.getAsString()) : new InputStreamReader(is.getAsStream(), encoding);
        this.br = new BufferedReader(reader);
        this.peekNextLine();
    }

    void close() throws IOException {
        this.br.close();
    }

    public boolean hasNext() {
        return this.nextLine != null;
    }

    public String next() {
        String temp = this.nextLine;
        if (temp == null) {
            throw new NoSuchElementException();
        }
        try {
            this.peekNextLine();
        }
        catch (IOException e) {
            throw new NoSuchElementException();
        }
        return temp;
    }

    private void peekNextLine() throws IOException {
        this.nextLine = this.br.readLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTrailerLine(RawMessage is, String encoding) throws IOException, TransformException {
        LineIterator it = new LineIterator(is, encoding);
        try {
            while (it.hasNext()) {
                String val = it.next();
                if (it.hasNext()) continue;
                String string = val;
                return string;
            }
        }
        finally {
            it.close();
        }
        return null;
    }
}

