/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.cache.jsrcache;

import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.cache.Map;
import com.tplus.transform.runtime.cache.jsrcache.MapJSRCacheImpl;
import com.tplus.transform.runtime.cache.jsrcache.VolanteCacheManager;
import java.net.URI;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.spi.CachingProvider;

public class CacheFunctions {
    public static Map getCache(String name) throws TransformException {
        return CacheFunctions.getCacheImpl(null, name, false);
    }

    public static Map getCache(String name, String uri) throws TransformException {
        return CacheFunctions.getCacheImpl(CacheFunctions.toURI(uri), name, false);
    }

    public static Map getOrCreateCache(String name) throws TransformException {
        return CacheFunctions.getCacheImpl(null, name, true);
    }

    public static Map getOrCreateCache(String name, String uri) throws TransformException {
        return CacheFunctions.getCacheImpl(CacheFunctions.toURI(uri), name, true);
    }

    private static URI toURI(String uri) {
        if (uri == null) {
            return null;
        }
        return URI.create(uri);
    }

    private static Map getCacheImpl(URI uri, String name, boolean create) throws TransformException {
        try {
            CachingProvider provider = Caching.getCachingProvider();
            if (provider != null) {
                CacheManager manager = provider.getCacheManager(uri, CacheFunctions.class.getClassLoader());
                Cache cache = manager.getCache(name);
                if (cache == null) {
                    if (create) {
                        cache = CacheFunctions.createCache(name, manager);
                    } else {
                        throw new TransformException("No cache by name " + name);
                    }
                }
                return new MapJSRCacheImpl(cache);
            }
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
        return VolanteCacheManager.getInstance().getCache(name);
    }

    private static Cache createCache(String name, CacheManager manager) {
        MutableConfiguration config = new MutableConfiguration();
        config.setStoreByValue(true).setTypes(Object.class, Object.class);
        Cache cache = manager.createCache(name, (Configuration)config);
        return cache;
    }
}

