/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.collection;

import com.tplus.transform.runtime.collection.BigDecimalList;
import java.math.BigDecimal;
import java.util.ConcurrentModificationException;

class BigDecimalSubList
extends BigDecimalList {
    BigDecimalList baseList;
    int startIndex;
    int size;
    BigDecimal[] data;
    int subModCount;

    BigDecimalSubList(BigDecimalList baseList, int startIndex, int endIndex) {
        if ((startIndex | endIndex) < 0 || startIndex > endIndex || endIndex > baseList.size() || startIndex > baseList.size()) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + baseList.size() + ", found 'fromIndex' " + startIndex + " and 'toIndex' " + endIndex);
        }
        this.baseList = baseList;
        this.startIndex = startIndex;
        this.size = endIndex - startIndex;
        this.subModCount = baseList._modCount;
        this.data = new BigDecimal[this.size];
        this.addElements();
    }

    void addElements() {
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = this.baseList.getValue(this.startIndex + i);
        }
    }

    public BigDecimal getValue(int index) {
        this.checkForComodification();
        return this.baseList.getValue(this.startIndex + index);
    }

    public Object get(int index) {
        this.checkForComodification();
        return this.baseList.getValue(this.startIndex + index);
    }

    public void add(int index, BigDecimal element) {
        this.checkForComodification();
        this.baseList.add(this.startIndex + index, element);
        ++this.size;
        this.subModCount = this.baseList._modCount;
        this.data = new BigDecimal[this.size];
        this.addElements();
    }

    public BigDecimalList subListImpl(int fromIndex, int toIndex) {
        return new BigDecimalSubList(this, fromIndex, toIndex);
    }

    public int size() {
        return this.size;
    }

    public BigDecimal[] getData() {
        return this.data;
    }

    public void clear() {
        this.checkForComodification();
        int s = this.size();
        for (int i = 0; i < s; ++i) {
            this.baseList.removeElementAt(this.startIndex);
            --this.baseList._modCount;
        }
        this.size = 0;
    }

    public BigDecimal removeElementAt(int index) {
        this.checkForComodification();
        int numtomove = this.size - index - 1;
        if (numtomove > 0) {
            System.arraycopy(this.data, index + 1, this.data, index, numtomove);
        }
        --this.size;
        ++this.subModCount;
        return this.baseList.removeElementAt(index + this.startIndex);
    }

    private void checkForComodification() {
        if (this.baseList._modCount != this.subModCount) {
            throw new ConcurrentModificationException();
        }
    }
}

