/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.collection;

import com.tplus.transform.runtime.collection.AbstractValueList;
import com.tplus.transform.runtime.collection.BooleanSubList;
import com.tplus.transform.runtime.collection.ValueList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class BooleanList
extends AbstractValueList
implements ValueList,
Serializable,
Comparable,
Cloneable {
    protected int _modCount = 0;
    private transient boolean[] _data = null;
    private int _size = 0;

    public BooleanList() {
        this(8);
    }

    public BooleanList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("capacity " + initialCapacity);
        }
        this._data = new boolean[initialCapacity];
        this._size = 0;
    }

    public BooleanList(boolean[] data) {
        this._data = data;
        this._size = data.length;
    }

    public BooleanList(BooleanList list) {
        this._size = list.size();
        this._data = new boolean[this._size];
        System.arraycopy(list.getData(), 0, this._data, 0, this._size);
    }

    public BooleanList add(boolean element) {
        this.add(this.size(), element);
        return this;
    }

    public void add(int index, boolean element) {
        this.checkRangeIncludingEndpoint(index);
        this.incrModCount();
        this.ensureCapacity(this._size + 1);
        int numtomove = this._size - index;
        System.arraycopy(this._data, index, this._data, index + 1, numtomove);
        this._data[index] = element;
        ++this._size;
    }

    public void add(int index, Object element) {
        this.add(index, this.fromObject(element));
    }

    public BooleanList addAll(BooleanList list) {
        for (int i = 0; i < list.size(); ++i) {
            this.add(list.getValue(i));
        }
        return this;
    }

    public boolean getValue(int index) {
        this.checkRange(index);
        return this._data[index];
    }

    public Object get(int index) {
        return this.toObject(this.getValue(index));
    }

    public Object toObject(boolean val) {
        return new Boolean(val);
    }

    public boolean fromObject(Object val) {
        return (Boolean)val;
    }

    public int size() {
        return this._size;
    }

    public void clear() {
        this.incrModCount();
        this._size = 0;
    }

    public Object remove(int index) {
        return this.toObject(this.removeElementAt(index));
    }

    public boolean removeElementAt(int index) {
        this.checkRange(index);
        this.incrModCount();
        boolean oldval = this._data[index];
        int numtomove = this._size - index - 1;
        if (numtomove > 0) {
            System.arraycopy(this._data, index + 1, this._data, index, numtomove);
        }
        --this._size;
        return oldval;
    }

    public Object set(int index, Object element) {
        return this.toObject(this.set(index, this.fromObject(element)));
    }

    public boolean set(int index, boolean element) {
        this.checkRange(index);
        this.incrModCount();
        boolean oldval = this._data[index];
        this._data[index] = element;
        return oldval;
    }

    public boolean contains(Object element) {
        return this.contains(this.fromObject(element));
    }

    public boolean contains(boolean element) {
        return this.indexOf(element) != -1;
    }

    public boolean intersects(BooleanList thatList) {
        int size = this.size();
        for (int j = 0; j < thatList.size(); ++j) {
            boolean element = thatList.getValue(j);
            for (int i = 0; i < size; ++i) {
                if (!BooleanList.equals(this.getValue(i), element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean equals(boolean first, boolean second) {
        return first == second;
    }

    public int indexOf(boolean element) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!BooleanList.equals(this.getValue(i), element)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(boolean element) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!BooleanList.equals(this.getValue(i), element)) continue;
            return i;
        }
        return -1;
    }

    public BooleanList sort() {
        BooleanList list = new BooleanList(this);
        return list;
    }

    public BooleanList unique() {
        BooleanList toRet = new BooleanList();
        toRet.addIfNoExists(this);
        return toRet;
    }

    public BooleanList union(BooleanList thatList) {
        BooleanList toRet = new BooleanList();
        toRet.addIfNoExists(this);
        toRet.addIfNoExists(thatList);
        return toRet;
    }

    public BooleanList intersection(BooleanList thatList) {
        BooleanList toRet = new BooleanList();
        toRet.addIfExistsBoth(this, thatList);
        toRet.addIfExistsBoth(thatList, this);
        return toRet;
    }

    public BooleanList subtract(BooleanList thatList) {
        BooleanList toRet = new BooleanList();
        BooleanList firstList = this;
        BooleanList secondList = thatList;
        int size = firstList.size();
        for (int j = 0; j < size; ++j) {
            boolean element = firstList.getValue(j);
            if (secondList.contains(element) || toRet.contains(element)) continue;
            toRet.add(element);
        }
        return toRet;
    }

    public boolean containsAll(BooleanList thatList) {
        int thatSize = thatList.size();
        for (int i = 0; i < thatSize; ++i) {
            if (this.contains(thatList.getValue(i))) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(BooleanList thatList) {
        int thatSize = thatList.size();
        for (int i = 0; i < thatSize; ++i) {
            if (!this.contains(thatList.getValue(i))) continue;
            return true;
        }
        return false;
    }

    public boolean equalsAll(BooleanList thatList) {
        return this.containsAll(thatList) && thatList.containsAll(this);
    }

    private void addIfExistsBoth(BooleanList firstList, BooleanList secondList) {
        int size = firstList.size();
        for (int j = 0; j < size; ++j) {
            boolean element = firstList.getValue(j);
            if (!secondList.contains(element) || this.contains(element)) continue;
            this.add(element);
        }
    }

    private void addIfNoExists(BooleanList thatList) {
        int size = thatList.size();
        for (int j = 0; j < size; ++j) {
            boolean element = thatList.getValue(j);
            if (this.contains(element)) continue;
            this.add(element);
        }
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof BooleanList) {
            BooleanList thatList = (BooleanList)that;
            if (this.size() != thatList.size()) {
                return false;
            }
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                if (BooleanList.equals(this.getValue(i), thatList.getValue(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int compareTo(Object that) {
        if (this == that) {
            return 0;
        }
        BooleanList thatList = (BooleanList)that;
        int size1 = this.size();
        int size2 = thatList.size();
        int size = Math.min(size1, size2);
        for (int i = 0; i < size; ++i) {
            boolean v2;
            boolean v1 = this.getValue(i);
            if (v1 == (v2 = thatList.getValue(i))) continue;
            return v1 ? -1 : 1;
        }
        return size1 - size2;
    }

    public int hashCode() {
        int hash = 1;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            hash = 31 * hash + (this.getValue(i) ? 1 : 2);
        }
        return hash;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int size = this.size();
        buf.append("[");
        for (int i = 0; i < size; ++i) {
            buf.append(this.getValue(i));
            if (i >= size - 1) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public void ensureCapacity(int mincap) {
        this.incrModCount();
        if (mincap > this._data.length) {
            int newcap = this._data.length * 3 / 2 + 1;
            boolean[] olddata = this._data;
            this._data = new boolean[newcap < mincap ? mincap : newcap];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        this.incrModCount();
        if (this._size < this._data.length) {
            boolean[] olddata = this._data;
            this._data = new boolean[this._size];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this._data.length);
        for (int i = 0; i < this._size; ++i) {
            out.writeBoolean(this._data[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._data = new boolean[in.readInt()];
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = in.readBoolean();
        }
    }

    private final void checkRange(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this.size() + ", found " + index);
        }
    }

    private final void checkRangeIncludingEndpoint(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this.size() + ", found " + index);
        }
    }

    protected int getModCount() {
        return this._modCount;
    }

    protected void incrModCount() {
        ++this._modCount;
    }

    public BooleanList subListImpl(int fromIndex, int toIndex) {
        return new BooleanSubList(this, fromIndex, toIndex);
    }

    public boolean[] getData() {
        return this._data;
    }
}

