/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.collection;

import com.tplus.transform.runtime.collection.AbstractValueList;
import com.tplus.transform.runtime.collection.DateSubList;
import com.tplus.transform.runtime.collection.ValueList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;

public class DateList
extends AbstractValueList
implements ValueList,
Serializable,
Comparable,
Cloneable {
    protected int _modCount = 0;
    private transient Date[] _data = null;
    private int _size = 0;

    public DateList() {
        this(8);
    }

    public DateList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("capacity " + initialCapacity);
        }
        this._data = new Date[initialCapacity];
        this._size = 0;
    }

    public DateList(Date[] data) {
        this._data = data;
        this._size = data.length;
    }

    public DateList(DateList list) {
        this._size = list.size();
        this._data = new Date[this._size];
        System.arraycopy(list.getData(), 0, this._data, 0, this._size);
    }

    public DateList add(Date element) {
        this.add(this.size(), element);
        return this;
    }

    public void add(int index, Date element) {
        this.checkRangeIncludingEndpoint(index);
        this.incrModCount();
        this.ensureCapacity(this._size + 1);
        int numtomove = this._size - index;
        System.arraycopy(this._data, index, this._data, index + 1, numtomove);
        this._data[index] = element;
        ++this._size;
    }

    public void add(int index, Object element) {
        this.add(index, this.fromObject(element));
    }

    public DateList addAll(DateList list) {
        for (int i = 0; i < list.size(); ++i) {
            this.add(list.getValue(i));
        }
        return this;
    }

    public Date getValue(int index) {
        this.checkRange(index);
        return this._data[index];
    }

    public Object get(int index) {
        return this.getValue(index);
    }

    public Object toObject(Date val) {
        return val;
    }

    public Date fromObject(Object val) {
        return (Date)val;
    }

    public int size() {
        return this._size;
    }

    public void clear() {
        this.incrModCount();
        this._size = 0;
    }

    public Object remove(int index) {
        return this.toObject(this.removeElementAt(index));
    }

    public Date removeElementAt(int index) {
        this.checkRange(index);
        this.incrModCount();
        Date oldval = this._data[index];
        int numtomove = this._size - index - 1;
        if (numtomove > 0) {
            System.arraycopy(this._data, index + 1, this._data, index, numtomove);
        }
        --this._size;
        return oldval;
    }

    public Object set(int index, Object element) {
        return this.toObject(this.set(index, this.fromObject(element)));
    }

    public Date set(int index, Date element) {
        this.checkRange(index);
        this.incrModCount();
        Date oldval = this._data[index];
        this._data[index] = element;
        return oldval;
    }

    public boolean contains(Object element) {
        return this.indexOf((Date)element) != -1;
    }

    public boolean contains(Date element) {
        return this.indexOf(element) != -1;
    }

    public boolean intersects(DateList thatList) {
        int size = this.size();
        for (int j = 0; j < thatList.size(); ++j) {
            Date element = thatList.getValue(j);
            for (int i = 0; i < size; ++i) {
                if (!DateList.equals(this.getValue(i), element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean equals(Date first, Date second) {
        return first.equals(second);
    }

    public int indexOf(Date element) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!DateList.equals(this.getValue(i), element)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Date element) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!DateList.equals(this.getValue(i), element)) continue;
            return i;
        }
        return -1;
    }

    public DateList sort() {
        DateList list = new DateList(this);
        Arrays.sort(list.getData(), 0, list.size());
        return list;
    }

    public DateList unique() {
        DateList toRet = new DateList();
        toRet.addIfNoExists(this);
        return toRet;
    }

    public DateList union(DateList thatList) {
        DateList toRet = new DateList();
        toRet.addIfNoExists(this);
        toRet.addIfNoExists(thatList);
        return toRet;
    }

    public DateList intersection(DateList thatList) {
        DateList toRet = new DateList();
        toRet.addIfExistsBoth(this, thatList);
        toRet.addIfExistsBoth(thatList, this);
        return toRet;
    }

    public DateList subtract(DateList thatList) {
        DateList toRet = new DateList();
        DateList firstList = this;
        DateList secondList = thatList;
        int size = firstList.size();
        for (int j = 0; j < size; ++j) {
            Date element = firstList.getValue(j);
            if (secondList.contains(element) || toRet.contains(element)) continue;
            toRet.add(element);
        }
        return toRet;
    }

    public boolean containsAll(DateList thatList) {
        int thatSize = thatList.size();
        for (int i = 0; i < thatSize; ++i) {
            if (this.contains(thatList.getValue(i))) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(DateList thatList) {
        int thatSize = thatList.size();
        for (int i = 0; i < thatSize; ++i) {
            if (!this.contains(thatList.getValue(i))) continue;
            return true;
        }
        return false;
    }

    public boolean equalsAll(DateList thatList) {
        return this.containsAll(thatList) && thatList.containsAll(this);
    }

    private void addIfExistsBoth(DateList firstList, DateList secondList) {
        int size = firstList.size();
        for (int j = 0; j < size; ++j) {
            Date element = firstList.getValue(j);
            if (!secondList.contains(element) || this.contains(element)) continue;
            this.add(element);
        }
    }

    private void addIfNoExists(DateList thatList) {
        int size = thatList.size();
        for (int j = 0; j < size; ++j) {
            Date element = thatList.getValue(j);
            if (this.contains(element)) continue;
            this.add(element);
        }
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof DateList) {
            DateList thatList = (DateList)that;
            if (this.size() != thatList.size()) {
                return false;
            }
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                if (DateList.equals(this.getValue(i), thatList.getValue(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int compareTo(Object that) {
        if (this == that) {
            return 0;
        }
        DateList thatList = (DateList)that;
        int size1 = this.size();
        int size2 = thatList.size();
        int size = Math.min(size1, size2);
        for (int i = 0; i < size; ++i) {
            Date v2;
            Date v1 = this.getValue(i);
            int toRet = v1.compareTo(v2 = thatList.getValue(i));
            if (toRet == 0) continue;
            return toRet;
        }
        return size1 - size2;
    }

    public int hashCode() {
        int hash = 1;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            hash = 31 * hash + this.getValue(i).hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int size = this.size();
        buf.append("[");
        for (int i = 0; i < size; ++i) {
            buf.append(this.getValue(i));
            if (i >= size - 1) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public void ensureCapacity(int mincap) {
        this.incrModCount();
        if (mincap > this._data.length) {
            int newcap = this._data.length * 3 / 2 + 1;
            Date[] olddata = this._data;
            this._data = new Date[newcap < mincap ? mincap : newcap];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        this.incrModCount();
        if (this._size < this._data.length) {
            Date[] olddata = this._data;
            this._data = new Date[this._size];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this._data.length);
        for (int i = 0; i < this._size; ++i) {
            out.writeObject(this._data[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._data = new Date[in.readInt()];
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = (Date)in.readObject();
        }
    }

    private final void checkRange(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this.size() + ", found " + index);
        }
    }

    private final void checkRangeIncludingEndpoint(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this.size() + ", found " + index);
        }
    }

    protected int getModCount() {
        return this._modCount;
    }

    protected void incrModCount() {
        ++this._modCount;
    }

    public DateList subListImpl(int fromIndex, int toIndex) {
        return new DateSubList(this, fromIndex, toIndex);
    }

    public Date[] getData() {
        return this._data;
    }
}

