/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.collection;

import com.tplus.transform.runtime.collection.AbstractValueList;
import com.tplus.transform.runtime.collection.IntSubList;
import com.tplus.transform.runtime.collection.ValueList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class IntList
extends AbstractValueList
implements ValueList,
Serializable,
Comparable,
Cloneable {
    protected int _modCount = 0;
    private transient int[] _data = null;
    private int _size = 0;

    public IntList() {
        this(8);
    }

    public IntList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("capacity " + initialCapacity);
        }
        this._data = new int[initialCapacity];
        this._size = 0;
    }

    public IntList(int[] data) {
        this._data = data;
        this._size = data.length;
    }

    public IntList(IntList list) {
        this._size = list.size();
        this._data = new int[this._size];
        System.arraycopy(list.getData(), 0, this._data, 0, this._size);
    }

    public int binarySearch(int key) {
        int[] _data = this.getData();
        int low = 0;
        int high = this.size() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            int midVal = _data[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public IntList add(int element) {
        this.add(this.size(), element);
        return this;
    }

    public void add(int index, int element) {
        this.checkRangeIncludingEndpoint(index);
        this.incrModCount();
        this.ensureCapacity(this._size + 1);
        int numtomove = this._size - index;
        System.arraycopy(this._data, index, this._data, index + 1, numtomove);
        this._data[index] = element;
        ++this._size;
    }

    public void add(int index, Object element) {
        this.add(index, this.fromObject(element));
    }

    public IntList addAll(IntList list) {
        for (int i = 0; i < list.size(); ++i) {
            this.add(list.getValue(i));
        }
        return this;
    }

    public int getValue(int index) {
        this.checkRange(index);
        return this._data[index];
    }

    public Object get(int index) {
        return this.toObject(this.getValue(index));
    }

    public Object toObject(int val) {
        return new Integer(val);
    }

    public int fromObject(Object val) {
        return (Integer)val;
    }

    public int size() {
        return this._size;
    }

    public void clear() {
        this.incrModCount();
        this._size = 0;
    }

    public Object remove(int index) {
        return this.toObject(this.removeElementAt(index));
    }

    public int removeElementAt(int index) {
        this.checkRange(index);
        this.incrModCount();
        int oldval = this._data[index];
        int numtomove = this._size - index - 1;
        if (numtomove > 0) {
            System.arraycopy(this._data, index + 1, this._data, index, numtomove);
        }
        --this._size;
        return oldval;
    }

    public Object set(int index, Object element) {
        return this.toObject(this.set(index, this.fromObject(element)));
    }

    public int set(int index, int element) {
        this.checkRange(index);
        this.incrModCount();
        int oldval = this._data[index];
        this._data[index] = element;
        return oldval;
    }

    public boolean contains(Object element) {
        return this.contains(this.fromObject(element));
    }

    public boolean contains(int element) {
        return this.indexOf(element) != -1;
    }

    public int countOf(int element) {
        int count = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!IntList.equals(this.getValue(i), element)) continue;
            ++count;
        }
        return count;
    }

    public boolean intersects(IntList thatList) {
        int size = this.size();
        for (int j = 0; j < thatList.size(); ++j) {
            int element = thatList.getValue(j);
            for (int i = 0; i < size; ++i) {
                if (!IntList.equals(this.getValue(i), element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean equals(int first, int second) {
        return first == second;
    }

    public int indexOf(int element) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!IntList.equals(this.getValue(i), element)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int element) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!IntList.equals(this.getValue(i), element)) continue;
            return i;
        }
        return -1;
    }

    public IntList sort() {
        IntList list = new IntList(this);
        Arrays.sort(list.getData(), 0, list.size());
        return list;
    }

    public IntList unique() {
        IntList toRet = new IntList();
        toRet.addIfNoExists(this);
        return toRet;
    }

    public IntList union(IntList thatList) {
        IntList toRet = new IntList();
        toRet.addIfNoExists(this);
        toRet.addIfNoExists(thatList);
        return toRet;
    }

    public IntList intersection(IntList thatList) {
        IntList toRet = new IntList();
        toRet.addIfExistsBoth(this, thatList);
        toRet.addIfExistsBoth(thatList, this);
        return toRet;
    }

    public IntList subtract(IntList thatList) {
        IntList toRet = new IntList();
        IntList firstList = this;
        IntList secondList = thatList;
        int size = firstList.size();
        for (int j = 0; j < size; ++j) {
            int element = firstList.getValue(j);
            if (secondList.contains(element) || toRet.contains(element)) continue;
            toRet.add(element);
        }
        return toRet;
    }

    public boolean containsAll(IntList thatList) {
        int thatSize = thatList.size();
        for (int i = 0; i < thatSize; ++i) {
            if (this.contains(thatList.getValue(i))) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(IntList thatList) {
        int thatSize = thatList.size();
        for (int i = 0; i < thatSize; ++i) {
            if (!this.contains(thatList.getValue(i))) continue;
            return true;
        }
        return false;
    }

    public boolean equalsAll(IntList thatList) {
        return this.containsAll(thatList) && thatList.containsAll(this);
    }

    private void addIfExistsBoth(IntList firstList, IntList secondList) {
        int size = firstList.size();
        for (int j = 0; j < size; ++j) {
            int element = firstList.getValue(j);
            if (!secondList.contains(element) || this.contains(element)) continue;
            this.add(element);
        }
    }

    private void addIfNoExists(IntList thatList) {
        int size = thatList.size();
        for (int j = 0; j < size; ++j) {
            int element = thatList.getValue(j);
            if (this.contains(element)) continue;
            this.add(element);
        }
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof IntList) {
            IntList thatList = (IntList)that;
            if (this.size() != thatList.size()) {
                return false;
            }
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                if (IntList.equals(this.getValue(i), thatList.getValue(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int compareTo(Object that) {
        if (this == that) {
            return 0;
        }
        IntList thatList = (IntList)that;
        int size1 = this.size();
        int size2 = thatList.size();
        int size = Math.min(size1, size2);
        for (int i = 0; i < size; ++i) {
            int v2;
            int v1 = this.getValue(i);
            if (v1 < (v2 = thatList.getValue(i))) {
                return -1;
            }
            if (v1 <= v2) continue;
            return 1;
        }
        return size1 - size2;
    }

    public int hashCode() {
        int hash = 1;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            hash = 31 * hash + this.getValue(i);
        }
        return hash;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int size = this.size();
        buf.append("[");
        for (int i = 0; i < size; ++i) {
            buf.append(this.getValue(i));
            if (i >= size - 1) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public void ensureCapacity(int mincap) {
        this.incrModCount();
        if (mincap > this._data.length) {
            int newcap = this._data.length * 3 / 2 + 1;
            int[] olddata = this._data;
            this._data = new int[newcap < mincap ? mincap : newcap];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        this.incrModCount();
        if (this._size < this._data.length) {
            int[] olddata = this._data;
            this._data = new int[this._size];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this._data.length);
        for (int i = 0; i < this._size; ++i) {
            out.writeInt(this._data[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._data = new int[in.readInt()];
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = in.readInt();
        }
    }

    private final void checkRange(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this.size() + ", found " + index);
        }
    }

    private final void checkRangeIncludingEndpoint(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this.size() + ", found " + index);
        }
    }

    protected int getModCount() {
        return this._modCount;
    }

    protected void incrModCount() {
        ++this._modCount;
    }

    public IntList subListImpl(int fromIndex, int toIndex) {
        return new IntSubList(this, fromIndex, toIndex);
    }

    public int[] getData() {
        return this._data;
    }
}

