/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.collection;

import com.tplus.transform.runtime.collection.AbstractValueList;
import com.tplus.transform.runtime.collection.LongSubList;
import com.tplus.transform.runtime.collection.ValueList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class LongList
extends AbstractValueList
implements ValueList,
Serializable,
Comparable,
Cloneable {
    protected int _modCount = 0;
    private transient long[] _data = null;
    private int _size = 0;

    public LongList() {
        this(8);
    }

    public LongList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("capacity " + initialCapacity);
        }
        this._data = new long[initialCapacity];
        this._size = 0;
    }

    public LongList(long[] data) {
        this._data = data;
        this._size = data.length;
    }

    public LongList(LongList list) {
        this._size = list.size();
        this._data = new long[this._size];
        System.arraycopy(list.getData(), 0, this._data, 0, this._size);
    }

    public LongList add(long element) {
        this.add(this.size(), element);
        return this;
    }

    public void add(int index, long element) {
        this.checkRangeIncludingEndpoint(index);
        this.incrModCount();
        this.ensureCapacity(this._size + 1);
        int numtomove = this._size - index;
        System.arraycopy(this._data, index, this._data, index + 1, numtomove);
        this._data[index] = element;
        ++this._size;
    }

    public void add(int index, Object element) {
        this.add(index, this.fromObject(element));
    }

    public LongList addAll(LongList list) {
        for (int i = 0; i < list.size(); ++i) {
            this.add(list.getValue(i));
        }
        return this;
    }

    public long getValue(int index) {
        this.checkRange(index);
        return this._data[index];
    }

    public Object get(int index) {
        return this.toObject(this.getValue(index));
    }

    public Object toObject(long val) {
        return new Long(val);
    }

    public long fromObject(Object val) {
        return (Long)val;
    }

    public int size() {
        return this._size;
    }

    public void clear() {
        this.incrModCount();
        this._size = 0;
    }

    public Object remove(int index) {
        return this.toObject(this.removeElementAt(index));
    }

    public long removeElementAt(int index) {
        this.checkRange(index);
        this.incrModCount();
        long oldval = this._data[index];
        int numtomove = this._size - index - 1;
        if (numtomove > 0) {
            System.arraycopy(this._data, index + 1, this._data, index, numtomove);
        }
        --this._size;
        return oldval;
    }

    public Object set(int index, Object element) {
        return this.toObject(this.set(index, this.fromObject(element)));
    }

    public long set(int index, long element) {
        this.checkRange(index);
        this.incrModCount();
        long oldval = this._data[index];
        this._data[index] = element;
        return oldval;
    }

    public boolean contains(Object element) {
        return this.contains(this.fromObject(element));
    }

    public boolean contains(long element) {
        return this.indexOf(element) != -1;
    }

    public boolean intersects(LongList thatList) {
        int size = this.size();
        for (int j = 0; j < thatList.size(); ++j) {
            long element = thatList.getValue(j);
            for (int i = 0; i < size; ++i) {
                if (!LongList.equals(this.getValue(i), element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean equals(long first, long second) {
        return first == second;
    }

    public int indexOf(long element) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!LongList.equals(this.getValue(i), element)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(long element) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!LongList.equals(this.getValue(i), element)) continue;
            return i;
        }
        return -1;
    }

    public LongList sort() {
        LongList list = new LongList(this);
        Arrays.sort(list.getData(), 0, list.size());
        return list;
    }

    public LongList unique() {
        LongList toRet = new LongList();
        toRet.addIfNoExists(this);
        return toRet;
    }

    public LongList union(LongList thatList) {
        LongList toRet = new LongList();
        toRet.addIfNoExists(this);
        toRet.addIfNoExists(thatList);
        return toRet;
    }

    public LongList intersection(LongList thatList) {
        LongList toRet = new LongList();
        toRet.addIfExistsBoth(this, thatList);
        toRet.addIfExistsBoth(thatList, this);
        return toRet;
    }

    public LongList subtract(LongList thatList) {
        LongList toRet = new LongList();
        LongList firstList = this;
        LongList secondList = thatList;
        int size = firstList.size();
        for (int j = 0; j < size; ++j) {
            long element = firstList.getValue(j);
            if (secondList.contains(element) || toRet.contains(element)) continue;
            toRet.add(element);
        }
        return toRet;
    }

    public boolean containsAll(LongList thatList) {
        int thatSize = thatList.size();
        for (int i = 0; i < thatSize; ++i) {
            if (this.contains(thatList.getValue(i))) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(LongList thatList) {
        int thatSize = thatList.size();
        for (int i = 0; i < thatSize; ++i) {
            if (!this.contains(thatList.getValue(i))) continue;
            return true;
        }
        return false;
    }

    public boolean equalsAll(LongList thatList) {
        return this.containsAll(thatList) && thatList.containsAll(this);
    }

    private void addIfExistsBoth(LongList firstList, LongList secondList) {
        int size = firstList.size();
        for (int j = 0; j < size; ++j) {
            long element = firstList.getValue(j);
            if (!secondList.contains(element) || this.contains(element)) continue;
            this.add(element);
        }
    }

    private void addIfNoExists(LongList thatList) {
        int size = thatList.size();
        for (int j = 0; j < size; ++j) {
            long element = thatList.getValue(j);
            if (this.contains(element)) continue;
            this.add(element);
        }
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof LongList) {
            LongList thatList = (LongList)that;
            if (this.size() != thatList.size()) {
                return false;
            }
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                if (LongList.equals(this.getValue(i), thatList.getValue(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int compareTo(Object that) {
        if (this == that) {
            return 0;
        }
        LongList thatList = (LongList)that;
        int size1 = this.size();
        int size2 = thatList.size();
        int size = Math.min(size1, size2);
        for (int i = 0; i < size; ++i) {
            long v2;
            long v1 = this.getValue(i);
            if (v1 < (v2 = thatList.getValue(i))) {
                return -1;
            }
            if (v1 <= v2) continue;
            return 1;
        }
        return size1 - size2;
    }

    public int hashCode() {
        int hash = 1;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            hash = 31 * hash + (int)this.getValue(i);
        }
        return hash;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int size = this.size();
        buf.append("[");
        for (int i = 0; i < size; ++i) {
            buf.append(this.getValue(i));
            if (i >= size - 1) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public void ensureCapacity(int mincap) {
        this.incrModCount();
        if (mincap > this._data.length) {
            int newcap = this._data.length * 3 / 2 + 1;
            long[] olddata = this._data;
            this._data = new long[newcap < mincap ? mincap : newcap];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        this.incrModCount();
        if (this._size < this._data.length) {
            long[] olddata = this._data;
            this._data = new long[this._size];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this._data.length);
        for (int i = 0; i < this._size; ++i) {
            out.writeLong(this._data[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._data = new long[in.readInt()];
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = in.readLong();
        }
    }

    private final void checkRange(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this.size() + ", found " + index);
        }
    }

    private final void checkRangeIncludingEndpoint(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this.size() + ", found " + index);
        }
    }

    protected int getModCount() {
        return this._modCount;
    }

    protected void incrModCount() {
        ++this._modCount;
    }

    public LongList subListImpl(int fromIndex, int toIndex) {
        return new LongSubList(this, fromIndex, toIndex);
    }

    public long[] getData() {
        return this._data;
    }
}

