/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.collection;

import com.tplus.transform.runtime.collection.LongList;
import java.util.ConcurrentModificationException;

class LongSubList
extends LongList {
    LongList baseList;
    int startIndex;
    int size;
    long[] data;
    int subModCount;

    LongSubList(LongList baseList, int startIndex, int endIndex) {
        if ((startIndex | endIndex) < 0 || startIndex > endIndex || endIndex > baseList.size() || startIndex > baseList.size()) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + baseList.size() + ", found 'fromIndex' " + startIndex + " and 'toIndex' " + endIndex);
        }
        this.baseList = baseList;
        this.startIndex = startIndex;
        this.size = endIndex - startIndex;
        this.subModCount = baseList._modCount;
        this.data = new long[this.size];
        this.addElements();
    }

    void addElements() {
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = this.baseList.getValue(this.startIndex + i);
        }
    }

    public long getValue(int index) {
        this.checkForComodification();
        return this.baseList.getValue(this.startIndex + index);
    }

    public Object get(int index) {
        this.checkForComodification();
        return this.toObject(this.baseList.getValue(this.startIndex + index));
    }

    public void add(int index, long element) {
        this.checkForComodification();
        this.baseList.add(this.startIndex + index, element);
        ++this.size;
        this.subModCount = this.baseList._modCount;
        this.data = new long[this.size];
        this.addElements();
    }

    public LongList subListImpl(int fromIndex, int toIndex) {
        return new LongSubList(this, fromIndex, toIndex);
    }

    public int size() {
        return this.size;
    }

    public long[] getData() {
        return this.data;
    }

    public void clear() {
        this.checkForComodification();
        int s = this.size();
        for (int i = 0; i < s; ++i) {
            this.baseList.removeElementAt(this.startIndex);
            --this.baseList._modCount;
        }
        this.size = 0;
    }

    public long removeElementAt(int index) {
        this.checkForComodification();
        int numtomove = this.size - index - 1;
        if (numtomove > 0) {
            System.arraycopy(this.data, index + 1, this.data, index, numtomove);
        }
        --this.size;
        ++this.subModCount;
        return this.baseList.removeElementAt(index + this.startIndex);
    }

    private void checkForComodification() {
        if (this.baseList._modCount != this.subModCount) {
            throw new ConcurrentModificationException();
        }
    }
}

