/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.collection;

import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.collection.AbstractValueList;
import com.tplus.transform.runtime.collection.RawMessageSubList;
import com.tplus.transform.runtime.collection.ValueList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class RawMessageList
extends AbstractValueList
implements ValueList,
Serializable,
Comparable,
Cloneable {
    protected int _modCount = 0;
    private transient RawMessage[] _data = null;
    private int _size = 0;

    public RawMessageList() {
        this(8);
    }

    public RawMessageList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("capacity " + initialCapacity);
        }
        this._data = new RawMessage[initialCapacity];
        this._size = 0;
    }

    public RawMessageList(RawMessage[] data) {
        this._data = data;
        this._size = data.length;
    }

    public RawMessageList(RawMessageList list) {
        this._size = list.size();
        this._data = new RawMessage[this._size];
        System.arraycopy(list.getData(), 0, this._data, 0, this._size);
    }

    public RawMessageList add(RawMessage element) {
        this.add(this.size(), element);
        return this;
    }

    public void add(int index, RawMessage element) {
        this.checkRangeIncludingEndpoint(index);
        this.incrModCount();
        this.ensureCapacity(this._size + 1);
        int numtomove = this._size - index;
        System.arraycopy(this._data, index, this._data, index + 1, numtomove);
        this._data[index] = element;
        ++this._size;
    }

    public void add(int index, Object element) {
        this.add(index, this.fromObject(element));
    }

    public RawMessageList addAll(RawMessageList list) {
        for (int i = 0; i < list.size(); ++i) {
            this.add(list.getValue(i));
        }
        return this;
    }

    public RawMessage getValue(int index) {
        this.checkRange(index);
        return this._data[index];
    }

    public Object get(int index) {
        return this.getValue(index);
    }

    public Object toObject(RawMessage val) {
        return val;
    }

    public RawMessage fromObject(Object val) {
        return (RawMessage)val;
    }

    public int size() {
        return this._size;
    }

    public void clear() {
        this.incrModCount();
        int size = this._size;
        this._size = 0;
        for (int i = 0; i < size; ++i) {
            this._data[i] = null;
        }
    }

    public Object remove(int index) {
        return this.toObject(this.removeElementAt(index));
    }

    public RawMessage removeElementAt(int index) {
        this.checkRange(index);
        this.incrModCount();
        RawMessage oldval = this._data[index];
        int numtomove = this._size - index - 1;
        if (numtomove > 0) {
            System.arraycopy(this._data, index + 1, this._data, index, numtomove);
        }
        --this._size;
        return oldval;
    }

    public Object set(int index, Object element) {
        return this.toObject(this.set(index, this.fromObject(element)));
    }

    public RawMessage set(int index, RawMessage element) {
        this.checkRange(index);
        this.incrModCount();
        RawMessage oldval = this._data[index];
        this._data[index] = element;
        return oldval;
    }

    public boolean contains(Object element) {
        return this.indexOf((RawMessage)element) != -1;
    }

    public boolean contains(RawMessage element) {
        return this.indexOf(element) != -1;
    }

    public boolean intersects(RawMessageList thatList) {
        int size = this.size();
        for (int j = 0; j < thatList.size(); ++j) {
            RawMessage element = thatList.getValue(j);
            for (int i = 0; i < size; ++i) {
                if (!RawMessageList.equals(this.getValue(i), element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean equals(RawMessage first, RawMessage second) {
        return first.equals(second);
    }

    public int indexOf(RawMessage element) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!RawMessageList.equals(this.getValue(i), element)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(RawMessage element) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!RawMessageList.equals(this.getValue(i), element)) continue;
            return i;
        }
        return -1;
    }

    public RawMessageList sort() {
        RawMessageList list = new RawMessageList(this);
        Arrays.sort(list.getData(), 0, list.size());
        return list;
    }

    public RawMessageList unique() {
        RawMessageList toRet = new RawMessageList();
        toRet.addIfNoExists(this);
        return toRet;
    }

    public RawMessageList union(RawMessageList thatList) {
        RawMessageList toRet = new RawMessageList();
        toRet.addIfNoExists(this);
        toRet.addIfNoExists(thatList);
        return toRet;
    }

    public RawMessageList intersection(RawMessageList thatList) {
        RawMessageList toRet = new RawMessageList();
        toRet.addIfExistsBoth(this, thatList);
        toRet.addIfExistsBoth(thatList, this);
        return toRet;
    }

    public RawMessageList subtract(RawMessageList thatList) {
        RawMessageList toRet = new RawMessageList();
        RawMessageList firstList = this;
        RawMessageList secondList = thatList;
        int size = firstList.size();
        for (int j = 0; j < size; ++j) {
            RawMessage element = firstList.getValue(j);
            if (secondList.contains(element) || toRet.contains(element)) continue;
            toRet.add(element);
        }
        return toRet;
    }

    public boolean containsAll(RawMessageList thatList) {
        int thatSize = thatList.size();
        for (int i = 0; i < thatSize; ++i) {
            if (this.contains(thatList.getValue(i))) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(RawMessageList thatList) {
        int thatSize = thatList.size();
        for (int i = 0; i < thatSize; ++i) {
            if (!this.contains(thatList.getValue(i))) continue;
            return true;
        }
        return false;
    }

    public boolean equalsAll(RawMessageList thatList) {
        return this.containsAll(thatList) && thatList.containsAll(this);
    }

    private void addIfExistsBoth(RawMessageList firstList, RawMessageList secondList) {
        int size = firstList.size();
        for (int j = 0; j < size; ++j) {
            RawMessage element = firstList.getValue(j);
            if (!secondList.contains(element) || this.contains(element)) continue;
            this.add(element);
        }
    }

    private void addIfNoExists(RawMessageList thatList) {
        int size = thatList.size();
        for (int j = 0; j < size; ++j) {
            RawMessage element = thatList.getValue(j);
            if (this.contains(element)) continue;
            this.add(element);
        }
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof RawMessageList) {
            RawMessageList thatList = (RawMessageList)that;
            if (this.size() != thatList.size()) {
                return false;
            }
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                if (RawMessageList.equals(this.getValue(i), thatList.getValue(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int compareTo(Object that) {
        if (this == that) {
            return 0;
        }
        RawMessageList thatList = (RawMessageList)that;
        int size1 = this.size();
        int size2 = thatList.size();
        int size = Math.min(size1, size2);
        for (int i = 0; i < size; ++i) {
            RawMessage v1 = this.getValue(i);
            RawMessage v2 = thatList.getValue(i);
            int toRet = 0;
            if (toRet == 0) continue;
            return toRet;
        }
        return size1 - size2;
    }

    public int hashCode() {
        int hash = 1;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            hash = 31 * hash + this.getValue(i).hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int size = this.size();
        buf.append("[");
        for (int i = 0; i < size; ++i) {
            buf.append(this.getValue(i));
            if (i >= size - 1) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public void ensureCapacity(int mincap) {
        this.incrModCount();
        if (mincap > this._data.length) {
            int newcap = this._data.length * 3 / 2 + 1;
            RawMessage[] olddata = this._data;
            this._data = new RawMessage[newcap < mincap ? mincap : newcap];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        this.incrModCount();
        if (this._size < this._data.length) {
            RawMessage[] olddata = this._data;
            this._data = new RawMessage[this._size];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this._data.length);
        for (int i = 0; i < this._size; ++i) {
            out.writeObject(this._data[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._data = new RawMessage[in.readInt()];
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = (RawMessage)in.readObject();
        }
    }

    private final void checkRange(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this.size() + ", found " + index);
        }
    }

    private final void checkRangeIncludingEndpoint(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this.size() + ", found " + index);
        }
    }

    public RawMessageList subListImpl(int fromIndex, int toIndex) {
        return new RawMessageSubList(this, fromIndex, toIndex);
    }

    public RawMessage[] getData() {
        return this._data;
    }

    protected int getModCount() {
        return this._modCount;
    }

    protected void incrModCount() {
        ++this._modCount;
    }
}

