/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.collection;

import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.collection.RawMessageList;
import java.util.ConcurrentModificationException;

class RawMessageSubList
extends RawMessageList {
    RawMessageList baseList;
    int startIndex;
    int size;
    transient RawMessage[] data;
    int subModCount;

    RawMessageSubList(RawMessageList baseList, int startIndex, int endIndex) {
        if ((startIndex | endIndex) < 0 || startIndex > endIndex || endIndex > baseList.size() || startIndex > baseList.size()) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + baseList.size() + ", found 'fromIndex' " + startIndex + " and 'toIndex' " + endIndex);
        }
        this.baseList = baseList;
        this.startIndex = startIndex;
        this.size = endIndex - startIndex;
        this.subModCount = baseList._modCount;
        this.data = new RawMessage[this.size];
        this.addElements();
    }

    void addElements() {
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = this.baseList.getValue(this.startIndex + i);
        }
    }

    public RawMessage getValue(int index) {
        this.checkForComodification();
        return this.baseList.getValue(this.startIndex + index);
    }

    public Object get(int index) {
        this.checkForComodification();
        return this.baseList.getValue(this.startIndex + index);
    }

    public void add(int index, RawMessage element) {
        this.checkForComodification();
        this.baseList.add(this.startIndex + index, element);
        ++this.size;
        this.subModCount = this.baseList._modCount;
        this.data = new RawMessage[this.size];
        this.addElements();
    }

    public RawMessageList subListImpl(int fromIndex, int toIndex) {
        return new RawMessageSubList(this, fromIndex, toIndex);
    }

    public int size() {
        return this.size;
    }

    public RawMessage[] getData() {
        return this.data;
    }

    public void clear() {
        this.checkForComodification();
        int s = this.size();
        for (int i = 0; i < s; ++i) {
            this.baseList.removeElementAt(this.startIndex);
            --this.baseList._modCount;
        }
        this.size = 0;
    }

    public RawMessage removeElementAt(int index) {
        this.checkForComodification();
        int numtomove = this.size - index - 1;
        if (numtomove > 0) {
            System.arraycopy(this.data, index + 1, this.data, index, numtomove);
        }
        --this.size;
        ++this.subModCount;
        return this.baseList.removeElementAt(index + this.startIndex);
    }

    private void checkForComodification() {
        if (this.baseList._modCount != this.subModCount) {
            throw new ConcurrentModificationException();
        }
    }
}

