/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.collection;

import com.tplus.transform.lang.ScaledDecimal;
import com.tplus.transform.runtime.collection.AbstractValueList;
import com.tplus.transform.runtime.collection.ScaledDecimalSubList;
import com.tplus.transform.runtime.collection.ValueList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class ScaledDecimalList
extends AbstractValueList
implements ValueList,
Serializable,
Comparable,
Cloneable {
    protected int _modCount = 0;
    private transient ScaledDecimal[] _data = null;
    private int _size = 0;

    public ScaledDecimalList() {
        this(8);
    }

    public ScaledDecimalList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("capacity " + initialCapacity);
        }
        this._data = new ScaledDecimal[initialCapacity];
        this._size = 0;
    }

    public ScaledDecimalList(ScaledDecimal[] data) {
        this._data = data;
        this._size = data.length;
    }

    public ScaledDecimalList(ScaledDecimalList list) {
        this._size = list.size();
        this._data = new ScaledDecimal[this._size];
        System.arraycopy(list.getData(), 0, this._data, 0, this._size);
    }

    public ScaledDecimalList add(ScaledDecimal element) {
        this.add(this.size(), element);
        return this;
    }

    public void add(int index, ScaledDecimal element) {
        this.checkRangeIncludingEndpoint(index);
        this.incrModCount();
        this.ensureCapacity(this._size + 1);
        int numtomove = this._size - index;
        System.arraycopy(this._data, index, this._data, index + 1, numtomove);
        this._data[index] = element;
        ++this._size;
    }

    public void add(int index, Object element) {
        this.add(index, this.fromObject(element));
    }

    public ScaledDecimalList addAll(ScaledDecimalList list) {
        for (int i = 0; i < list.size(); ++i) {
            this.add(list.getValue(i));
        }
        return this;
    }

    public ScaledDecimal getValue(int index) {
        this.checkRange(index);
        return this._data[index];
    }

    public Object get(int index) {
        return this.getValue(index);
    }

    public Object toObject(ScaledDecimal val) {
        return val;
    }

    public ScaledDecimal fromObject(Object val) {
        return (ScaledDecimal)val;
    }

    public int size() {
        return this._size;
    }

    public void clear() {
        this.incrModCount();
        this._size = 0;
    }

    public Object remove(int index) {
        return this.toObject(this.removeElementAt(index));
    }

    public ScaledDecimal removeElementAt(int index) {
        this.checkRange(index);
        this.incrModCount();
        ScaledDecimal oldval = this._data[index];
        int numtomove = this._size - index - 1;
        if (numtomove > 0) {
            System.arraycopy(this._data, index + 1, this._data, index, numtomove);
        }
        --this._size;
        return oldval;
    }

    public Object set(int index, Object element) {
        return this.toObject(this.set(index, this.fromObject(element)));
    }

    public ScaledDecimal set(int index, ScaledDecimal element) {
        this.checkRange(index);
        this.incrModCount();
        ScaledDecimal oldval = this._data[index];
        this._data[index] = element;
        return oldval;
    }

    public boolean contains(Object element) {
        return this.indexOf((ScaledDecimal)element) != -1;
    }

    public boolean contains(ScaledDecimal element) {
        return this.indexOf(element) != -1;
    }

    public boolean intersects(ScaledDecimalList thatList) {
        int size = this.size();
        for (int j = 0; j < thatList.size(); ++j) {
            ScaledDecimal element = thatList.getValue(j);
            for (int i = 0; i < size; ++i) {
                if (!ScaledDecimalList.equals(this.getValue(i), element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean equals(ScaledDecimal first, ScaledDecimal second) {
        return first.equals(second);
    }

    public int indexOf(ScaledDecimal element) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!ScaledDecimalList.equals(this.getValue(i), element)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(ScaledDecimal element) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!ScaledDecimalList.equals(this.getValue(i), element)) continue;
            return i;
        }
        return -1;
    }

    public ScaledDecimalList sort() {
        ScaledDecimalList list = new ScaledDecimalList(this);
        Arrays.sort(list.getData(), 0, list.size());
        return list;
    }

    public ScaledDecimalList unique() {
        ScaledDecimalList toRet = new ScaledDecimalList();
        toRet.addIfNoExists(this);
        return toRet;
    }

    public ScaledDecimalList union(ScaledDecimalList thatList) {
        ScaledDecimalList toRet = new ScaledDecimalList();
        toRet.addIfNoExists(this);
        toRet.addIfNoExists(thatList);
        return toRet;
    }

    public ScaledDecimalList intersection(ScaledDecimalList thatList) {
        ScaledDecimalList toRet = new ScaledDecimalList();
        toRet.addIfExistsBoth(this, thatList);
        toRet.addIfExistsBoth(thatList, this);
        return toRet;
    }

    public ScaledDecimalList subtract(ScaledDecimalList thatList) {
        ScaledDecimalList toRet = new ScaledDecimalList();
        ScaledDecimalList firstList = this;
        ScaledDecimalList secondList = thatList;
        int size = firstList.size();
        for (int j = 0; j < size; ++j) {
            ScaledDecimal element = firstList.getValue(j);
            if (secondList.contains(element) || toRet.contains(element)) continue;
            toRet.add(element);
        }
        return toRet;
    }

    public boolean containsAll(ScaledDecimalList thatList) {
        int thatSize = thatList.size();
        for (int i = 0; i < thatSize; ++i) {
            if (this.contains(thatList.getValue(i))) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(ScaledDecimalList thatList) {
        int thatSize = thatList.size();
        for (int i = 0; i < thatSize; ++i) {
            if (!this.contains(thatList.getValue(i))) continue;
            return true;
        }
        return false;
    }

    public boolean equalsAll(ScaledDecimalList thatList) {
        return this.containsAll(thatList) && thatList.containsAll(this);
    }

    private void addIfExistsBoth(ScaledDecimalList firstList, ScaledDecimalList secondList) {
        int size = firstList.size();
        for (int j = 0; j < size; ++j) {
            ScaledDecimal element = firstList.getValue(j);
            if (!secondList.contains(element) || this.contains(element)) continue;
            this.add(element);
        }
    }

    private void addIfNoExists(ScaledDecimalList thatList) {
        int size = thatList.size();
        for (int j = 0; j < size; ++j) {
            ScaledDecimal element = thatList.getValue(j);
            if (this.contains(element)) continue;
            this.add(element);
        }
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof ScaledDecimalList) {
            ScaledDecimalList thatList = (ScaledDecimalList)that;
            if (this.size() != thatList.size()) {
                return false;
            }
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                if (ScaledDecimalList.equals(this.getValue(i), thatList.getValue(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int compareTo(Object that) {
        if (this == that) {
            return 0;
        }
        ScaledDecimalList thatList = (ScaledDecimalList)that;
        int size1 = this.size();
        int size2 = thatList.size();
        int size = Math.min(size1, size2);
        for (int i = 0; i < size; ++i) {
            ScaledDecimal v2;
            ScaledDecimal v1 = this.getValue(i);
            int toRet = v1.compareTo(v2 = thatList.getValue(i));
            if (toRet == 0) continue;
            return toRet;
        }
        return size1 - size2;
    }

    public int hashCode() {
        int hash = 1;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            hash = 31 * hash + this.getValue(i).hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int size = this.size();
        buf.append("[");
        for (int i = 0; i < size; ++i) {
            buf.append(this.getValue(i));
            if (i >= size - 1) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public void ensureCapacity(int mincap) {
        this.incrModCount();
        if (mincap > this._data.length) {
            int newcap = this._data.length * 3 / 2 + 1;
            ScaledDecimal[] olddata = this._data;
            this._data = new ScaledDecimal[newcap < mincap ? mincap : newcap];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        this.incrModCount();
        if (this._size < this._data.length) {
            ScaledDecimal[] olddata = this._data;
            this._data = new ScaledDecimal[this._size];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this._data.length);
        for (int i = 0; i < this._size; ++i) {
            out.writeObject(this._data[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._data = new ScaledDecimal[in.readInt()];
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = (ScaledDecimal)in.readObject();
        }
    }

    private final void checkRange(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this.size() + ", found " + index);
        }
    }

    private final void checkRangeIncludingEndpoint(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this.size() + ", found " + index);
        }
    }

    protected int getModCount() {
        return this._modCount;
    }

    protected void incrModCount() {
        ++this._modCount;
    }

    public ScaledDecimalList subListImpl(int fromIndex, int toIndex) {
        return new ScaledDecimalSubList(this, fromIndex, toIndex);
    }

    public ScaledDecimal[] getData() {
        return this._data;
    }
}

