/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.diff;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectCollectionImpl;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.diff.DiffObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MessageDiffer {
    private static final int REPORT_AT_SECTION_LEVEL = 1;
    private static final int REPORT_AT_FIELD_LEVEL = 2;

    public static DataObjectSection diff(DataObject obj1, DataObject obj2) throws TransformException {
        return MessageDiffer.diff(obj1, obj2, 0);
    }

    public static DataObjectSection diff(DataObject obj1, DataObject obj2, int options) throws TransformException {
        ArrayList toRet = new ArrayList();
        MessageDiffer.diff(obj1, obj2, toRet, options);
        return new DataObjectCollectionImpl(toRet);
    }

    private static void diff(DataObject obj1, DataObject obj2, List toRet, int options) throws TransformException {
        if (!MessageDiffer.verifyMetaInfoEquals(obj1, obj2)) {
            throw new TransformException("Cannot compare unrelated objects");
        }
        DataObjectMetaInfo metaInfo = obj1 != null ? obj1.getMetaInfo() : obj2.getMetaInfo();
        int count = metaInfo.getFieldCount();
        for (int i = 0; i < count; ++i) {
            DiffObject diffObj;
            Object val2;
            FieldMetaInfo fieldMetaInfo = metaInfo.getFieldMetaInfo(i);
            Object val1 = obj1 != null ? obj1.getField(i) : null;
            Object object = val2 = obj2 != null ? obj2.getField(i) : null;
            if (fieldMetaInfo.isSection()) {
                if (val1 instanceof DataObject) {
                    DataObject subObj1 = (DataObject)val1;
                    DataObject subObj2 = (DataObject)val2;
                    MessageDiffer.diff(subObj1, subObj2, toRet, options);
                    continue;
                }
                DataObjectSection section1 = (DataObjectSection)val1;
                DataObjectSection section2 = (DataObjectSection)val2;
                MessageDiffer.diff(section1, section2, toRet, options);
                continue;
            }
            if (val1 != null && val2 != null && val1.equals(val2) || val1 == null && val2 == null) continue;
            String fieldId = MessageDiffer.getFieldID(obj1, obj2, i);
            String fieldName = MessageDiffer.getQualifiedName(obj1, obj2, i);
            if (val1 == null) {
                diffObj = new DiffObject("added", fieldId, fieldName, null, val2.toString());
                toRet.add(diffObj);
                continue;
            }
            if (val2 == null) {
                diffObj = new DiffObject("deleted", fieldId, fieldName, val1.toString(), null);
                toRet.add(diffObj);
                continue;
            }
            if (!MessageDiffer.equals(val1, val2)) continue;
            diffObj = new DiffObject("modified", fieldId, fieldName, val1.toString(), val2.toString());
            toRet.add(diffObj);
        }
    }

    private static boolean equals(Object val1, Object val2) {
        if (val1 instanceof byte[] && val2 instanceof byte[]) {
            return Arrays.equals((byte[])val1, (byte[])val2);
        }
        return !val1.equals(val2);
    }

    private static String getFieldID(DataObject obj1, DataObject obj2, int index) {
        return obj1 != null ? obj1.getFieldID(index) : obj2.getFieldID(index);
    }

    private static String getQualifiedName(DataObject obj1, DataObject obj2, int index) {
        return obj1 != null ? obj1.getQualifiedName(index) : obj2.getQualifiedName(index);
    }

    private static boolean verifyMetaInfoEquals(DataObject obj1, DataObject obj2) {
        if (obj1 != null && obj2 != null) {
            return obj1.getMetaInfo() == obj2.getMetaInfo();
        }
        return true;
    }

    public static void diff(DataObjectSection section1, DataObjectSection section2, List toRet, int options) throws TransformException {
        int count1 = section1 != null ? section1.getElementCount() : 0;
        int count2 = section2 != null ? section2.getElementCount() : 0;
        int maxCount = Math.max(count1, count2);
        for (int i = 0; i < maxCount; ++i) {
            DataObject elm2;
            DataObject elm1 = i < count1 ? section1.getElement(i) : null;
            DataObject dataObject = elm2 = i < count2 ? section2.getElement(i) : null;
            if (elm1 == null && elm2 == null) continue;
            if ((options & 1) != 0 && (elm1 == null || elm2 == null)) {
                String fieldId = elm1 != null ? elm1.getID() : elm2.getID();
                String fieldName = elm1 != null ? elm1.getQualifiedName() : elm2.getQualifiedName();
                String diffType = elm1 != null ? "deleted" : "added";
                DiffObject diffObj = new DiffObject(diffType, fieldId, fieldName, null, null);
                toRet.add(diffObj);
                continue;
            }
            MessageDiffer.diff(elm1, elm2, toRet, options);
        }
    }
}

