/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.etl;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.etl.DataObjectCache;
import com.tplus.transform.runtime.io.DataObjectDataIO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class AbstractDataObjectCache
implements DataObjectCache {
    public abstract long writeData(byte[] var1) throws IOException;

    public abstract byte[] readData(long var1) throws IOException;

    public long write(DataObject obj) throws TransformException {
        byte[] data = this.serialize(obj);
        try {
            return this.writeData(data);
        }
        catch (IOException e) {
            throw new TransformException(e.getMessage(), e);
        }
    }

    public void read(long position, DataObject obj) throws TransformException {
        try {
            byte[] bytes = this.readData(position);
            this.deserialize(bytes, obj);
        }
        catch (IOException e) {
            throw new TransformException(e.getMessage(), e);
        }
    }

    private byte[] serialize(DataObject elm) throws TransformException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream dataOutput = new DataOutputStream(out);
        DataObjectDataIO.serialize(elm, dataOutput);
        byte[] raw = out.toByteArray();
        return raw;
    }

    private void deserialize(byte[] bytes, DataObject obj) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            DataInputStream dataInput = new DataInputStream(bis);
            DataObjectDataIO.parse(obj, dataInput);
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
    }
}

