/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.etl;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectMetaInfoImpl;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.etl.CachedSectionFunctions;
import com.tplus.transform.runtime.etl.DataObjectJoin;
import com.tplus.transform.runtime.etl.SimpleJoinDataObject;
import java.util.ArrayList;

public class AllFieldsJoiner
implements DataObjectJoin {
    DataObjectMetaInfo dataObjectMetaInfo;
    int[] fieldCounts;

    public AllFieldsJoiner(DataObjectSection[] sections) {
        DataObjectMetaInfo[] dataObjectMetaInfos = new DataObjectMetaInfo[sections.length];
        this.fieldCounts = new int[sections.length];
        for (int i = 0; i < sections.length; ++i) {
            DataObjectSection section = sections[i];
            dataObjectMetaInfos[i] = CachedSectionFunctions.getDataObjectMetaInfo(section);
            this.fieldCounts[i] = dataObjectMetaInfos[i].getFieldCount();
        }
        FieldMetaInfo[] fieldMetaInfos = AllFieldsJoiner.getFieldMetaInfos(dataObjectMetaInfos);
        this.dataObjectMetaInfo = new DataObjectMetaInfoImpl("", fieldMetaInfos);
    }

    private void dumpInfo() {
        for (int i = 0; i < this.fieldCounts.length; ++i) {
            int fieldCount = this.fieldCounts[i];
            System.out.println("field count = " + fieldCount);
        }
        System.out.println(((DataObjectMetaInfoImpl)this.dataObjectMetaInfo).toXMLString());
    }

    public DataObject join(DataObject[] objects) {
        DataObject[] clone = (DataObject[])objects.clone();
        return new SimpleJoinDataObject(clone, this.fieldCounts, this.dataObjectMetaInfo);
    }

    static FieldMetaInfo[] getFieldMetaInfos(DataObjectMetaInfo[] dataObjectMetaInfos) throws FieldNotFoundException {
        ArrayList<FieldMetaInfo> toRet = new ArrayList<FieldMetaInfo>();
        for (int i = 0; i < dataObjectMetaInfos.length; ++i) {
            DataObjectMetaInfo metaInfo = dataObjectMetaInfos[i];
            for (int j = 0; j < metaInfo.getFieldCount(); ++j) {
                FieldMetaInfo clone = (FieldMetaInfo)metaInfo.getFieldMetaInfo(j).clone();
                toRet.add(clone);
                clone.setIndex(toRet.size());
            }
        }
        return toRet.toArray(new FieldMetaInfo[toRet.size()]);
    }
}

