/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.etl;

import com.tplus.transform.runtime.etl.DataObjectCache;
import com.tplus.transform.runtime.etl.RecordMemMapFile;
import java.io.File;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class CacheManager {
    static CacheManager cacheManager = new CacheManager();
    ReferenceQueue refQueue = new ReferenceQueue();
    List caches = new ArrayList();
    DataObjectCache globalCache;

    public DataObjectCache getCache(Object owner) throws IOException {
        this.cleanup();
        String vola = File.createTempFile("vola", ".cache").getAbsolutePath();
        if (this.globalCache == null) {
            DataObjectCache cache;
            this.globalCache = cache = this.createCache(owner, vola);
        }
        return this.globalCache;
    }

    private DataObjectCache createCache(Object owner, String fileName) throws IOException {
        RecordMemMapFile dataObjectCache = new RecordMemMapFile(fileName);
        return dataObjectCache;
    }

    public DataObjectCache getCacheFromReference(Object owner, String reference) throws IOException {
        return this.globalCache;
    }

    public static CacheManager getInstance() {
        return cacheManager;
    }

    synchronized void cleanup() {
        RecordCacheWeakReference recordCacheWeakReference;
        while ((recordCacheWeakReference = (RecordCacheWeakReference)this.refQueue.poll()) != null) {
            try {
                this.caches.remove(recordCacheWeakReference);
                recordCacheWeakReference.disposeNative();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void cleanupAll() {
        for (int i = 0; i < this.caches.size(); ++i) {
            RecordCacheWeakReference weakReference = (RecordCacheWeakReference)this.caches.get(i);
            try {
                weakReference.disposeNative();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void finalize() throws Throwable {
        this.cleanupAll();
    }

    static class RecordCacheWeakReference
    extends WeakReference {
        private RecordMemMapFile recordMemMapFile;

        public RecordCacheWeakReference(Object referent, ReferenceQueue q, RecordMemMapFile recordMemMapFile) {
            super(referent, q);
            this.recordMemMapFile = recordMemMapFile;
        }

        public void disposeNative() throws IOException {
            this.recordMemMapFile.close();
            boolean deleted = new File(this.recordMemMapFile.getFileName()).delete();
            System.out.println("Cleaning up cache file " + this.recordMemMapFile.getFileName() + ", deleted = " + deleted);
        }
    }
}

