/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.etl;

import com.tplus.transform.lang.Wrapper;
import com.tplus.transform.runtime.AbstractDataObjectSection;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.SectionMetaInfo;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.collection.LongList;
import com.tplus.transform.runtime.etl.CacheManager;
import com.tplus.transform.runtime.etl.DataObjectCache;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;

public class CachedSection
extends AbstractDataObjectSection {
    public static final String ELEMENT_INDEX = "element-index";
    DataObjectCache dataObjectCache;
    LongList recordList = new LongList(100);
    Class cls;
    DataObject lastElement;

    public CachedSection(DataObject parent, SectionMetaInfo metaInfo) throws IOException {
        super(parent, metaInfo);
    }

    protected CachedSection(DataObject parent, String sectionName, int minOccurs, int maxOccurs) throws IOException {
        super(parent, sectionName, minOccurs, maxOccurs);
    }

    protected CachedSection(DataObject parent, String sectionName, int minOccurs, int maxOccurs, SectionMetaInfo metaInfo) throws IOException {
        super(parent, sectionName, minOccurs, maxOccurs, metaInfo);
    }

    private void init() throws TransformRuntimeException {
        try {
            if (this.dataObjectCache == null) {
                this.dataObjectCache = CacheManager.getInstance().getCache(this);
            }
        }
        catch (IOException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
    }

    public void addElement(DataObject elm) {
        this.flush();
        this.lastElement = elm;
        this.applyIndex(this.lastElement, this.recordList.size());
    }

    private void applyIndex(DataObject lastElement, int elementCount) {
        lastElement.setProperty(ELEMENT_INDEX, Wrapper.box(elementCount));
    }

    private void addElementImpl(DataObject elm) {
        try {
            long location = this.write(elm);
            this.recordList.add(location);
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
    }

    protected void addElement(int index, Object element) {
        throw new IllegalStateException("Not supported");
    }

    protected void setElement(int index, Object element) {
        try {
            this.flush();
            DataObject elm = (DataObject)element;
            long location = this.write(elm);
            this.recordList.set(index, location);
            this.applyIndex(elm, index);
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
    }

    public DataObject getElement(int index) throws FieldNotFoundException {
        if (index < this.recordList.size()) {
            long location = this.recordList.getValue(index);
            DataObject dataObject = this.readRecordAt(location);
            this.applyIndex(dataObject, index);
            return dataObject;
        }
        if (index == this.recordList.size() && this.lastElement != null) {
            return this.lastElement;
        }
        return this.throwFieldNotFound(index);
    }

    public boolean removeElement(int index) throws FieldNotFoundException {
        this.flush();
        if (index < this.recordList.size()) {
            this.recordList.remove(index);
            return true;
        }
        return false;
    }

    public void addAll(DataObjectSection collection) {
        for (int i = 0; i < collection.size(); ++i) {
            DataObject dataObject = (DataObject)collection.get(i);
            this.addElement(dataObject);
        }
    }

    public int getElementIndex(DataObject elm) {
        Object property = elm.getProperty(ELEMENT_INDEX);
        if (property != null) {
            return (Integer)property;
        }
        throw new IllegalStateException("Not supported");
    }

    public int getElementCount() {
        int size = this.recordList.size() + (this.lastElement != null ? 1 : 0);
        return size;
    }

    public void dispose() throws IOException {
    }

    public void clear() {
        this.recordList.clear();
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    private void flush() throws TransformRuntimeException {
        this.init();
        if (this.lastElement != null) {
            this.addElementImpl(this.lastElement);
            this.lastElement = null;
        }
    }

    private DataObject readRecordAt(long location) {
        try {
            return this.read(location);
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
    }

    private long write(DataObject elm) throws TransformException {
        if (this.cls == null) {
            this.cls = elm.getClass();
        }
        return this.dataObjectCache.write(elm);
    }

    private DataObject read(long location) throws TransformException {
        try {
            DataObject elm = (DataObject)this.cls.newInstance();
            this.dataObjectCache.read(location, elm);
            return elm;
        }
        catch (InstantiationException e) {
            throw new TransformException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new TransformException(e.getMessage(), e);
        }
    }

    public void sort(final Comparator comparator) {
        Collections.sort(this.recordList, new Comparator(){

            public int compare(Object o1, Object o2) {
                Long index1 = (Long)o1;
                Long index2 = (Long)o2;
                DataObject element1 = CachedSection.this.readRecordAt(index1);
                DataObject element2 = CachedSection.this.readRecordAt(index2);
                return comparator.compare(element1, element2);
            }
        });
    }

    public void write(DataOutput dataOutput) throws IOException {
        this.flush();
        String name = this.dataObjectCache.getReference();
        int size = this.recordList.size();
        dataOutput.writeUTF(this.cls.getName());
        dataOutput.writeUTF(name);
        dataOutput.writeInt(size);
        for (int i = 0; i < size; ++i) {
            long value = this.recordList.getValue(i);
            dataOutput.writeLong(value);
        }
    }

    public void read(DataInput dataInput) throws IOException {
        this.flush();
        String clsName = dataInput.readUTF();
        try {
            this.cls = Class.forName(clsName);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.getMessage());
        }
        String reference = dataInput.readUTF();
        int size = dataInput.readInt();
        this.dataObjectCache = CacheManager.getInstance().getCacheFromReference(this, reference);
        for (int i = 0; i < size; ++i) {
            long value = dataInput.readLong();
            this.recordList.add(value);
        }
    }
}

