/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.etl;

import com.tplus.transform.runtime.Cacheble;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectBase;
import com.tplus.transform.runtime.DataObjectFilter;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectMetaInfoImpl;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DataObjectSectionImpl;
import com.tplus.transform.runtime.DesignerTypes;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.FieldMetaInfoImpl;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.SectionMetaInfo;
import com.tplus.transform.runtime.SectionMetaInfoImpl;
import com.tplus.transform.runtime.SimpleGenericDataObject;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.etl.DataObjectAggregator;
import com.tplus.transform.runtime.etl.DataObjectTransformer;
import com.tplus.transform.runtime.etl.DualDataObjectSection;
import com.tplus.transform.runtime.formula.SectionHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class CachedSectionFunctions {
    public static final int REMOVE = 0;
    public static final int FIRST = 1;
    public static final int LAST = 2;

    public static final DataObjectSection createCachedSection() throws TransformException {
        return new DualDataObjectSection(null, "Section", 0, -1);
    }

    public static DataObjectSection filter(DataObjectSection sec, DataObjectFilter predicate, DataObjectSection deselect) throws TransformException {
        DataObjectSection filtered = CachedSectionFunctions.createSectionBasedOn(sec);
        for (int i = 0; i < sec.size(); ++i) {
            DataObject dataObject = (DataObject)sec.get(i);
            if (predicate.accept(dataObject)) {
                filtered.addElement(dataObject);
                continue;
            }
            if (deselect == null) continue;
            deselect.addElement(dataObject);
        }
        return filtered;
    }

    public static DataObjectSection secSort(DataObjectSection sec, String sortByField, boolean ascending) throws TransformException {
        return CachedSectionFunctions.secSort(sec, new String[]{sortByField}, new boolean[]{ascending});
    }

    public static DataObjectSection secSort(DataObjectSection sec, final String[] sortByFields, final boolean[] ascending) throws TransformException {
        DataObjectSection output = CachedSectionFunctions.createSectionBasedOn(sec);
        output.addAll(sec);
        final int[] fieldIndex = CachedSectionFunctions.prepareIndex(output, sortByFields);
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                try {
                    DataObject obj1 = (DataObject)o1;
                    DataObject obj2 = (DataObject)o2;
                    for (int i = 0; i < sortByFields.length; ++i) {
                        Object fld2;
                        Object fld1 = obj1.getField(fieldIndex[i]);
                        int toRet = CachedSectionFunctions.compareValue(fld1, fld2 = obj2.getField(fieldIndex[i]));
                        if (toRet == 0) continue;
                        return ascending[i] ? toRet : -toRet;
                    }
                    return 0;
                }
                catch (FieldNotFoundException e) {
                    return 0;
                }
            }
        };
        if (output instanceof DualDataObjectSection) {
            DualDataObjectSection cachedSection = (DualDataObjectSection)output;
            cachedSection.sort(comparator);
        } else {
            Collections.sort(output, comparator);
        }
        return output;
    }

    static int[] prepareIndex(DataObjectSection sec, String[] sortByFields) {
        DataObjectMetaInfo dataObjectMetaInfo = CachedSectionFunctions.getDataObjectMetaInfo(sec);
        int[] fieldIndex = new int[sortByFields.length];
        for (int i = 0; i < sortByFields.length; ++i) {
            String fieldName = sortByFields[i];
            fieldIndex[i] = dataObjectMetaInfo.getFieldIndex(fieldName);
        }
        return fieldIndex;
    }

    public static DataObjectMetaInfo getDataObjectMetaInfo(DataObjectSection sec) {
        DataObjectMetaInfo dataObjectMetaInfo;
        if (sec.size() > 0) {
            dataObjectMetaInfo = sec.getElement(0).getMetaInfo();
        } else {
            SectionMetaInfo sectionMetaInfo = sec.getSectionMetaInfo();
            dataObjectMetaInfo = sectionMetaInfo.getDataObjectMetaInfo();
            if (dataObjectMetaInfo == null) {
                dataObjectMetaInfo = sec.createElement().getMetaInfo();
            }
        }
        return dataObjectMetaInfo;
    }

    public static DataObjectSection deDuplicateSorted(DataObjectSection sec, String[] keyFields, boolean sort, int dedupOption, DataObjectSection duplicates) throws TransformException {
        if (sort) {
            sec = CachedSectionFunctions.sortByFields(sec, keyFields);
        }
        DataObjectSection output = CachedSectionFunctions.createSectionBasedOn(sec);
        int[] fieldIndex = CachedSectionFunctions.prepareIndex(sec, keyFields);
        Object[] lastValues = new Object[keyFields.length];
        Object[] values = new Object[keyFields.length];
        DataObject toAdd = null;
        for (int i = 0; i < sec.size(); ++i) {
            DataObject dataObject = (DataObject)sec.get(i);
            for (int j = 0; j < fieldIndex.length; ++j) {
                Object value;
                int index = fieldIndex[j];
                values[j] = value = dataObject.getField(index);
            }
            if (i > 0 && CachedSectionFunctions.compareValues(lastValues, values)) {
                if (dedupOption == 1) {
                    CachedSectionFunctions.addToDuplicate(duplicates, dataObject);
                    continue;
                }
                if (dedupOption == 2) {
                    CachedSectionFunctions.addToDuplicate(duplicates, toAdd);
                    toAdd = dataObject;
                    continue;
                }
                CachedSectionFunctions.addToDuplicate(duplicates, toAdd);
                CachedSectionFunctions.addToDuplicate(duplicates, dataObject);
                toAdd = null;
                continue;
            }
            if (toAdd != null) {
                output.addElement(toAdd);
            }
            toAdd = dataObject;
            Object[] temp = lastValues;
            lastValues = values;
            values = temp;
        }
        if (toAdd != null) {
            output.addElement(toAdd);
        }
        return output;
    }

    private static void addToDuplicate(DataObjectSection duplicates, DataObject dataObject) {
        if (dataObject != null && duplicates != null) {
            duplicates.addElement(dataObject);
        }
    }

    public static DataObjectSection createSectionBasedOn(DataObjectSection sec) {
        if (sec instanceof Cacheble) {
            return new DualDataObjectSection(sec.getParent(), sec.getSectionMetaInfo());
        }
        return new DataObjectSectionImpl(sec.getParent(), sec.getSectionMetaInfo());
    }

    public static void denormalize(DataObjectSection sec, String normalizedField, String[] denormalizedFields, DataObjectSection outputSec) throws TransformException {
        int[] denormalizedIndexes = CachedSectionFunctions.prepareIndex(outputSec, denormalizedFields);
        DataObjectMetaInfo inputMetaInfo = CachedSectionFunctions.getDataObjectMetaInfo(sec);
        int[] fieldIndex = CachedSectionFunctions.prepareInputFieldIndexes(inputMetaInfo, normalizedField);
        int normalizedFieldIndex = inputMetaInfo.getFieldIndex(normalizedField);
        Object[] lastValues = new Object[fieldIndex.length];
        Object[] values = new Object[fieldIndex.length];
        DataObject outputObject = null;
        int vectorIndex = 0;
        for (int i = 0; i < sec.size(); ++i) {
            boolean newSet;
            DataObject dataObject = (DataObject)sec.get(i);
            for (int j = 0; j < fieldIndex.length; ++j) {
                Object value;
                int index = fieldIndex[j];
                values[j] = value = dataObject.getField(index);
            }
            boolean bl = newSet = i == 0 || !CachedSectionFunctions.compareValues(lastValues, values);
            if (newSet) {
                if (outputObject != null) {
                    outputSec.addElement(outputObject);
                    vectorIndex = 0;
                }
                Object[] temp = lastValues;
                lastValues = values;
                values = temp;
                outputObject = outputSec.createElement();
                DataObjectBase.copyLenient(dataObject, outputObject);
            }
            int destIndex = denormalizedIndexes[vectorIndex];
            outputObject.setField(destIndex, dataObject.getField(normalizedFieldIndex));
            ++vectorIndex;
        }
        if (outputObject != null) {
            outputSec.addElement(outputObject);
        }
    }

    private static int[] prepareInputFieldIndexes(DataObjectMetaInfo inputMetaInfo, String normalizedField) {
        int inputRemaining = inputMetaInfo.getFieldCount() - 1;
        int normalizedFieldIndex = inputMetaInfo.getFieldIndex(normalizedField);
        int[] fieldIndex = new int[inputRemaining];
        int current = 0;
        for (int i = 0; i < inputMetaInfo.getFieldCount(); ++i) {
            if (i == normalizedFieldIndex) continue;
            fieldIndex[current++] = i;
        }
        return fieldIndex;
    }

    public static void normalize(DataObjectSection inputSec, String[] denormalizedFields, String normalizedField, DataObjectSection outputSec) throws TransformException {
        int[] denormalizedIndexes = CachedSectionFunctions.prepareIndex(inputSec, denormalizedFields);
        for (int i = 0; i < inputSec.size(); ++i) {
            DataObject input = inputSec.getElement(i);
            for (int j = 0; j < denormalizedIndexes.length; ++j) {
                int index = denormalizedIndexes[j];
                DataObject output = outputSec.createElement();
                DataObjectBase.copyLenient(input, output);
                output.setField(normalizedField, input.getField(index));
                outputSec.addElement(output);
            }
        }
    }

    private static void copyOtherFields(DataObject input, DataObject output, int[] srcIndexes, int[] destinationIndexes) {
        for (int i = 0; i < srcIndexes.length; ++i) {
            int index = srcIndexes[i];
            Object value = input.getField(index);
            input.getFieldName(index);
            output.setField(destinationIndexes[i], value);
        }
    }

    private static boolean in(int[] denormalizedIndexes, int value) {
        for (int i = 0; i < denormalizedIndexes.length; ++i) {
            int denormalizedIndex = denormalizedIndexes[i];
            if (denormalizedIndex != value) continue;
            return true;
        }
        return false;
    }

    public static DataObjectSection transform(DataObjectSection sec, DataObjectTransformer transformer) throws TransformException {
        DataObjectSection outputSec = CachedSectionFunctions.createSectionBasedOn(sec);
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject obj = sec.getElement(i);
            Object transformed = transformer.transform(obj);
            if (transformed instanceof DataObject) {
                outputSec.add((DataObject)transformed);
            }
            if (!(transformed instanceof DataObjectSection)) continue;
            outputSec.addAll((DataObjectSection)transformed);
        }
        return outputSec;
    }

    public static DataObjectSection aggregate(DataObjectSection sec, String[] groupByFields, boolean sort, DataObjectAggregator aggregator) throws TransformException {
        DataObjectSection outputSec = CachedSectionFunctions.createSectionBasedOn(sec);
        DataObjectSection copied = sec;
        if (sort) {
            copied = CachedSectionFunctions.sortByFields(sec, groupByFields);
        }
        int[] groupByFieldsIndex = new int[groupByFields.length];
        for (int i = 0; i < groupByFields.length; ++i) {
            String byField = groupByFields[i];
            groupByFieldsIndex[i] = CachedSectionFunctions.getFieldIndex(sec, byField);
        }
        Object[] currentSet = new Object[groupByFields.length];
        Object[] previousSet = new Object[groupByFields.length];
        DataObjectSection currentGroup = CachedSectionFunctions.createSectionBasedOn(sec);
        for (int i = 0; i < copied.getElementCount(); ++i) {
            int j;
            DataObject obj = copied.getElement(i);
            for (j = 0; j < groupByFieldsIndex.length; ++j) {
                int index = groupByFieldsIndex[j];
                currentSet[j] = obj.getField(index);
            }
            if (!CachedSectionFunctions.compareValues(previousSet, currentSet)) {
                if (currentGroup.size() > 0) {
                    CachedSectionFunctions.aggregateGroup(currentGroup, outputSec, aggregator);
                }
                currentGroup = CachedSectionFunctions.createSectionBasedOn(sec);
                for (j = 0; j < currentSet.length; ++j) {
                    previousSet[j] = currentSet[j];
                }
            }
            currentGroup.addElement(obj);
        }
        if (currentGroup.size() > 0) {
            CachedSectionFunctions.aggregateGroup(currentGroup, outputSec, aggregator);
        }
        return outputSec;
    }

    private static DataObjectSection sortByFields(DataObjectSection sec, String[] groupByFields) throws TransformException {
        boolean[] ascending = new boolean[groupByFields.length];
        for (int i = 0; i < ascending.length; ++i) {
            ascending[i] = true;
        }
        DataObjectSection copied = CachedSectionFunctions.secSort(sec, groupByFields, ascending);
        return copied;
    }

    private static void aggregateGroup(DataObjectSection currentGroup, DataObjectSection outputSec, DataObjectAggregator aggregator) throws TransformException {
        DataObject output = aggregator.aggregate(currentGroup);
        outputSec.addElement(output);
    }

    public static void fixMetaInfoInSection(DataObjectSection outputSec, DataObject output) {
        SectionMetaInfo sectionMetaInfo;
        if (outputSec.size() == 1 && (sectionMetaInfo = outputSec.getSectionMetaInfo()) instanceof SectionMetaInfoImpl) {
            ((SectionMetaInfoImpl)sectionMetaInfo).setDataObjectMetaInfo(output.getMetaInfo());
        }
    }

    public static DataObjectSection secGroup(DataObjectSection sec, String[] groupByFields, boolean sort) throws TransformException {
        DataObjectSection copied = sec;
        if (sort) {
            copied = CachedSectionFunctions.sortByFields(sec, groupByFields);
        }
        String groupByField = groupByFields[0];
        String groupName = groupByField + "Group";
        ArrayList<FieldMetaInfoImpl> fieldInfoList = new ArrayList<FieldMetaInfoImpl>();
        int[] groupByFieldsIndex = new int[groupByFields.length];
        for (int i = 0; i < groupByFields.length; ++i) {
            String byField = groupByFields[i];
            groupByFieldsIndex[i] = CachedSectionFunctions.getFieldIndex(sec, byField);
            String type = CachedSectionFunctions.getFieldType(sec, groupByFieldsIndex[i]);
            fieldInfoList.add(new FieldMetaInfoImpl(byField, type == null ? DesignerTypes.DESIGNER_STRING_TYPE : type, false, false));
        }
        fieldInfoList.add(new SectionMetaInfoImpl(SectionHelper.getMetaInfo(sec), groupName, 0, -1, false));
        FieldMetaInfo[] fieldInfos = fieldInfoList.toArray(new FieldMetaInfo[fieldInfoList.size()]);
        DataObjectSection resultCollection = CachedSectionFunctions.createSectionBasedOn(sec);
        DataObjectMetaInfoImpl dataObjectMetaInfo = new DataObjectMetaInfoImpl("Grouped", fieldInfos);
        Object[] currentSet = new Object[groupByFields.length];
        Object[] previousSet = new Object[groupByFields.length];
        DataObjectSection currentSection = null;
        SimpleGenericDataObject currentObject = null;
        for (int i = 0; i < copied.getElementCount(); ++i) {
            int j;
            DataObject obj = copied.getElement(i);
            for (j = 0; j < groupByFieldsIndex.length; ++j) {
                int index = groupByFieldsIndex[j];
                currentSet[j] = obj.getField(index);
            }
            if (currentObject == null || !CachedSectionFunctions.compareValues(previousSet, currentSet)) {
                if (currentObject != null) {
                    resultCollection.addElement(currentObject);
                }
                currentObject = new SimpleGenericDataObject(null, dataObjectMetaInfo);
                for (j = 0; j < currentSet.length; ++j) {
                    Object fieldValue = currentSet[j];
                    currentObject.setField(j, fieldValue);
                }
                currentSection = CachedSectionFunctions.createCachedSection();
                currentObject.setField(currentSet.length, (Object)currentSection);
                for (j = 0; j < currentSet.length; ++j) {
                    previousSet[j] = currentSet[j];
                }
            }
            currentSection.addElement(obj);
        }
        if (currentObject != null) {
            resultCollection.addElement(currentObject);
        }
        return resultCollection;
    }

    private static boolean compareValues(Object[] previousSet, Object[] currentSet) {
        for (int i = 0; i < previousSet.length; ++i) {
            Object o1 = previousSet[i];
            Object o2 = currentSet[i];
            if (CachedSectionFunctions.compareValue(o1, o2) == 0) continue;
            return false;
        }
        return true;
    }

    public static int compareValue(Object fld1, Object fld2) {
        int toRet = fld1 == fld2 ? 0 : (fld1 == null ? -1 : (fld2 == null ? 1 : ((Comparable)fld1).compareTo(fld2)));
        return toRet;
    }

    public static int getFieldIndex(DataObjectSection sec, String fieldName) {
        if (sec.getElementCount() > 0) {
            try {
                DataObject obj = sec.getElement(0);
                int index = obj.getFieldIndex(fieldName);
                return index;
            }
            catch (FieldNotFoundException e) {
                throw TransformRuntimeException.createFormatted("SRT577", fieldName);
            }
        }
        return -1;
    }

    public static String getFieldType(DataObjectSection sec, int fieldIndex) {
        if (sec.getElementCount() > 0) {
            try {
                DataObject obj = sec.getElement(0);
                String type = obj.getFieldType(fieldIndex);
                return type;
            }
            catch (FieldNotFoundException e) {
                throw TransformRuntimeException.createFormatted("SRT578", String.valueOf(fieldIndex));
            }
        }
        return null;
    }
}

