/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.etl;

import com.tplus.transform.runtime.Cacheble;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DataObjectSectionImpl;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.SectionConstraintException;
import com.tplus.transform.runtime.SectionMetaInfo;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.etl.CachedSection;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class DualDataObjectSection
implements DataObjectSection,
Cacheble {
    private static final int CAHCE_TRIGGER_SIZE = 10;
    private DataObjectSection delegate;

    public DualDataObjectSection() {
        this.delegate = new DataObjectSectionImpl();
    }

    public DualDataObjectSection(DataObject[] objects) {
        this.delegate = new DataObjectSectionImpl(objects);
    }

    public DualDataObjectSection(DataObject parent, SectionMetaInfo metaInfo) {
        this.delegate = new DataObjectSectionImpl(parent, metaInfo);
    }

    public DualDataObjectSection(DataObject parent, String sectionName, int minOccurs, int maxOccurs) {
        this.delegate = new DataObjectSectionImpl(parent, sectionName, minOccurs, maxOccurs);
    }

    public DataObjectSection getDelegate() {
        return this.delegate;
    }

    public DataObjectSection getDelegateForAdd() {
        try {
            if (this.delegate instanceof DataObjectSectionImpl && this.delegate.size() >= 10) {
                this.toCachedDelegate();
            }
        }
        catch (IOException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        return this.delegate;
    }

    private void toCachedDelegate() throws IOException {
        if (this.delegate instanceof DataObjectSectionImpl) {
            CachedSection newDelegate = new CachedSection(this.delegate.getParent(), ((DataObjectSectionImpl)this.delegate).getSectionName(), this.delegate.getMinOccurs(), this.delegate.getMaxOccurs(), this.delegate.getSectionMetaInfo());
            newDelegate.addAll(this.delegate);
            this.delegate = newDelegate;
        }
    }

    public Object clone() {
        try {
            DualDataObjectSection cloned = (DualDataObjectSection)super.clone();
            cloned.delegate = (DataObjectSection)this.delegate.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public DataObject getElement(int index) throws FieldNotFoundException {
        DataObject element = this.getDelegate().getElement(index);
        element.setParentSection(this);
        return element;
    }

    public boolean removeElement(int index) throws FieldNotFoundException {
        return this.getDelegate().removeElement(index);
    }

    public boolean removeLastElement() throws FieldNotFoundException {
        return this.getDelegate().removeLastElement();
    }

    public DataObject createElement() {
        return this.getDelegate().createElement();
    }

    public void addAll(DataObjectSection collection) {
        this.getDelegateForAdd().addAll(collection);
    }

    public void addElement(DataObject elm) {
        this.getDelegateForAdd().addElement(elm);
        elm.setParentSection(this);
    }

    public int getElementIndex(DataObject elm) {
        return this.getDelegate().getElementIndex(elm);
    }

    public int getElementCount() {
        return this.getDelegate().getElementCount();
    }

    public String getName() {
        return this.getDelegate().getName();
    }

    public String getQualifiedName() {
        return this.getDelegate().getQualifiedName();
    }

    public DataObject getParent() {
        return this.getDelegate().getParent();
    }

    public void setParent(DataObject parent) {
        this.getDelegate().setParent(parent);
    }

    public SectionMetaInfo getSectionMetaInfo() {
        return this.getDelegate().getSectionMetaInfo();
    }

    public DataObject getRootDataObject() {
        return this.getDelegate().getRootDataObject();
    }

    public void assertConstraints() throws SectionConstraintException {
        this.getDelegate().assertConstraints();
    }

    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    public String toXMLString(int indent) {
        return this.getDelegate().toXMLString(indent);
    }

    public String toXMLString() {
        return this.getDelegate().toXMLString();
    }

    public int getMinOccurs() {
        return this.getDelegate().getMinOccurs();
    }

    public int getMaxOccurs() {
        return this.getDelegate().getMaxOccurs();
    }

    public void reset() {
        this.getDelegate().reset();
    }

    public String getID() {
        return this.getDelegate().getID();
    }

    public void fromList(List list) throws TransformException {
        this.getDelegate().fromList(list);
    }

    public void clear() {
        this.getDelegate().clear();
    }

    public boolean add(Object obj) {
        return this.getDelegate().add(obj);
    }

    public boolean contains(Object obj) {
        return this.getDelegate().contains(obj);
    }

    public String toString() {
        return this.getDelegate().toString();
    }

    public int size() {
        return this.getDelegate().size();
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    public Object[] toArray() {
        return this.getDelegate().toArray();
    }

    public Object get(int index) {
        return this.getDelegate().get(index);
    }

    public Object remove(int index) {
        return this.getDelegate().remove(index);
    }

    public void add(int index, Object element) {
        this.getDelegate().add(index, element);
    }

    public int indexOf(Object o) {
        return this.getDelegate().indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.getDelegate().lastIndexOf(o);
    }

    public boolean equals(Object o) {
        return this.getDelegate().equals(o);
    }

    public boolean remove(Object o) {
        return this.getDelegate().remove(o);
    }

    public boolean addAll(int index, Collection c) {
        return this.getDelegate().addAll(index, c);
    }

    public boolean addAll(Collection c) {
        return this.getDelegate().addAll(c);
    }

    public boolean containsAll(Collection c) {
        return this.getDelegate().containsAll(c);
    }

    public boolean removeAll(Collection c) {
        return this.getDelegate().removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.getDelegate().retainAll(c);
    }

    public Iterator iterator() {
        return this.getDelegate().iterator();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.getDelegate().subList(fromIndex, toIndex);
    }

    public ListIterator listIterator() {
        return this.getDelegate().listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.getDelegate().listIterator(index);
    }

    public Object set(int index, Object element) {
        return this.getDelegate().set(index, element);
    }

    public Object[] toArray(Object[] a) {
        return this.getDelegate().toArray(a);
    }

    public void sort(Comparator comparator) {
        if (this.delegate instanceof CachedSection) {
            ((CachedSection)this.delegate).sort(comparator);
        } else {
            DataObjectSectionImpl dataObjectSection = (DataObjectSectionImpl)this.delegate;
            Collections.sort(dataObjectSection, comparator);
        }
    }

    public void write(DataOutput out) throws IOException {
        this.toCachedDelegate();
        CachedSection cachedSection = (CachedSection)this.delegate;
        cachedSection.write(out);
    }

    public void read(DataInput in) throws IOException {
        this.toCachedDelegate();
        CachedSection cachedSection = (CachedSection)this.delegate;
        cachedSection.read(in);
    }
}

