/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.etl;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.etl.AllFieldsJoiner;
import com.tplus.transform.runtime.etl.CachedSectionFunctions;
import com.tplus.transform.runtime.etl.DataObjectJoin;
import com.tplus.transform.runtime.etl.JoinCondition;
import com.tplus.transform.runtime.etl.JoinOut;
import com.tplus.transform.runtime.etl.JoinSingleOut;
import com.tplus.transform.runtime.etl.JoinSource;
import com.tplus.transform.runtime.etl.Joiner;
import com.tplus.transform.runtime.etl.TwoWayJoiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;

public class JoinFunction {
    JoinSource[] inputs;
    JoinCondition[] joinConditions;
    DataObjectJoin dataObjectJoin;
    BitSet[] bitSets;
    boolean[][] emitted;

    public JoinFunction(JoinSource[] inputs, JoinCondition[] joinConditions, DataObjectJoin dataObjectJoin) {
        int i;
        this.inputs = inputs;
        this.bitSets = new BitSet[inputs.length];
        for (i = 0; i < this.bitSets.length; ++i) {
            this.bitSets[i] = new BitSet(inputs[i].getInput().size());
        }
        for (i = 0; i < inputs.length; ++i) {
            JoinSource input = inputs[i];
            DataObjectSection reject = input.getReject();
            if (reject == null) continue;
            reject.clear();
        }
        this.joinConditions = joinConditions;
        this.dataObjectJoin = dataObjectJoin;
        this.emitted = new boolean[inputs.length][];
        for (i = 0; i < this.emitted.length; ++i) {
            this.emitted[i] = new boolean[inputs[i].getInput().size()];
        }
    }

    public DataObjectSection secJoin() throws TransformException {
        if (this.dataObjectJoin == null) {
            this.dataObjectJoin = JoinFunction.createDefaultJoiner(this.inputs);
        }
        JoinCondition[] preparedJoinConditions = JoinFunction.prepare(this.inputs, this.joinConditions);
        DataObjectSection joined = CachedSectionFunctions.createSectionBasedOn(this.inputs[0].getInput());
        Joiner[] joiners = new TwoWayJoiner[preparedJoinConditions.length];
        for (int i = 0; i < joiners.length; ++i) {
            JoinCondition condition = preparedJoinConditions[i];
            joiners[i] = new TwoWayJoiner(condition);
        }
        JoinCondition firstJoinCondition = preparedJoinConditions[0];
        boolean fieldJoin = joiners[0].isFieldJoin();
        NestedJoinOut nestedJoinOut = new NestedJoinOut(firstJoinCondition, this.inputs, preparedJoinConditions, this.dataObjectJoin, joined, joiners);
        if (fieldJoin) {
            ((TwoWayJoiner)joiners[0]).sortMergeJoin(nestedJoinOut);
        } else {
            ((TwoWayJoiner)joiners[0]).nestLoopJoin(nestedJoinOut);
        }
        this.prepareRejects();
        return joined;
    }

    public void prepareRejects() {
        for (int i = 0; i < this.inputs.length; ++i) {
            JoinSource joinSource = this.inputs[i];
            if (joinSource.getReject() == null) continue;
            DataObjectSection reject = joinSource.getReject();
            DataObjectSection input = joinSource.getInput();
            boolean[] emits = this.emitted[i];
            for (int k = 0; k < emits.length; ++k) {
                boolean emit = emits[k];
                if (emit) continue;
                DataObject element = input.getElement(k);
                reject.add(element);
            }
        }
    }

    void emitOutput(DataObject[] outputs, int[] outputIndex, DataObjectJoin finalDataObjectJoin, DataObjectSection joined) throws TransformException {
        int i;
        for (i = 0; i < outputs.length; ++i) {
            DataObject output = outputs[i];
        }
        for (i = 0; i < outputIndex.length; ++i) {
            int index = outputIndex[i];
            if (index == -1) continue;
            boolean[] emit = this.emitted[i];
            emit[index] = true;
        }
        try {
            DataObject join = finalDataObjectJoin.join(outputs);
            joined.addElement(join);
        }
        catch (TransformException e) {
            throw new TransformException("Error executing join mapping. " + e.getMessage(), e);
        }
    }

    private static JoinCondition[] prepare(JoinSource[] inputs, JoinCondition[] joinConditions) {
        int i;
        ArrayList<JoinSource> freeInputs = new ArrayList<JoinSource>(Arrays.asList(inputs));
        ArrayList<JoinCondition> conditions = new ArrayList<JoinCondition>();
        for (i = 0; i < joinConditions.length; ++i) {
            JoinCondition joinCondition = joinConditions[i];
            String input1Name = joinCondition.getInput1();
            int input1Index = JoinFunction.getInputIndex(inputs, input1Name);
            joinCondition.setInputIndex1(input1Index);
            joinCondition.setJoinSource1(inputs[input1Index]);
            String input2Name = joinCondition.getInput2();
            int input2Index = JoinFunction.getInputIndex(inputs, input2Name);
            joinCondition.setInputIndex2(input2Index);
            joinCondition.setJoinSource2(inputs[input2Index]);
            conditions.add(joinCondition);
            freeInputs.remove(inputs[input1Index]);
            freeInputs.remove(inputs[input2Index]);
        }
        for (i = 0; i < freeInputs.size(); ++i) {
            JoinSource joinSource = (JoinSource)freeInputs.get(i);
            String inputName = joinSource.getName();
            if (i == 0 && conditions.size() == 0 && freeInputs.size() > 1) {
                JoinSource joinSource2 = (JoinSource)freeInputs.get(1);
                String inputName2 = joinSource2.getName();
                JoinCondition joinCondition = new JoinCondition(JoinCondition.JoinType.FullOuter, inputName, null, inputName2, null, null);
                joinCondition.setInputIndex1(JoinFunction.getInputIndex(inputs, inputName));
                joinCondition.setJoinSource1(joinSource);
                joinCondition.setInputIndex2(JoinFunction.getInputIndex(inputs, inputName2));
                joinCondition.setJoinSource2(joinSource2);
                conditions.add(joinCondition);
                ++i;
                continue;
            }
            JoinCondition joinCondition = new JoinCondition(JoinCondition.JoinType.FullOuter, null, null, inputName, null, null);
            joinCondition.setInputIndex2(JoinFunction.getInputIndex(inputs, inputName));
            joinCondition.setJoinSource2(joinSource);
            conditions.add(joinCondition);
        }
        return conditions.toArray(new JoinCondition[conditions.size()]);
    }

    private static DataObjectJoin createDefaultJoiner(JoinSource[] inputs) {
        DataObjectSection[] dataObjectSections = new DataObjectSection[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            JoinSource input = inputs[i];
            dataObjectSections[i] = input.getInput();
        }
        AllFieldsJoiner joiner = new AllFieldsJoiner(dataObjectSections);
        return joiner;
    }

    private static JoinSource getInput(JoinSource[] inputs, String name) {
        for (int i = 0; i < inputs.length; ++i) {
            JoinSource input = inputs[i];
            if (!input.getName().equals(name)) continue;
            return input;
        }
        return null;
    }

    private static int getInputIndex(JoinSource[] inputs, String name) {
        for (int i = 0; i < inputs.length; ++i) {
            JoinSource input = inputs[i];
            if (!input.getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    private static boolean canJoin(DataObject dataObject1, DataObject dataObject2, String fieldName1, String fieldName2) {
        Object field2;
        Object field1 = dataObject1.getField(fieldName1);
        return CachedSectionFunctions.compareValue(field1, field2 = dataObject2.getField(fieldName2)) == 0;
    }

    public static DataObjectSection secJoin(JoinSource[] inputs, JoinCondition[] joinConditions, DataObjectJoin dataObjectJoin) throws TransformException {
        JoinFunction joinFunction = new JoinFunction(inputs, joinConditions, dataObjectJoin);
        return joinFunction.secJoin();
    }

    private class NestedJoinOut
    implements JoinOut {
        final DataObject[] outputs;
        int[] outputIndex;
        private final JoinCondition firstJoinCondition;
        private final JoinCondition[] preparedJoinConditions;
        private final DataObjectJoin dataObjectJoin;
        private final DataObjectSection joined;
        private final Joiner[] joiners;

        public NestedJoinOut(JoinCondition firstJoinCondition, JoinSource[] inputs, JoinCondition[] preparedJoinConditions, DataObjectJoin dataObjectJoin, DataObjectSection joined, Joiner[] joiners) {
            this.firstJoinCondition = firstJoinCondition;
            this.preparedJoinConditions = preparedJoinConditions;
            this.dataObjectJoin = dataObjectJoin;
            this.joined = joined;
            this.joiners = joiners;
            this.outputs = new DataObject[inputs.length];
            this.outputIndex = new int[inputs.length];
        }

        public void joinOutput(DataObject first, int firstIndex, DataObject second, int secondIndex) throws TransformException {
            this.outputs[this.firstJoinCondition.getInputIndex1()] = first;
            this.outputs[this.firstJoinCondition.getInputIndex2()] = second;
            this.outputIndex[this.firstJoinCondition.getInputIndex1()] = firstIndex;
            this.outputIndex[this.firstJoinCondition.getInputIndex2()] = secondIndex;
            this.handleNextJoin(1);
        }

        void handleNextJoin(final int index) throws TransformException {
            if (this.preparedJoinConditions.length < index) {
                System.err.println("join condition index error " + index + " more than " + this.preparedJoinConditions.length);
                return;
            }
            if (this.preparedJoinConditions.length == index) {
                JoinFunction.this.emitOutput(this.outputs, this.outputIndex, this.dataObjectJoin, this.joined);
            } else {
                JoinCondition nextJoinCondition = this.preparedJoinConditions[index];
                DataObject nextInput = this.outputs[nextJoinCondition.getInputIndex1()];
                final int inputIndex2 = nextJoinCondition.getInputIndex2();
                if (nextInput == null) {
                    JoinCondition.JoinType joinType = nextJoinCondition.getJoinType();
                    if (joinType == JoinCondition.JoinType.FullOuter || joinType == JoinCondition.JoinType.RightOuter) {
                        this.outputs[inputIndex2] = null;
                        this.handleNextJoin(index + 1);
                    }
                } else {
                    this.joiners[index].loopJoin(nextInput, new JoinSingleOut(){

                        public void joinOutput(DataObject second, int secondIndex) throws TransformException {
                            NestedJoinOut.this.outputs[inputIndex2] = second;
                            NestedJoinOut.this.outputIndex[inputIndex2] = secondIndex;
                            NestedJoinOut.this.handleNextJoin(index + 1);
                        }
                    });
                }
            }
        }
    }
}

