/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.etl;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.etl.CachedSectionFunctions;
import com.tplus.transform.runtime.etl.DataObjectJoinCondition;
import com.tplus.transform.runtime.etl.JoinCondition;
import com.tplus.transform.runtime.etl.JoinSingleOut;
import com.tplus.transform.runtime.etl.JoinSource;
import com.tplus.transform.runtime.etl.ObjectsFieldComparator;
import com.tplus.transform.runtime.etl.Sorter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Joiner {
    int[] fieldIndex1;
    int[] fieldIndex2;
    final Comparator objectsFieldComparator;
    protected JoinCondition joinCondition;

    Joiner(JoinCondition joinCondition) {
        if (joinCondition == null) {
            throw new IllegalArgumentException("Not a valida condition");
        }
        this.joinCondition = joinCondition;
        JoinSource input1Source = joinCondition.getJoinSource1();
        JoinSource input2Source = joinCondition.getJoinSource2();
        if (joinCondition.isFieldJoin()) {
            this.fieldIndex1 = CachedSectionFunctions.prepareIndex(input1Source.getInput(), joinCondition.getInput1Fields());
            this.fieldIndex2 = CachedSectionFunctions.prepareIndex(input2Source.getInput(), joinCondition.getInput2Fields());
            this.objectsFieldComparator = new ObjectsFieldComparator(this.fieldIndex1, this.fieldIndex2);
        } else {
            final DataObjectJoinCondition dataObjectJoinCondition = joinCondition.getJoinCondition();
            this.objectsFieldComparator = dataObjectJoinCondition != null ? new Comparator(){

                public int compare(Object o1, Object o2) {
                    try {
                        boolean accept = dataObjectJoinCondition.accept((DataObject)o1, (DataObject)o2);
                        return accept ? 0 : -1;
                    }
                    catch (TransformException e) {
                        throw new TransformRuntimeException(e.getMessage(), e);
                    }
                }
            } : new Comparator(){

                public int compare(Object o1, Object o2) {
                    return 0;
                }
            };
        }
    }

    public boolean isFieldJoin() {
        return this.joinCondition.isFieldJoin();
    }

    void loopJoin(DataObject source1, JoinSingleOut joiner) throws TransformException {
        JoinSource inputSource = this.joinCondition.getJoinSource2();
        DataObjectSection input = inputSource.getInput();
        int size = input.size();
        boolean match = false;
        if (source1 != null) {
            for (int i = 0; i < size; ++i) {
                DataObject other = input.getElement(i);
                if (this.objectsFieldComparator.compare(source1, other) != 0) continue;
                joiner.joinOutput(other, i);
                match = true;
            }
        }
        if (!(match || this.joinCondition.getJoinType() != JoinCondition.JoinType.LeftOuter && this.joinCondition.getJoinType() != JoinCondition.JoinType.FullOuter)) {
            joiner.joinOutput(null, -1);
        }
    }

    static DataObjectSection createIndex(DataObjectSection input, int[] index, String[] sortByFields) {
        Object[] objects = input.toArray(new DataObject[input.size()]);
        int[] fieldIndex = CachedSectionFunctions.prepareIndex(input, sortByFields);
        new Sorter().quicksort(objects, index, new SortFieldComparator(fieldIndex));
        DataObjectSection sectionBasedOn = CachedSectionFunctions.createSectionBasedOn(input);
        sectionBasedOn.addAll(Arrays.asList(objects));
        return sectionBasedOn;
    }

    static int[] createArray(int length) {
        int[] index = new int[length];
        for (int i = 0; i < index.length; ++i) {
            index[i] = i;
        }
        return index;
    }

    protected static DataObject next(Iterator input1Iterator) {
        if (input1Iterator.hasNext()) {
            return (DataObject)input1Iterator.next();
        }
        return null;
    }

    static class Itr
    implements Iterator,
    Cloneable {
        List list;
        int cursor = 0;
        int lastRet = -1;

        Itr(List list) {
            this.list = list;
        }

        public boolean hasNext() {
            return this.cursor != this.list.size();
        }

        public Object next() {
            try {
                Object next = this.list.get(this.cursor);
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            try {
                this.list.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }

        public int index() {
            return this.lastRet;
        }
    }

    static class SortFieldComparator
    implements Comparator {
        int[] fieldIndex;

        SortFieldComparator(int[] fieldIndex) {
            this.fieldIndex = fieldIndex;
        }

        public int compare(Object o1, Object o2) {
            DataObject obj1 = (DataObject)o1;
            DataObject obj2 = (DataObject)o2;
            for (int i = 0; i < this.fieldIndex.length; ++i) {
                Object field2;
                int index = this.fieldIndex[i];
                Object field1 = obj1.getField(index);
                int cmp = CachedSectionFunctions.compareValue(field1, field2 = obj2.getField(index));
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
    }
}

